/*
 * Decompiled with CFR 0.152.
 */
package com.google.storagetransfer.v1.proto.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.storagetransfer.v1.proto.StorageTransferServiceClient;
import com.google.storagetransfer.v1.proto.TransferProto;
import com.google.storagetransfer.v1.proto.TransferTypes;
import com.google.storagetransfer.v1.proto.stub.GrpcStorageTransferServiceStub;
import com.google.storagetransfer.v1.proto.stub.StorageTransferServiceStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class StorageTransferServiceStubSettings
extends StubSettings<StorageTransferServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<TransferProto.GetGoogleServiceAccountRequest, TransferTypes.GoogleServiceAccount> getGoogleServiceAccountSettings;
    private final UnaryCallSettings<TransferProto.CreateTransferJobRequest, TransferTypes.TransferJob> createTransferJobSettings;
    private final UnaryCallSettings<TransferProto.UpdateTransferJobRequest, TransferTypes.TransferJob> updateTransferJobSettings;
    private final UnaryCallSettings<TransferProto.GetTransferJobRequest, TransferTypes.TransferJob> getTransferJobSettings;
    private final PagedCallSettings<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, StorageTransferServiceClient.ListTransferJobsPagedResponse> listTransferJobsSettings;
    private final UnaryCallSettings<TransferProto.PauseTransferOperationRequest, Empty> pauseTransferOperationSettings;
    private final UnaryCallSettings<TransferProto.ResumeTransferOperationRequest, Empty> resumeTransferOperationSettings;
    private final UnaryCallSettings<TransferProto.RunTransferJobRequest, Operation> runTransferJobSettings;
    private final OperationCallSettings<TransferProto.RunTransferJobRequest, Empty, TransferTypes.TransferOperation> runTransferJobOperationSettings;
    private static final PagedListDescriptor<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob> LIST_TRANSFER_JOBS_PAGE_STR_DESC = new PagedListDescriptor<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob>(){

        public String emptyToken() {
            return "";
        }

        public TransferProto.ListTransferJobsRequest injectToken(TransferProto.ListTransferJobsRequest payload, String token) {
            return TransferProto.ListTransferJobsRequest.newBuilder((TransferProto.ListTransferJobsRequest)payload).setPageToken(token).build();
        }

        public TransferProto.ListTransferJobsRequest injectPageSize(TransferProto.ListTransferJobsRequest payload, int pageSize) {
            return TransferProto.ListTransferJobsRequest.newBuilder((TransferProto.ListTransferJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(TransferProto.ListTransferJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(TransferProto.ListTransferJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferTypes.TransferJob> extractResources(TransferProto.ListTransferJobsResponse payload) {
            return payload.getTransferJobsList() == null ? ImmutableList.of() : payload.getTransferJobsList();
        }
    };
    private static final PagedListResponseFactory<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, StorageTransferServiceClient.ListTransferJobsPagedResponse> LIST_TRANSFER_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, StorageTransferServiceClient.ListTransferJobsPagedResponse>(){

        public ApiFuture<StorageTransferServiceClient.ListTransferJobsPagedResponse> getFuturePagedResponse(UnaryCallable<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse> callable, TransferProto.ListTransferJobsRequest request, ApiCallContext context, ApiFuture<TransferProto.ListTransferJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StorageTransferServiceClient.ListTransferJobsPagedResponse.createAsync((PageContext<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, TransferTypes.TransferJob>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<TransferProto.GetGoogleServiceAccountRequest, TransferTypes.GoogleServiceAccount> getGoogleServiceAccountSettings() {
        return this.getGoogleServiceAccountSettings;
    }

    public UnaryCallSettings<TransferProto.CreateTransferJobRequest, TransferTypes.TransferJob> createTransferJobSettings() {
        return this.createTransferJobSettings;
    }

    public UnaryCallSettings<TransferProto.UpdateTransferJobRequest, TransferTypes.TransferJob> updateTransferJobSettings() {
        return this.updateTransferJobSettings;
    }

    public UnaryCallSettings<TransferProto.GetTransferJobRequest, TransferTypes.TransferJob> getTransferJobSettings() {
        return this.getTransferJobSettings;
    }

    public PagedCallSettings<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, StorageTransferServiceClient.ListTransferJobsPagedResponse> listTransferJobsSettings() {
        return this.listTransferJobsSettings;
    }

    public UnaryCallSettings<TransferProto.PauseTransferOperationRequest, Empty> pauseTransferOperationSettings() {
        return this.pauseTransferOperationSettings;
    }

    public UnaryCallSettings<TransferProto.ResumeTransferOperationRequest, Empty> resumeTransferOperationSettings() {
        return this.resumeTransferOperationSettings;
    }

    public UnaryCallSettings<TransferProto.RunTransferJobRequest, Operation> runTransferJobSettings() {
        return this.runTransferJobSettings;
    }

    public OperationCallSettings<TransferProto.RunTransferJobRequest, Empty, TransferTypes.TransferOperation> runTransferJobOperationSettings() {
        return this.runTransferJobOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public StorageTransferServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStorageTransferServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "storagetransfer.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "storagetransfer.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StorageTransferServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageTransferServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StorageTransferServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getGoogleServiceAccountSettings = settingsBuilder.getGoogleServiceAccountSettings().build();
        this.createTransferJobSettings = settingsBuilder.createTransferJobSettings().build();
        this.updateTransferJobSettings = settingsBuilder.updateTransferJobSettings().build();
        this.getTransferJobSettings = settingsBuilder.getTransferJobSettings().build();
        this.listTransferJobsSettings = settingsBuilder.listTransferJobsSettings().build();
        this.pauseTransferOperationSettings = settingsBuilder.pauseTransferOperationSettings().build();
        this.resumeTransferOperationSettings = settingsBuilder.resumeTransferOperationSettings().build();
        this.runTransferJobSettings = settingsBuilder.runTransferJobSettings().build();
        this.runTransferJobOperationSettings = settingsBuilder.runTransferJobOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StorageTransferServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<TransferProto.GetGoogleServiceAccountRequest, TransferTypes.GoogleServiceAccount> getGoogleServiceAccountSettings;
        private final UnaryCallSettings.Builder<TransferProto.CreateTransferJobRequest, TransferTypes.TransferJob> createTransferJobSettings;
        private final UnaryCallSettings.Builder<TransferProto.UpdateTransferJobRequest, TransferTypes.TransferJob> updateTransferJobSettings;
        private final UnaryCallSettings.Builder<TransferProto.GetTransferJobRequest, TransferTypes.TransferJob> getTransferJobSettings;
        private final PagedCallSettings.Builder<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, StorageTransferServiceClient.ListTransferJobsPagedResponse> listTransferJobsSettings;
        private final UnaryCallSettings.Builder<TransferProto.PauseTransferOperationRequest, Empty> pauseTransferOperationSettings;
        private final UnaryCallSettings.Builder<TransferProto.ResumeTransferOperationRequest, Empty> resumeTransferOperationSettings;
        private final UnaryCallSettings.Builder<TransferProto.RunTransferJobRequest, Operation> runTransferJobSettings;
        private final OperationCallSettings.Builder<TransferProto.RunTransferJobRequest, Empty, TransferTypes.TransferOperation> runTransferJobOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getGoogleServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTransferJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTransferJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTransferJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTransferJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_JOBS_PAGE_STR_FACT);
            this.pauseTransferOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeTransferOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runTransferJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runTransferJobOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getGoogleServiceAccountSettings, this.createTransferJobSettings, this.updateTransferJobSettings, this.getTransferJobSettings, this.listTransferJobsSettings, this.pauseTransferOperationSettings, this.resumeTransferOperationSettings, this.runTransferJobSettings);
            Builder.initDefaults(this);
        }

        protected Builder(StorageTransferServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getGoogleServiceAccountSettings = settings.getGoogleServiceAccountSettings.toBuilder();
            this.createTransferJobSettings = settings.createTransferJobSettings.toBuilder();
            this.updateTransferJobSettings = settings.updateTransferJobSettings.toBuilder();
            this.getTransferJobSettings = settings.getTransferJobSettings.toBuilder();
            this.listTransferJobsSettings = settings.listTransferJobsSettings.toBuilder();
            this.pauseTransferOperationSettings = settings.pauseTransferOperationSettings.toBuilder();
            this.resumeTransferOperationSettings = settings.resumeTransferOperationSettings.toBuilder();
            this.runTransferJobSettings = settings.runTransferJobSettings.toBuilder();
            this.runTransferJobOperationSettings = settings.runTransferJobOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getGoogleServiceAccountSettings, this.createTransferJobSettings, this.updateTransferJobSettings, this.getTransferJobSettings, this.listTransferJobsSettings, this.pauseTransferOperationSettings, this.resumeTransferOperationSettings, this.runTransferJobSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StorageTransferServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StorageTransferServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StorageTransferServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(StorageTransferServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(StorageTransferServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getGoogleServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createTransferJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateTransferJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getTransferJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listTransferJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.pauseTransferOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.resumeTransferOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.runTransferJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.runTransferJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(TransferTypes.TransferOperation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<TransferProto.GetGoogleServiceAccountRequest, TransferTypes.GoogleServiceAccount> getGoogleServiceAccountSettings() {
            return this.getGoogleServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<TransferProto.CreateTransferJobRequest, TransferTypes.TransferJob> createTransferJobSettings() {
            return this.createTransferJobSettings;
        }

        public UnaryCallSettings.Builder<TransferProto.UpdateTransferJobRequest, TransferTypes.TransferJob> updateTransferJobSettings() {
            return this.updateTransferJobSettings;
        }

        public UnaryCallSettings.Builder<TransferProto.GetTransferJobRequest, TransferTypes.TransferJob> getTransferJobSettings() {
            return this.getTransferJobSettings;
        }

        public PagedCallSettings.Builder<TransferProto.ListTransferJobsRequest, TransferProto.ListTransferJobsResponse, StorageTransferServiceClient.ListTransferJobsPagedResponse> listTransferJobsSettings() {
            return this.listTransferJobsSettings;
        }

        public UnaryCallSettings.Builder<TransferProto.PauseTransferOperationRequest, Empty> pauseTransferOperationSettings() {
            return this.pauseTransferOperationSettings;
        }

        public UnaryCallSettings.Builder<TransferProto.ResumeTransferOperationRequest, Empty> resumeTransferOperationSettings() {
            return this.resumeTransferOperationSettings;
        }

        public UnaryCallSettings.Builder<TransferProto.RunTransferJobRequest, Operation> runTransferJobSettings() {
            return this.runTransferJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TransferProto.RunTransferJobRequest, Empty, TransferTypes.TransferOperation> runTransferJobOperationSettings() {
            return this.runTransferJobOperationSettings;
        }

        public StorageTransferServiceStubSettings build() throws IOException {
            return new StorageTransferServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

