/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Strings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.storage.control.v2.AnywhereCache;
import com.google.storage.control.v2.CreateAnywhereCacheMetadata;
import com.google.storage.control.v2.CreateAnywhereCacheRequest;
import com.google.storage.control.v2.CreateFolderRequest;
import com.google.storage.control.v2.CreateManagedFolderRequest;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.DeleteManagedFolderRequest;
import com.google.storage.control.v2.DisableAnywhereCacheRequest;
import com.google.storage.control.v2.Folder;
import com.google.storage.control.v2.GetAnywhereCacheRequest;
import com.google.storage.control.v2.GetFolderIntelligenceConfigRequest;
import com.google.storage.control.v2.GetFolderRequest;
import com.google.storage.control.v2.GetManagedFolderRequest;
import com.google.storage.control.v2.GetOrganizationIntelligenceConfigRequest;
import com.google.storage.control.v2.GetProjectIntelligenceConfigRequest;
import com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.storage.control.v2.IntelligenceConfig;
import com.google.storage.control.v2.ListAnywhereCachesRequest;
import com.google.storage.control.v2.ListAnywhereCachesResponse;
import com.google.storage.control.v2.ListFoldersRequest;
import com.google.storage.control.v2.ListFoldersResponse;
import com.google.storage.control.v2.ListManagedFoldersRequest;
import com.google.storage.control.v2.ListManagedFoldersResponse;
import com.google.storage.control.v2.ManagedFolder;
import com.google.storage.control.v2.PauseAnywhereCacheRequest;
import com.google.storage.control.v2.RenameFolderMetadata;
import com.google.storage.control.v2.RenameFolderRequest;
import com.google.storage.control.v2.ResumeAnywhereCacheRequest;
import com.google.storage.control.v2.StorageControlClient;
import com.google.storage.control.v2.StorageLayout;
import com.google.storage.control.v2.UpdateAnywhereCacheMetadata;
import com.google.storage.control.v2.UpdateAnywhereCacheRequest;
import com.google.storage.control.v2.UpdateFolderIntelligenceConfigRequest;
import com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest;
import com.google.storage.control.v2.UpdateProjectIntelligenceConfigRequest;
import com.google.storage.control.v2.stub.GrpcStorageControlCallableFactory;
import com.google.storage.control.v2.stub.StorageControlStub;
import com.google.storage.control.v2.stub.StorageControlStubSettings;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class GrpcStorageControlStub
extends StorageControlStub {
    private static final MethodDescriptor<CreateFolderRequest, Folder> createFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/CreateFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Folder.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteFolderRequest, Empty> deleteFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/DeleteFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetFolderRequest, Folder> getFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Folder.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListFoldersRequest, ListFoldersResponse> listFoldersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/ListFolders").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFoldersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFoldersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RenameFolderRequest, Operation> renameFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/RenameFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)RenameFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetStorageLayoutRequest, StorageLayout> getStorageLayoutMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetStorageLayout").setRequestMarshaller(ProtoUtils.marshaller((Message)GetStorageLayoutRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StorageLayout.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateManagedFolderRequest, ManagedFolder> createManagedFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/CreateManagedFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateManagedFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ManagedFolder.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteManagedFolderRequest, Empty> deleteManagedFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/DeleteManagedFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteManagedFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetManagedFolderRequest, ManagedFolder> getManagedFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetManagedFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)GetManagedFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ManagedFolder.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListManagedFoldersRequest, ListManagedFoldersResponse> listManagedFoldersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/ListManagedFolders").setRequestMarshaller(ProtoUtils.marshaller((Message)ListManagedFoldersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListManagedFoldersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateAnywhereCacheRequest, Operation> createAnywhereCacheMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/CreateAnywhereCache").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAnywhereCacheRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/UpdateAnywhereCache").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAnywhereCacheRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/DisableAnywhereCache").setRequestMarshaller(ProtoUtils.marshaller((Message)DisableAnywhereCacheRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnywhereCache.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/PauseAnywhereCache").setRequestMarshaller(ProtoUtils.marshaller((Message)PauseAnywhereCacheRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnywhereCache.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/ResumeAnywhereCache").setRequestMarshaller(ProtoUtils.marshaller((Message)ResumeAnywhereCacheRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnywhereCache.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetAnywhereCache").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAnywhereCacheRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnywhereCache.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListAnywhereCachesRequest, ListAnywhereCachesResponse> listAnywhereCachesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/ListAnywhereCaches").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAnywhereCachesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAnywhereCachesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetProjectIntelligenceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProjectIntelligenceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IntelligenceConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/UpdateProjectIntelligenceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProjectIntelligenceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IntelligenceConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetFolderIntelligenceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFolderIntelligenceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IntelligenceConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/UpdateFolderIntelligenceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFolderIntelligenceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IntelligenceConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/GetOrganizationIntelligenceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetOrganizationIntelligenceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IntelligenceConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.control.v2.StorageControl/UpdateOrganizationIntelligenceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateOrganizationIntelligenceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IntelligenceConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateFolderRequest, Folder> createFolderCallable;
    private final UnaryCallable<DeleteFolderRequest, Empty> deleteFolderCallable;
    private final UnaryCallable<GetFolderRequest, Folder> getFolderCallable;
    private final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable;
    private final UnaryCallable<ListFoldersRequest, StorageControlClient.ListFoldersPagedResponse> listFoldersPagedCallable;
    private final UnaryCallable<RenameFolderRequest, Operation> renameFolderCallable;
    private final OperationCallable<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationCallable;
    private final UnaryCallable<GetStorageLayoutRequest, StorageLayout> getStorageLayoutCallable;
    private final UnaryCallable<CreateManagedFolderRequest, ManagedFolder> createManagedFolderCallable;
    private final UnaryCallable<DeleteManagedFolderRequest, Empty> deleteManagedFolderCallable;
    private final UnaryCallable<GetManagedFolderRequest, ManagedFolder> getManagedFolderCallable;
    private final UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersResponse> listManagedFoldersCallable;
    private final UnaryCallable<ListManagedFoldersRequest, StorageControlClient.ListManagedFoldersPagedResponse> listManagedFoldersPagedCallable;
    private final UnaryCallable<CreateAnywhereCacheRequest, Operation> createAnywhereCacheCallable;
    private final OperationCallable<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationCallable;
    private final UnaryCallable<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheCallable;
    private final OperationCallable<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationCallable;
    private final UnaryCallable<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheCallable;
    private final UnaryCallable<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheCallable;
    private final UnaryCallable<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheCallable;
    private final UnaryCallable<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheCallable;
    private final UnaryCallable<ListAnywhereCachesRequest, ListAnywhereCachesResponse> listAnywhereCachesCallable;
    private final UnaryCallable<ListAnywhereCachesRequest, StorageControlClient.ListAnywhereCachesPagedResponse> listAnywhereCachesPagedCallable;
    private final UnaryCallable<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigCallable;
    private final UnaryCallable<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigCallable;
    private final UnaryCallable<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigCallable;
    private final UnaryCallable<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigCallable;
    private final UnaryCallable<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigCallable;
    private final UnaryCallable<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate DELETE_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate LIST_FOLDERS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate RENAME_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_STORAGE_LAYOUT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate CREATE_MANAGED_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate DELETE_MANAGED_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_MANAGED_FOLDER_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate LIST_MANAGED_FOLDERS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate CREATE_ANYWHERE_CACHE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate UPDATE_ANYWHERE_CACHE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate DISABLE_ANYWHERE_CACHE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate PAUSE_ANYWHERE_CACHE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate RESUME_ANYWHERE_CACHE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_ANYWHERE_CACHE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate LIST_ANYWHERE_CACHES_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");

    public static final GrpcStorageControlStub create(StorageControlStubSettings settings) throws IOException {
        return new GrpcStorageControlStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcStorageControlStub create(ClientContext clientContext) throws IOException {
        return new GrpcStorageControlStub(StorageControlStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcStorageControlStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcStorageControlStub(StorageControlStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcStorageControlStub(StorageControlStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcStorageControlCallableFactory());
    }

    protected GrpcStorageControlStub(StorageControlStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", CREATE_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            CreateFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings deleteFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", DELETE_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            DeleteFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings getFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            GetFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings listFoldersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFoldersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", LIST_FOLDERS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings renameFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(renameFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", RENAME_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            RenameFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings getStorageLayoutTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getStorageLayoutMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_STORAGE_LAYOUT_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            GetStorageLayoutRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings createManagedFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createManagedFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", CREATE_MANAGED_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            CreateManagedFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings deleteManagedFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteManagedFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", DELETE_MANAGED_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            DeleteManagedFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings getManagedFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getManagedFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_MANAGED_FOLDER_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            GetManagedFolderRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings listManagedFoldersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listManagedFoldersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", LIST_MANAGED_FOLDERS_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            ListManagedFoldersRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings createAnywhereCacheTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAnywhereCacheMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", CREATE_ANYWHERE_CACHE_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            CreateAnywhereCacheRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings updateAnywhereCacheTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAnywhereCacheMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getAnywhereCache() != null) {
                builder.add(request.getAnywhereCache().getName(), "bucket", UPDATE_ANYWHERE_CACHE_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).setRequestMutator(request -> {
            UpdateAnywhereCacheRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings disableAnywhereCacheTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(disableAnywhereCacheMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", DISABLE_ANYWHERE_CACHE_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            DisableAnywhereCacheRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings pauseAnywhereCacheTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pauseAnywhereCacheMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", PAUSE_ANYWHERE_CACHE_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            PauseAnywhereCacheRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings resumeAnywhereCacheTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resumeAnywhereCacheMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", RESUME_ANYWHERE_CACHE_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            ResumeAnywhereCacheRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings getAnywhereCacheTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAnywhereCacheMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_ANYWHERE_CACHE_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            GetAnywhereCacheRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings listAnywhereCachesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAnywhereCachesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", LIST_ANYWHERE_CACHES_0_PATH_TEMPLATE);
            return builder.build();
        }).setRequestMutator(request -> {
            ListAnywhereCachesRequest.Builder requestBuilder = request.toBuilder();
            if (Strings.isNullOrEmpty((String)request.getRequestId())) {
                requestBuilder.setRequestId(UUID.randomUUID().toString());
            }
            return requestBuilder.build();
        }).build();
        GrpcCallSettings getProjectIntelligenceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProjectIntelligenceConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateProjectIntelligenceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProjectIntelligenceConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("intelligence_config.name", String.valueOf(request.getIntelligenceConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getFolderIntelligenceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFolderIntelligenceConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateFolderIntelligenceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFolderIntelligenceConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("intelligence_config.name", String.valueOf(request.getIntelligenceConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getOrganizationIntelligenceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getOrganizationIntelligenceConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateOrganizationIntelligenceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateOrganizationIntelligenceConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("intelligence_config.name", String.valueOf(request.getIntelligenceConfig().getName()));
            return builder.build();
        }).build();
        this.createFolderCallable = callableFactory.createUnaryCallable(createFolderTransportSettings, settings.createFolderSettings(), clientContext);
        this.deleteFolderCallable = callableFactory.createUnaryCallable(deleteFolderTransportSettings, settings.deleteFolderSettings(), clientContext);
        this.getFolderCallable = callableFactory.createUnaryCallable(getFolderTransportSettings, settings.getFolderSettings(), clientContext);
        this.listFoldersCallable = callableFactory.createUnaryCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.listFoldersPagedCallable = callableFactory.createPagedCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.renameFolderCallable = callableFactory.createUnaryCallable(renameFolderTransportSettings, settings.renameFolderSettings(), clientContext);
        this.renameFolderOperationCallable = callableFactory.createOperationCallable(renameFolderTransportSettings, settings.renameFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getStorageLayoutCallable = callableFactory.createUnaryCallable(getStorageLayoutTransportSettings, settings.getStorageLayoutSettings(), clientContext);
        this.createManagedFolderCallable = callableFactory.createUnaryCallable(createManagedFolderTransportSettings, settings.createManagedFolderSettings(), clientContext);
        this.deleteManagedFolderCallable = callableFactory.createUnaryCallable(deleteManagedFolderTransportSettings, settings.deleteManagedFolderSettings(), clientContext);
        this.getManagedFolderCallable = callableFactory.createUnaryCallable(getManagedFolderTransportSettings, settings.getManagedFolderSettings(), clientContext);
        this.listManagedFoldersCallable = callableFactory.createUnaryCallable(listManagedFoldersTransportSettings, settings.listManagedFoldersSettings(), clientContext);
        this.listManagedFoldersPagedCallable = callableFactory.createPagedCallable(listManagedFoldersTransportSettings, settings.listManagedFoldersSettings(), clientContext);
        this.createAnywhereCacheCallable = callableFactory.createUnaryCallable(createAnywhereCacheTransportSettings, settings.createAnywhereCacheSettings(), clientContext);
        this.createAnywhereCacheOperationCallable = callableFactory.createOperationCallable(createAnywhereCacheTransportSettings, settings.createAnywhereCacheOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateAnywhereCacheCallable = callableFactory.createUnaryCallable(updateAnywhereCacheTransportSettings, settings.updateAnywhereCacheSettings(), clientContext);
        this.updateAnywhereCacheOperationCallable = callableFactory.createOperationCallable(updateAnywhereCacheTransportSettings, settings.updateAnywhereCacheOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.disableAnywhereCacheCallable = callableFactory.createUnaryCallable(disableAnywhereCacheTransportSettings, settings.disableAnywhereCacheSettings(), clientContext);
        this.pauseAnywhereCacheCallable = callableFactory.createUnaryCallable(pauseAnywhereCacheTransportSettings, settings.pauseAnywhereCacheSettings(), clientContext);
        this.resumeAnywhereCacheCallable = callableFactory.createUnaryCallable(resumeAnywhereCacheTransportSettings, settings.resumeAnywhereCacheSettings(), clientContext);
        this.getAnywhereCacheCallable = callableFactory.createUnaryCallable(getAnywhereCacheTransportSettings, settings.getAnywhereCacheSettings(), clientContext);
        this.listAnywhereCachesCallable = callableFactory.createUnaryCallable(listAnywhereCachesTransportSettings, settings.listAnywhereCachesSettings(), clientContext);
        this.listAnywhereCachesPagedCallable = callableFactory.createPagedCallable(listAnywhereCachesTransportSettings, settings.listAnywhereCachesSettings(), clientContext);
        this.getProjectIntelligenceConfigCallable = callableFactory.createUnaryCallable(getProjectIntelligenceConfigTransportSettings, settings.getProjectIntelligenceConfigSettings(), clientContext);
        this.updateProjectIntelligenceConfigCallable = callableFactory.createUnaryCallable(updateProjectIntelligenceConfigTransportSettings, settings.updateProjectIntelligenceConfigSettings(), clientContext);
        this.getFolderIntelligenceConfigCallable = callableFactory.createUnaryCallable(getFolderIntelligenceConfigTransportSettings, settings.getFolderIntelligenceConfigSettings(), clientContext);
        this.updateFolderIntelligenceConfigCallable = callableFactory.createUnaryCallable(updateFolderIntelligenceConfigTransportSettings, settings.updateFolderIntelligenceConfigSettings(), clientContext);
        this.getOrganizationIntelligenceConfigCallable = callableFactory.createUnaryCallable(getOrganizationIntelligenceConfigTransportSettings, settings.getOrganizationIntelligenceConfigSettings(), clientContext);
        this.updateOrganizationIntelligenceConfigCallable = callableFactory.createUnaryCallable(updateOrganizationIntelligenceConfigTransportSettings, settings.updateOrganizationIntelligenceConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateFolderRequest, Folder> createFolderCallable() {
        return this.createFolderCallable;
    }

    @Override
    public UnaryCallable<DeleteFolderRequest, Empty> deleteFolderCallable() {
        return this.deleteFolderCallable;
    }

    @Override
    public UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.getFolderCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.listFoldersCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, StorageControlClient.ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.listFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<RenameFolderRequest, Operation> renameFolderCallable() {
        return this.renameFolderCallable;
    }

    @Override
    public OperationCallable<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationCallable() {
        return this.renameFolderOperationCallable;
    }

    @Override
    public UnaryCallable<GetStorageLayoutRequest, StorageLayout> getStorageLayoutCallable() {
        return this.getStorageLayoutCallable;
    }

    @Override
    public UnaryCallable<CreateManagedFolderRequest, ManagedFolder> createManagedFolderCallable() {
        return this.createManagedFolderCallable;
    }

    @Override
    public UnaryCallable<DeleteManagedFolderRequest, Empty> deleteManagedFolderCallable() {
        return this.deleteManagedFolderCallable;
    }

    @Override
    public UnaryCallable<GetManagedFolderRequest, ManagedFolder> getManagedFolderCallable() {
        return this.getManagedFolderCallable;
    }

    @Override
    public UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersResponse> listManagedFoldersCallable() {
        return this.listManagedFoldersCallable;
    }

    @Override
    public UnaryCallable<ListManagedFoldersRequest, StorageControlClient.ListManagedFoldersPagedResponse> listManagedFoldersPagedCallable() {
        return this.listManagedFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateAnywhereCacheRequest, Operation> createAnywhereCacheCallable() {
        return this.createAnywhereCacheCallable;
    }

    @Override
    public OperationCallable<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationCallable() {
        return this.createAnywhereCacheOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheCallable() {
        return this.updateAnywhereCacheCallable;
    }

    @Override
    public OperationCallable<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationCallable() {
        return this.updateAnywhereCacheOperationCallable;
    }

    @Override
    public UnaryCallable<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheCallable() {
        return this.disableAnywhereCacheCallable;
    }

    @Override
    public UnaryCallable<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheCallable() {
        return this.pauseAnywhereCacheCallable;
    }

    @Override
    public UnaryCallable<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheCallable() {
        return this.resumeAnywhereCacheCallable;
    }

    @Override
    public UnaryCallable<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheCallable() {
        return this.getAnywhereCacheCallable;
    }

    @Override
    public UnaryCallable<ListAnywhereCachesRequest, ListAnywhereCachesResponse> listAnywhereCachesCallable() {
        return this.listAnywhereCachesCallable;
    }

    @Override
    public UnaryCallable<ListAnywhereCachesRequest, StorageControlClient.ListAnywhereCachesPagedResponse> listAnywhereCachesPagedCallable() {
        return this.listAnywhereCachesPagedCallable;
    }

    @Override
    public UnaryCallable<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigCallable() {
        return this.getProjectIntelligenceConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigCallable() {
        return this.updateProjectIntelligenceConfigCallable;
    }

    @Override
    public UnaryCallable<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigCallable() {
        return this.getFolderIntelligenceConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigCallable() {
        return this.updateFolderIntelligenceConfigCallable;
    }

    @Override
    public UnaryCallable<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigCallable() {
        return this.getOrganizationIntelligenceConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigCallable() {
        return this.updateOrganizationIntelligenceConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

