/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v2.BatchRecognizeFileMetadata;
import com.google.cloud.speech.v2.BatchRecognizeRequest;
import com.google.cloud.speech.v2.BatchRecognizeResponse;
import com.google.cloud.speech.v2.Config;
import com.google.cloud.speech.v2.ConfigName;
import com.google.cloud.speech.v2.CreateCustomClassRequest;
import com.google.cloud.speech.v2.CreatePhraseSetRequest;
import com.google.cloud.speech.v2.CreateRecognizerRequest;
import com.google.cloud.speech.v2.CustomClass;
import com.google.cloud.speech.v2.CustomClassName;
import com.google.cloud.speech.v2.DeleteCustomClassRequest;
import com.google.cloud.speech.v2.DeletePhraseSetRequest;
import com.google.cloud.speech.v2.DeleteRecognizerRequest;
import com.google.cloud.speech.v2.GetConfigRequest;
import com.google.cloud.speech.v2.GetCustomClassRequest;
import com.google.cloud.speech.v2.GetPhraseSetRequest;
import com.google.cloud.speech.v2.GetRecognizerRequest;
import com.google.cloud.speech.v2.ListCustomClassesRequest;
import com.google.cloud.speech.v2.ListCustomClassesResponse;
import com.google.cloud.speech.v2.ListPhraseSetsRequest;
import com.google.cloud.speech.v2.ListPhraseSetsResponse;
import com.google.cloud.speech.v2.ListRecognizersRequest;
import com.google.cloud.speech.v2.ListRecognizersResponse;
import com.google.cloud.speech.v2.LocationName;
import com.google.cloud.speech.v2.OperationMetadata;
import com.google.cloud.speech.v2.PhraseSet;
import com.google.cloud.speech.v2.PhraseSetName;
import com.google.cloud.speech.v2.RecognitionConfig;
import com.google.cloud.speech.v2.RecognizeRequest;
import com.google.cloud.speech.v2.RecognizeResponse;
import com.google.cloud.speech.v2.Recognizer;
import com.google.cloud.speech.v2.RecognizerName;
import com.google.cloud.speech.v2.SpeechSettings;
import com.google.cloud.speech.v2.StreamingRecognizeRequest;
import com.google.cloud.speech.v2.StreamingRecognizeResponse;
import com.google.cloud.speech.v2.UndeleteCustomClassRequest;
import com.google.cloud.speech.v2.UndeletePhraseSetRequest;
import com.google.cloud.speech.v2.UndeleteRecognizerRequest;
import com.google.cloud.speech.v2.UpdateConfigRequest;
import com.google.cloud.speech.v2.UpdateCustomClassRequest;
import com.google.cloud.speech.v2.UpdatePhraseSetRequest;
import com.google.cloud.speech.v2.UpdateRecognizerRequest;
import com.google.cloud.speech.v2.stub.SpeechStub;
import com.google.cloud.speech.v2.stub.SpeechStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SpeechClient
implements BackgroundResource {
    private final SpeechSettings settings;
    private final SpeechStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SpeechClient create() throws IOException {
        return SpeechClient.create(SpeechSettings.newBuilder().build());
    }

    public static final SpeechClient create(SpeechSettings settings) throws IOException {
        return new SpeechClient(settings);
    }

    public static final SpeechClient create(SpeechStub stub) {
        return new SpeechClient(stub);
    }

    protected SpeechClient(SpeechSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpeechStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SpeechClient(SpeechStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SpeechSettings getSettings() {
        return this.settings;
    }

    public SpeechStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Recognizer, OperationMetadata> createRecognizerAsync(LocationName parent, Recognizer recognizer, String recognizerId) {
        CreateRecognizerRequest request = CreateRecognizerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRecognizer(recognizer).setRecognizerId(recognizerId).build();
        return this.createRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> createRecognizerAsync(String parent, Recognizer recognizer, String recognizerId) {
        CreateRecognizerRequest request = CreateRecognizerRequest.newBuilder().setParent(parent).setRecognizer(recognizer).setRecognizerId(recognizerId).build();
        return this.createRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> createRecognizerAsync(CreateRecognizerRequest request) {
        return this.createRecognizerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRecognizerRequest, Recognizer, OperationMetadata> createRecognizerOperationCallable() {
        return this.stub.createRecognizerOperationCallable();
    }

    public final UnaryCallable<CreateRecognizerRequest, Operation> createRecognizerCallable() {
        return this.stub.createRecognizerCallable();
    }

    public final ListRecognizersPagedResponse listRecognizers(LocationName parent) {
        ListRecognizersRequest request = ListRecognizersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRecognizers(request);
    }

    public final ListRecognizersPagedResponse listRecognizers(String parent) {
        ListRecognizersRequest request = ListRecognizersRequest.newBuilder().setParent(parent).build();
        return this.listRecognizers(request);
    }

    public final ListRecognizersPagedResponse listRecognizers(ListRecognizersRequest request) {
        return (ListRecognizersPagedResponse)((Object)this.listRecognizersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRecognizersRequest, ListRecognizersPagedResponse> listRecognizersPagedCallable() {
        return this.stub.listRecognizersPagedCallable();
    }

    public final UnaryCallable<ListRecognizersRequest, ListRecognizersResponse> listRecognizersCallable() {
        return this.stub.listRecognizersCallable();
    }

    public final Recognizer getRecognizer(RecognizerName name) {
        GetRecognizerRequest request = GetRecognizerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRecognizer(request);
    }

    public final Recognizer getRecognizer(String name) {
        GetRecognizerRequest request = GetRecognizerRequest.newBuilder().setName(name).build();
        return this.getRecognizer(request);
    }

    public final Recognizer getRecognizer(GetRecognizerRequest request) {
        return (Recognizer)this.getRecognizerCallable().call((Object)request);
    }

    public final UnaryCallable<GetRecognizerRequest, Recognizer> getRecognizerCallable() {
        return this.stub.getRecognizerCallable();
    }

    public final OperationFuture<Recognizer, OperationMetadata> updateRecognizerAsync(Recognizer recognizer, FieldMask updateMask) {
        UpdateRecognizerRequest request = UpdateRecognizerRequest.newBuilder().setRecognizer(recognizer).setUpdateMask(updateMask).build();
        return this.updateRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> updateRecognizerAsync(UpdateRecognizerRequest request) {
        return this.updateRecognizerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRecognizerRequest, Recognizer, OperationMetadata> updateRecognizerOperationCallable() {
        return this.stub.updateRecognizerOperationCallable();
    }

    public final UnaryCallable<UpdateRecognizerRequest, Operation> updateRecognizerCallable() {
        return this.stub.updateRecognizerCallable();
    }

    public final OperationFuture<Recognizer, OperationMetadata> deleteRecognizerAsync(RecognizerName name) {
        DeleteRecognizerRequest request = DeleteRecognizerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> deleteRecognizerAsync(String name) {
        DeleteRecognizerRequest request = DeleteRecognizerRequest.newBuilder().setName(name).build();
        return this.deleteRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> deleteRecognizerAsync(DeleteRecognizerRequest request) {
        return this.deleteRecognizerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRecognizerRequest, Recognizer, OperationMetadata> deleteRecognizerOperationCallable() {
        return this.stub.deleteRecognizerOperationCallable();
    }

    public final UnaryCallable<DeleteRecognizerRequest, Operation> deleteRecognizerCallable() {
        return this.stub.deleteRecognizerCallable();
    }

    public final OperationFuture<Recognizer, OperationMetadata> undeleteRecognizerAsync(RecognizerName name) {
        UndeleteRecognizerRequest request = UndeleteRecognizerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeleteRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> undeleteRecognizerAsync(String name) {
        UndeleteRecognizerRequest request = UndeleteRecognizerRequest.newBuilder().setName(name).build();
        return this.undeleteRecognizerAsync(request);
    }

    public final OperationFuture<Recognizer, OperationMetadata> undeleteRecognizerAsync(UndeleteRecognizerRequest request) {
        return this.undeleteRecognizerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteRecognizerRequest, Recognizer, OperationMetadata> undeleteRecognizerOperationCallable() {
        return this.stub.undeleteRecognizerOperationCallable();
    }

    public final UnaryCallable<UndeleteRecognizerRequest, Operation> undeleteRecognizerCallable() {
        return this.stub.undeleteRecognizerCallable();
    }

    public final RecognizeResponse recognize(RecognizerName recognizer, RecognitionConfig config, FieldMask configMask, ByteString content) {
        RecognizeRequest request = RecognizeRequest.newBuilder().setRecognizer(recognizer == null ? null : recognizer.toString()).setConfig(config).setConfigMask(configMask).setContent(content).build();
        return this.recognize(request);
    }

    public final RecognizeResponse recognize(RecognizerName recognizer, RecognitionConfig config, FieldMask configMask, String uri) {
        RecognizeRequest request = RecognizeRequest.newBuilder().setRecognizer(recognizer == null ? null : recognizer.toString()).setConfig(config).setConfigMask(configMask).setUri(uri).build();
        return this.recognize(request);
    }

    public final RecognizeResponse recognize(String recognizer, RecognitionConfig config, FieldMask configMask, ByteString content) {
        RecognizeRequest request = RecognizeRequest.newBuilder().setRecognizer(recognizer).setConfig(config).setConfigMask(configMask).setContent(content).build();
        return this.recognize(request);
    }

    public final RecognizeResponse recognize(String recognizer, RecognitionConfig config, FieldMask configMask, String uri) {
        RecognizeRequest request = RecognizeRequest.newBuilder().setRecognizer(recognizer).setConfig(config).setConfigMask(configMask).setUri(uri).build();
        return this.recognize(request);
    }

    public final RecognizeResponse recognize(RecognizeRequest request) {
        return (RecognizeResponse)this.recognizeCallable().call((Object)request);
    }

    public final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.stub.recognizeCallable();
    }

    public final BidiStreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.stub.streamingRecognizeCallable();
    }

    public final OperationFuture<BatchRecognizeResponse, OperationMetadata> batchRecognizeAsync(RecognizerName recognizer, RecognitionConfig config, FieldMask configMask, List<BatchRecognizeFileMetadata> files) {
        BatchRecognizeRequest request = BatchRecognizeRequest.newBuilder().setRecognizer(recognizer == null ? null : recognizer.toString()).setConfig(config).setConfigMask(configMask).addAllFiles(files).build();
        return this.batchRecognizeAsync(request);
    }

    public final OperationFuture<BatchRecognizeResponse, OperationMetadata> batchRecognizeAsync(String recognizer, RecognitionConfig config, FieldMask configMask, List<BatchRecognizeFileMetadata> files) {
        BatchRecognizeRequest request = BatchRecognizeRequest.newBuilder().setRecognizer(recognizer).setConfig(config).setConfigMask(configMask).addAllFiles(files).build();
        return this.batchRecognizeAsync(request);
    }

    public final OperationFuture<BatchRecognizeResponse, OperationMetadata> batchRecognizeAsync(BatchRecognizeRequest request) {
        return this.batchRecognizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchRecognizeRequest, BatchRecognizeResponse, OperationMetadata> batchRecognizeOperationCallable() {
        return this.stub.batchRecognizeOperationCallable();
    }

    public final UnaryCallable<BatchRecognizeRequest, Operation> batchRecognizeCallable() {
        return this.stub.batchRecognizeCallable();
    }

    public final Config getConfig(ConfigName name) {
        GetConfigRequest request = GetConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConfig(request);
    }

    public final Config getConfig(String name) {
        GetConfigRequest request = GetConfigRequest.newBuilder().setName(name).build();
        return this.getConfig(request);
    }

    public final Config getConfig(GetConfigRequest request) {
        return (Config)this.getConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetConfigRequest, Config> getConfigCallable() {
        return this.stub.getConfigCallable();
    }

    public final Config updateConfig(Config config, FieldMask updateMask) {
        UpdateConfigRequest request = UpdateConfigRequest.newBuilder().setConfig(config).setUpdateMask(updateMask).build();
        return this.updateConfig(request);
    }

    public final Config updateConfig(UpdateConfigRequest request) {
        return (Config)this.updateConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConfigRequest, Config> updateConfigCallable() {
        return this.stub.updateConfigCallable();
    }

    public final OperationFuture<CustomClass, OperationMetadata> createCustomClassAsync(LocationName parent, CustomClass customClass, String customClassId) {
        CreateCustomClassRequest request = CreateCustomClassRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomClass(customClass).setCustomClassId(customClassId).build();
        return this.createCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> createCustomClassAsync(String parent, CustomClass customClass, String customClassId) {
        CreateCustomClassRequest request = CreateCustomClassRequest.newBuilder().setParent(parent).setCustomClass(customClass).setCustomClassId(customClassId).build();
        return this.createCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> createCustomClassAsync(CreateCustomClassRequest request) {
        return this.createCustomClassOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCustomClassRequest, CustomClass, OperationMetadata> createCustomClassOperationCallable() {
        return this.stub.createCustomClassOperationCallable();
    }

    public final UnaryCallable<CreateCustomClassRequest, Operation> createCustomClassCallable() {
        return this.stub.createCustomClassCallable();
    }

    public final ListCustomClassesPagedResponse listCustomClasses(LocationName parent) {
        ListCustomClassesRequest request = ListCustomClassesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomClasses(request);
    }

    public final ListCustomClassesPagedResponse listCustomClasses(String parent) {
        ListCustomClassesRequest request = ListCustomClassesRequest.newBuilder().setParent(parent).build();
        return this.listCustomClasses(request);
    }

    public final ListCustomClassesPagedResponse listCustomClasses(ListCustomClassesRequest request) {
        return (ListCustomClassesPagedResponse)((Object)this.listCustomClassesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomClassesRequest, ListCustomClassesPagedResponse> listCustomClassesPagedCallable() {
        return this.stub.listCustomClassesPagedCallable();
    }

    public final UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable() {
        return this.stub.listCustomClassesCallable();
    }

    public final CustomClass getCustomClass(CustomClassName name) {
        GetCustomClassRequest request = GetCustomClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomClass(request);
    }

    public final CustomClass getCustomClass(String name) {
        GetCustomClassRequest request = GetCustomClassRequest.newBuilder().setName(name).build();
        return this.getCustomClass(request);
    }

    public final CustomClass getCustomClass(GetCustomClassRequest request) {
        return (CustomClass)this.getCustomClassCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable() {
        return this.stub.getCustomClassCallable();
    }

    public final OperationFuture<CustomClass, OperationMetadata> updateCustomClassAsync(CustomClass customClass, FieldMask updateMask) {
        UpdateCustomClassRequest request = UpdateCustomClassRequest.newBuilder().setCustomClass(customClass).setUpdateMask(updateMask).build();
        return this.updateCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> updateCustomClassAsync(UpdateCustomClassRequest request) {
        return this.updateCustomClassOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCustomClassRequest, CustomClass, OperationMetadata> updateCustomClassOperationCallable() {
        return this.stub.updateCustomClassOperationCallable();
    }

    public final UnaryCallable<UpdateCustomClassRequest, Operation> updateCustomClassCallable() {
        return this.stub.updateCustomClassCallable();
    }

    public final OperationFuture<CustomClass, OperationMetadata> deleteCustomClassAsync(CustomClassName name) {
        DeleteCustomClassRequest request = DeleteCustomClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> deleteCustomClassAsync(String name) {
        DeleteCustomClassRequest request = DeleteCustomClassRequest.newBuilder().setName(name).build();
        return this.deleteCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> deleteCustomClassAsync(DeleteCustomClassRequest request) {
        return this.deleteCustomClassOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCustomClassRequest, CustomClass, OperationMetadata> deleteCustomClassOperationCallable() {
        return this.stub.deleteCustomClassOperationCallable();
    }

    public final UnaryCallable<DeleteCustomClassRequest, Operation> deleteCustomClassCallable() {
        return this.stub.deleteCustomClassCallable();
    }

    public final OperationFuture<CustomClass, OperationMetadata> undeleteCustomClassAsync(CustomClassName name) {
        UndeleteCustomClassRequest request = UndeleteCustomClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeleteCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> undeleteCustomClassAsync(String name) {
        UndeleteCustomClassRequest request = UndeleteCustomClassRequest.newBuilder().setName(name).build();
        return this.undeleteCustomClassAsync(request);
    }

    public final OperationFuture<CustomClass, OperationMetadata> undeleteCustomClassAsync(UndeleteCustomClassRequest request) {
        return this.undeleteCustomClassOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteCustomClassRequest, CustomClass, OperationMetadata> undeleteCustomClassOperationCallable() {
        return this.stub.undeleteCustomClassOperationCallable();
    }

    public final UnaryCallable<UndeleteCustomClassRequest, Operation> undeleteCustomClassCallable() {
        return this.stub.undeleteCustomClassCallable();
    }

    public final OperationFuture<PhraseSet, OperationMetadata> createPhraseSetAsync(LocationName parent, PhraseSet phraseSet, String phraseSetId) {
        CreatePhraseSetRequest request = CreatePhraseSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPhraseSet(phraseSet).setPhraseSetId(phraseSetId).build();
        return this.createPhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> createPhraseSetAsync(String parent, PhraseSet phraseSet, String phraseSetId) {
        CreatePhraseSetRequest request = CreatePhraseSetRequest.newBuilder().setParent(parent).setPhraseSet(phraseSet).setPhraseSetId(phraseSetId).build();
        return this.createPhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> createPhraseSetAsync(CreatePhraseSetRequest request) {
        return this.createPhraseSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePhraseSetRequest, PhraseSet, OperationMetadata> createPhraseSetOperationCallable() {
        return this.stub.createPhraseSetOperationCallable();
    }

    public final UnaryCallable<CreatePhraseSetRequest, Operation> createPhraseSetCallable() {
        return this.stub.createPhraseSetCallable();
    }

    public final ListPhraseSetsPagedResponse listPhraseSets(LocationName parent) {
        ListPhraseSetsRequest request = ListPhraseSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPhraseSets(request);
    }

    public final ListPhraseSetsPagedResponse listPhraseSets(String parent) {
        ListPhraseSetsRequest request = ListPhraseSetsRequest.newBuilder().setParent(parent).build();
        return this.listPhraseSets(request);
    }

    public final ListPhraseSetsPagedResponse listPhraseSets(ListPhraseSetsRequest request) {
        return (ListPhraseSetsPagedResponse)((Object)this.listPhraseSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsPagedResponse> listPhraseSetsPagedCallable() {
        return this.stub.listPhraseSetsPagedCallable();
    }

    public final UnaryCallable<ListPhraseSetsRequest, ListPhraseSetsResponse> listPhraseSetsCallable() {
        return this.stub.listPhraseSetsCallable();
    }

    public final PhraseSet getPhraseSet(PhraseSetName name) {
        GetPhraseSetRequest request = GetPhraseSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPhraseSet(request);
    }

    public final PhraseSet getPhraseSet(String name) {
        GetPhraseSetRequest request = GetPhraseSetRequest.newBuilder().setName(name).build();
        return this.getPhraseSet(request);
    }

    public final PhraseSet getPhraseSet(GetPhraseSetRequest request) {
        return (PhraseSet)this.getPhraseSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable() {
        return this.stub.getPhraseSetCallable();
    }

    public final OperationFuture<PhraseSet, OperationMetadata> updatePhraseSetAsync(PhraseSet phraseSet, FieldMask updateMask) {
        UpdatePhraseSetRequest request = UpdatePhraseSetRequest.newBuilder().setPhraseSet(phraseSet).setUpdateMask(updateMask).build();
        return this.updatePhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> updatePhraseSetAsync(UpdatePhraseSetRequest request) {
        return this.updatePhraseSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePhraseSetRequest, PhraseSet, OperationMetadata> updatePhraseSetOperationCallable() {
        return this.stub.updatePhraseSetOperationCallable();
    }

    public final UnaryCallable<UpdatePhraseSetRequest, Operation> updatePhraseSetCallable() {
        return this.stub.updatePhraseSetCallable();
    }

    public final OperationFuture<PhraseSet, OperationMetadata> deletePhraseSetAsync(PhraseSetName name) {
        DeletePhraseSetRequest request = DeletePhraseSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> deletePhraseSetAsync(String name) {
        DeletePhraseSetRequest request = DeletePhraseSetRequest.newBuilder().setName(name).build();
        return this.deletePhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> deletePhraseSetAsync(DeletePhraseSetRequest request) {
        return this.deletePhraseSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePhraseSetRequest, PhraseSet, OperationMetadata> deletePhraseSetOperationCallable() {
        return this.stub.deletePhraseSetOperationCallable();
    }

    public final UnaryCallable<DeletePhraseSetRequest, Operation> deletePhraseSetCallable() {
        return this.stub.deletePhraseSetCallable();
    }

    public final OperationFuture<PhraseSet, OperationMetadata> undeletePhraseSetAsync(PhraseSetName name) {
        UndeletePhraseSetRequest request = UndeletePhraseSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeletePhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> undeletePhraseSetAsync(String name) {
        UndeletePhraseSetRequest request = UndeletePhraseSetRequest.newBuilder().setName(name).build();
        return this.undeletePhraseSetAsync(request);
    }

    public final OperationFuture<PhraseSet, OperationMetadata> undeletePhraseSetAsync(UndeletePhraseSetRequest request) {
        return this.undeletePhraseSetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeletePhraseSetRequest, PhraseSet, OperationMetadata> undeletePhraseSetOperationCallable() {
        return this.stub.undeletePhraseSetOperationCallable();
    }

    public final UnaryCallable<UndeletePhraseSetRequest, Operation> undeletePhraseSetCallable() {
        return this.stub.undeletePhraseSetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPhraseSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet, ListPhraseSetsPage, ListPhraseSetsFixedSizeCollection> {
        private ListPhraseSetsFixedSizeCollection(List<ListPhraseSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPhraseSetsFixedSizeCollection createEmptyCollection() {
            return new ListPhraseSetsFixedSizeCollection(null, 0);
        }

        protected ListPhraseSetsFixedSizeCollection createCollection(List<ListPhraseSetsPage> pages, int collectionSize) {
            return new ListPhraseSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPhraseSetsPage
    extends AbstractPage<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet, ListPhraseSetsPage> {
        private ListPhraseSetsPage(PageContext<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet> context, ListPhraseSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListPhraseSetsPage createEmptyPage() {
            return new ListPhraseSetsPage(null, null);
        }

        protected ListPhraseSetsPage createPage(PageContext<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet> context, ListPhraseSetsResponse response) {
            return new ListPhraseSetsPage(context, response);
        }

        public ApiFuture<ListPhraseSetsPage> createPageAsync(PageContext<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet> context, ApiFuture<ListPhraseSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPhraseSetsPagedResponse
    extends AbstractPagedListResponse<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet, ListPhraseSetsPage, ListPhraseSetsFixedSizeCollection> {
        public static ApiFuture<ListPhraseSetsPagedResponse> createAsync(PageContext<ListPhraseSetsRequest, ListPhraseSetsResponse, PhraseSet> context, ApiFuture<ListPhraseSetsResponse> futureResponse) {
            ApiFuture<ListPhraseSetsPage> futurePage = ListPhraseSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPhraseSetsPagedResponse((ListPhraseSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPhraseSetsPagedResponse(ListPhraseSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPhraseSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCustomClassesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass, ListCustomClassesPage, ListCustomClassesFixedSizeCollection> {
        private ListCustomClassesFixedSizeCollection(List<ListCustomClassesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomClassesFixedSizeCollection createEmptyCollection() {
            return new ListCustomClassesFixedSizeCollection(null, 0);
        }

        protected ListCustomClassesFixedSizeCollection createCollection(List<ListCustomClassesPage> pages, int collectionSize) {
            return new ListCustomClassesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomClassesPage
    extends AbstractPage<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass, ListCustomClassesPage> {
        private ListCustomClassesPage(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ListCustomClassesResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomClassesPage createEmptyPage() {
            return new ListCustomClassesPage(null, null);
        }

        protected ListCustomClassesPage createPage(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ListCustomClassesResponse response) {
            return new ListCustomClassesPage(context, response);
        }

        public ApiFuture<ListCustomClassesPage> createPageAsync(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ApiFuture<ListCustomClassesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomClassesPagedResponse
    extends AbstractPagedListResponse<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass, ListCustomClassesPage, ListCustomClassesFixedSizeCollection> {
        public static ApiFuture<ListCustomClassesPagedResponse> createAsync(PageContext<ListCustomClassesRequest, ListCustomClassesResponse, CustomClass> context, ApiFuture<ListCustomClassesResponse> futureResponse) {
            ApiFuture<ListCustomClassesPage> futurePage = ListCustomClassesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomClassesPagedResponse((ListCustomClassesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomClassesPagedResponse(ListCustomClassesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomClassesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRecognizersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRecognizersRequest, ListRecognizersResponse, Recognizer, ListRecognizersPage, ListRecognizersFixedSizeCollection> {
        private ListRecognizersFixedSizeCollection(List<ListRecognizersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRecognizersFixedSizeCollection createEmptyCollection() {
            return new ListRecognizersFixedSizeCollection(null, 0);
        }

        protected ListRecognizersFixedSizeCollection createCollection(List<ListRecognizersPage> pages, int collectionSize) {
            return new ListRecognizersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRecognizersPage
    extends AbstractPage<ListRecognizersRequest, ListRecognizersResponse, Recognizer, ListRecognizersPage> {
        private ListRecognizersPage(PageContext<ListRecognizersRequest, ListRecognizersResponse, Recognizer> context, ListRecognizersResponse response) {
            super(context, (Object)response);
        }

        private static ListRecognizersPage createEmptyPage() {
            return new ListRecognizersPage(null, null);
        }

        protected ListRecognizersPage createPage(PageContext<ListRecognizersRequest, ListRecognizersResponse, Recognizer> context, ListRecognizersResponse response) {
            return new ListRecognizersPage(context, response);
        }

        public ApiFuture<ListRecognizersPage> createPageAsync(PageContext<ListRecognizersRequest, ListRecognizersResponse, Recognizer> context, ApiFuture<ListRecognizersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRecognizersPagedResponse
    extends AbstractPagedListResponse<ListRecognizersRequest, ListRecognizersResponse, Recognizer, ListRecognizersPage, ListRecognizersFixedSizeCollection> {
        public static ApiFuture<ListRecognizersPagedResponse> createAsync(PageContext<ListRecognizersRequest, ListRecognizersResponse, Recognizer> context, ApiFuture<ListRecognizersResponse> futureResponse) {
            ApiFuture<ListRecognizersPage> futurePage = ListRecognizersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRecognizersPagedResponse((ListRecognizersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRecognizersPagedResponse(ListRecognizersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRecognizersFixedSizeCollection.createEmptyCollection());
        }
    }
}

