/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.speech.v1.AdaptationClient;
import com.google.cloud.speech.v1.CreateCustomClassRequest;
import com.google.cloud.speech.v1.CreatePhraseSetRequest;
import com.google.cloud.speech.v1.CustomClass;
import com.google.cloud.speech.v1.DeleteCustomClassRequest;
import com.google.cloud.speech.v1.DeletePhraseSetRequest;
import com.google.cloud.speech.v1.GetCustomClassRequest;
import com.google.cloud.speech.v1.GetPhraseSetRequest;
import com.google.cloud.speech.v1.ListCustomClassesRequest;
import com.google.cloud.speech.v1.ListCustomClassesResponse;
import com.google.cloud.speech.v1.ListPhraseSetRequest;
import com.google.cloud.speech.v1.ListPhraseSetResponse;
import com.google.cloud.speech.v1.PhraseSet;
import com.google.cloud.speech.v1.UpdateCustomClassRequest;
import com.google.cloud.speech.v1.UpdatePhraseSetRequest;
import com.google.cloud.speech.v1.stub.AdaptationStub;
import com.google.cloud.speech.v1.stub.AdaptationStubSettings;
import com.google.cloud.speech.v1.stub.GrpcAdaptationCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAdaptationStub
extends AdaptationStub {
    private static final MethodDescriptor<CreatePhraseSetRequest, PhraseSet> createPhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/CreatePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhraseSet.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPhraseSetRequest, PhraseSet> getPhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/GetPhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhraseSet.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPhraseSetRequest, ListPhraseSetResponse> listPhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/ListPhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPhraseSetResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/UpdatePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhraseSet.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePhraseSetRequest, Empty> deletePhraseSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/DeletePhraseSet").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePhraseSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateCustomClassRequest, CustomClass> createCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/CreateCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomClass.getDefaultInstance())).build();
    private static final MethodDescriptor<GetCustomClassRequest, CustomClass> getCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/GetCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomClass.getDefaultInstance())).build();
    private static final MethodDescriptor<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/ListCustomClasses").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCustomClassesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCustomClassesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateCustomClassRequest, CustomClass> updateCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/UpdateCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomClass.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteCustomClassRequest, Empty> deleteCustomClassMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.speech.v1.Adaptation/DeleteCustomClass").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteCustomClassRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreatePhraseSetRequest, PhraseSet> createPhraseSetCallable;
    private final UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable;
    private final UnaryCallable<ListPhraseSetRequest, ListPhraseSetResponse> listPhraseSetCallable;
    private final UnaryCallable<ListPhraseSetRequest, AdaptationClient.ListPhraseSetPagedResponse> listPhraseSetPagedCallable;
    private final UnaryCallable<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetCallable;
    private final UnaryCallable<DeletePhraseSetRequest, Empty> deletePhraseSetCallable;
    private final UnaryCallable<CreateCustomClassRequest, CustomClass> createCustomClassCallable;
    private final UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable;
    private final UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable;
    private final UnaryCallable<ListCustomClassesRequest, AdaptationClient.ListCustomClassesPagedResponse> listCustomClassesPagedCallable;
    private final UnaryCallable<UpdateCustomClassRequest, CustomClass> updateCustomClassCallable;
    private final UnaryCallable<DeleteCustomClassRequest, Empty> deleteCustomClassCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdaptationStub create(AdaptationStubSettings settings) throws IOException {
        return new GrpcAdaptationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdaptationStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdaptationStub(AdaptationStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdaptationStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdaptationStub(AdaptationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdaptationStub(AdaptationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdaptationCallableFactory());
    }

    protected GrpcAdaptationStub(AdaptationStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createPhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listPhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("phrase_set.name", String.valueOf(request.getPhraseSet().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePhraseSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePhraseSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listCustomClassesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCustomClassesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("custom_class.name", String.valueOf(request.getCustomClass().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteCustomClassTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteCustomClassMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createPhraseSetCallable = callableFactory.createUnaryCallable(createPhraseSetTransportSettings, settings.createPhraseSetSettings(), clientContext);
        this.getPhraseSetCallable = callableFactory.createUnaryCallable(getPhraseSetTransportSettings, settings.getPhraseSetSettings(), clientContext);
        this.listPhraseSetCallable = callableFactory.createUnaryCallable(listPhraseSetTransportSettings, settings.listPhraseSetSettings(), clientContext);
        this.listPhraseSetPagedCallable = callableFactory.createPagedCallable(listPhraseSetTransportSettings, settings.listPhraseSetSettings(), clientContext);
        this.updatePhraseSetCallable = callableFactory.createUnaryCallable(updatePhraseSetTransportSettings, settings.updatePhraseSetSettings(), clientContext);
        this.deletePhraseSetCallable = callableFactory.createUnaryCallable(deletePhraseSetTransportSettings, settings.deletePhraseSetSettings(), clientContext);
        this.createCustomClassCallable = callableFactory.createUnaryCallable(createCustomClassTransportSettings, settings.createCustomClassSettings(), clientContext);
        this.getCustomClassCallable = callableFactory.createUnaryCallable(getCustomClassTransportSettings, settings.getCustomClassSettings(), clientContext);
        this.listCustomClassesCallable = callableFactory.createUnaryCallable(listCustomClassesTransportSettings, settings.listCustomClassesSettings(), clientContext);
        this.listCustomClassesPagedCallable = callableFactory.createPagedCallable(listCustomClassesTransportSettings, settings.listCustomClassesSettings(), clientContext);
        this.updateCustomClassCallable = callableFactory.createUnaryCallable(updateCustomClassTransportSettings, settings.updateCustomClassSettings(), clientContext);
        this.deleteCustomClassCallable = callableFactory.createUnaryCallable(deleteCustomClassTransportSettings, settings.deleteCustomClassSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreatePhraseSetRequest, PhraseSet> createPhraseSetCallable() {
        return this.createPhraseSetCallable;
    }

    @Override
    public UnaryCallable<GetPhraseSetRequest, PhraseSet> getPhraseSetCallable() {
        return this.getPhraseSetCallable;
    }

    @Override
    public UnaryCallable<ListPhraseSetRequest, ListPhraseSetResponse> listPhraseSetCallable() {
        return this.listPhraseSetCallable;
    }

    @Override
    public UnaryCallable<ListPhraseSetRequest, AdaptationClient.ListPhraseSetPagedResponse> listPhraseSetPagedCallable() {
        return this.listPhraseSetPagedCallable;
    }

    @Override
    public UnaryCallable<UpdatePhraseSetRequest, PhraseSet> updatePhraseSetCallable() {
        return this.updatePhraseSetCallable;
    }

    @Override
    public UnaryCallable<DeletePhraseSetRequest, Empty> deletePhraseSetCallable() {
        return this.deletePhraseSetCallable;
    }

    @Override
    public UnaryCallable<CreateCustomClassRequest, CustomClass> createCustomClassCallable() {
        return this.createCustomClassCallable;
    }

    @Override
    public UnaryCallable<GetCustomClassRequest, CustomClass> getCustomClassCallable() {
        return this.getCustomClassCallable;
    }

    @Override
    public UnaryCallable<ListCustomClassesRequest, ListCustomClassesResponse> listCustomClassesCallable() {
        return this.listCustomClassesCallable;
    }

    @Override
    public UnaryCallable<ListCustomClassesRequest, AdaptationClient.ListCustomClassesPagedResponse> listCustomClassesPagedCallable() {
        return this.listCustomClassesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateCustomClassRequest, CustomClass> updateCustomClassCallable() {
        return this.updateCustomClassCallable;
    }

    @Override
    public UnaryCallable<DeleteCustomClassRequest, Empty> deleteCustomClassCallable() {
        return this.deleteCustomClassCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

