/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.spi.v1beta1;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.StreamingCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SpeechGrpc;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.longrunning.Operation;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class SpeechSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "speech.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final SimpleCallSettings<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings;
    private final SimpleCallSettings<AsyncRecognizeRequest, Operation> asyncRecognizeSettings;
    private final StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;

    public SimpleCallSettings<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings() {
        return this.syncRecognizeSettings;
    }

    public SimpleCallSettings<AsyncRecognizeRequest, Operation> asyncRecognizeSettings() {
        return this.asyncRecognizeSettings;
    }

    public StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
        return this.streamingRecognizeSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SpeechSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.syncRecognizeSettings = settingsBuilder.syncRecognizeSettings().build();
        this.asyncRecognizeSettings = settingsBuilder.asyncRecognizeSettings().build();
        this.streamingRecognizeSettings = settingsBuilder.streamingRecognizeSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings;
        private final SimpleCallSettings.Builder<AsyncRecognizeRequest, Operation> asyncRecognizeSettings;
        private final StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(Builder.s_getDefaultConnectionSettingsBuilder().build());
            this.syncRecognizeSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SpeechGrpc.METHOD_SYNC_RECOGNIZE);
            this.asyncRecognizeSettings = SimpleCallSettings.newBuilder((MethodDescriptor)SpeechGrpc.METHOD_ASYNC_RECOGNIZE);
            this.streamingRecognizeSettings = StreamingCallSettings.newBuilder((MethodDescriptor)SpeechGrpc.METHOD_STREAMING_RECOGNIZE);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.syncRecognizeSettings, this.asyncRecognizeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.syncRecognizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.asyncRecognizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(SpeechSettings settings) {
            super((ServiceApiSettings)settings);
            this.syncRecognizeSettings = settings.syncRecognizeSettings.toBuilder();
            this.asyncRecognizeSettings = settings.asyncRecognizeSettings.toBuilder();
            this.streamingRecognizeSettings = settings.streamingRecognizeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.syncRecognizeSettings, this.asyncRecognizeSettings);
        }

        private static ConnectionSettings.Builder s_getDefaultConnectionSettingsBuilder() {
            return ConnectionSettings.newBuilder().setServiceAddress(SpeechSettings.DEFAULT_SERVICE_ADDRESS).setPort(443).provideCredentialsWith((List)DEFAULT_SERVICE_SCOPES);
        }

        protected ConnectionSettings.Builder getDefaultConnectionSettingsBuilder() {
            return Builder.s_getDefaultConnectionSettingsBuilder();
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(UnaryCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.unaryMethodSettingsBuilders, apiCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings() {
            return this.syncRecognizeSettings;
        }

        public SimpleCallSettings.Builder<AsyncRecognizeRequest, Operation> asyncRecognizeSettings() {
            return this.asyncRecognizeSettings;
        }

        public StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
            return this.streamingRecognizeSettings;
        }

        public SpeechSettings build() throws IOException {
            return new SpeechSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)60000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

