/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.spi.v1beta1;

import com.google.api.gax.grpc.ApiCallable;
import com.google.cloud.speech.spi.v1beta1.SpeechSettings;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.RecognitionAudio;
import com.google.cloud.speech.v1beta1.RecognitionConfig;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.longrunning.Operation;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class SpeechApi
implements AutoCloseable {
    private final SpeechSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable;
    private final ApiCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable;

    public final SpeechSettings getSettings() {
        return this.settings;
    }

    public static final SpeechApi create() throws IOException {
        return SpeechApi.create(SpeechSettings.defaultBuilder().build());
    }

    public static final SpeechApi create(SpeechSettings settings) throws IOException {
        return new SpeechApi(settings);
    }

    protected SpeechApi(SpeechSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.syncRecognizeCallable = ApiCallable.create(settings.syncRecognizeSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.asyncRecognizeCallable = ApiCallable.create(settings.asyncRecognizeSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SpeechApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SpeechApi.this.executor.shutdown();
                }
            });
        }
    }

    public final SyncRecognizeResponse syncRecognize(RecognitionConfig config, RecognitionAudio audio) {
        SyncRecognizeRequest request = SyncRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.syncRecognize(request);
    }

    public final SyncRecognizeResponse syncRecognize(SyncRecognizeRequest request) {
        return (SyncRecognizeResponse)this.syncRecognizeCallable().call((Object)request);
    }

    public final ApiCallable<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeCallable() {
        return this.syncRecognizeCallable;
    }

    public final Operation asyncRecognize(RecognitionConfig config, RecognitionAudio audio) {
        AsyncRecognizeRequest request = AsyncRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.asyncRecognize(request);
    }

    public final Operation asyncRecognize(AsyncRecognizeRequest request) {
        return (Operation)this.asyncRecognizeCallable().call((Object)request);
    }

    public final ApiCallable<AsyncRecognizeRequest, Operation> asyncRecognizeCallable() {
        return this.asyncRecognizeCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

