/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.adapter.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.spanner.adapter.v1.AdaptMessageRequest;
import com.google.spanner.adapter.v1.AdaptMessageResponse;
import com.google.spanner.adapter.v1.CreateSessionRequest;
import com.google.spanner.adapter.v1.Session;
import com.google.spanner.adapter.v1.stub.AdapterStub;
import com.google.spanner.adapter.v1.stub.AdapterStubSettings;
import com.google.spanner.adapter.v1.stub.HttpJsonAdapterCallableFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonAdapterStub
extends AdapterStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateSessionRequest, Session> createSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.adapter.v1.Adapter/CreateSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/instances/*/databases/*}/sessions:adapter", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("session", (Message)request.getSession(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AdaptMessageRequest, AdaptMessageResponse> adaptMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.spanner.adapter.v1.Adapter/AdaptMessage").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/instances/*/databases/*/sessions/*}:adaptMessage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AdaptMessageResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSessionRequest, Session> createSessionCallable;
    private final ServerStreamingCallable<AdaptMessageRequest, AdaptMessageResponse> adaptMessageCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAdapterStub create(AdapterStubSettings settings) throws IOException {
        return new HttpJsonAdapterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAdapterStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAdapterStub(AdapterStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonAdapterStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAdapterStub(AdapterStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAdapterStub(AdapterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAdapterCallableFactory());
    }

    protected HttpJsonAdapterStub(AdapterStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings adaptMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(adaptMessageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.adaptMessageCallable = callableFactory.createServerStreamingCallable(adaptMessageTransportSettings, settings.adaptMessageSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSessionMethodDescriptor);
        methodDescriptors.add(adaptMessageMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public ServerStreamingCallable<AdaptMessageRequest, AdaptMessageResponse> adaptMessageCallable() {
        return this.adaptMessageCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

