/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.adapter.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.spanner.adapter.v1.AdaptMessageRequest;
import com.google.spanner.adapter.v1.AdaptMessageResponse;
import com.google.spanner.adapter.v1.AdapterSettings;
import com.google.spanner.adapter.v1.CreateSessionRequest;
import com.google.spanner.adapter.v1.DatabaseName;
import com.google.spanner.adapter.v1.Session;
import com.google.spanner.adapter.v1.stub.AdapterStub;
import com.google.spanner.adapter.v1.stub.AdapterStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AdapterClient
implements BackgroundResource {
    private final AdapterSettings settings;
    private final AdapterStub stub;

    public static final AdapterClient create() throws IOException {
        return AdapterClient.create(AdapterSettings.newBuilder().build());
    }

    public static final AdapterClient create(AdapterSettings settings) throws IOException {
        return new AdapterClient(settings);
    }

    public static final AdapterClient create(AdapterStub stub) {
        return new AdapterClient(stub);
    }

    protected AdapterClient(AdapterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdapterStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdapterClient(AdapterStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdapterSettings getSettings() {
        return this.settings;
    }

    public AdapterStub getStub() {
        return this.stub;
    }

    public final Session createSession(DatabaseName parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSession(session).build();
        return this.createSession(request);
    }

    public final Session createSession(String parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent).setSession(session).build();
        return this.createSession(request);
    }

    public final Session createSession(CreateSessionRequest request) {
        return (Session)this.createSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.stub.createSessionCallable();
    }

    public final ServerStreamingCallable<AdaptMessageRequest, AdaptMessageResponse> adaptMessageCallable() {
        return this.stub.adaptMessageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

