/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.BetaApi;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ErrorHandler;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import javax.annotation.Nonnull;

@BetaApi
class RetryOnDifferentGrpcChannelErrorHandler
implements ErrorHandler {
    private final int maxAttempts;
    private final SessionImpl session;

    static boolean isEnabled() {
        return Boolean.parseBoolean(System.getProperty("spanner.retry_deadline_exceeded_on_different_channel", "false"));
    }

    RetryOnDifferentGrpcChannelErrorHandler(int maxAttempts, SessionImpl session) {
        this.maxAttempts = maxAttempts;
        this.session = session;
    }

    @Override
    @Nonnull
    public Throwable translateException(@Nonnull Throwable exception) {
        if (this.session == null || !(exception instanceof SpannerException)) {
            return exception;
        }
        SpannerException spannerException = (SpannerException)((Object)exception);
        if (spannerException.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED && (this.session.getIsMultiplexed() || this.session.getOptions() != null && this.session.getOptions().containsKey((Object)SpannerRpc.Option.CHANNEL_HINT))) {
            int channel = -1;
            if (this.session.getOptions() != null && this.session.getOptions().containsKey((Object)SpannerRpc.Option.CHANNEL_HINT)) {
                channel = SpannerRpc.Option.CHANNEL_HINT.getLong(this.session.getOptions()).intValue();
            }
            return SpannerExceptionFactory.newRetryOnDifferentGrpcChannelException("Retrying on a new gRPC channel due to a DEADLINE_EXCEEDED error", channel, (Throwable)((Object)spannerException));
        }
        return spannerException;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }
}

