/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionMutationLimitExceededException;
import java.util.UUID;

@InternalApi
public interface TransactionRetryListener {
    public void retryStarting(Timestamp var1, long var2, int var4);

    public void retryFinished(Timestamp var1, long var2, int var4, RetryResult var5);

    default public void retryDmlAsPartitionedDmlStarting(UUID executionId, Statement statement, TransactionMutationLimitExceededException exception) {
    }

    default public void retryDmlAsPartitionedDmlFinished(UUID executionId, Statement statement, long lowerBoundUpdateCount) {
    }

    default public void retryDmlAsPartitionedDmlFailed(UUID executionId, Statement statement, Throwable exception) {
    }

    @InternalApi
    public static enum RetryResult {
        RETRY_SUCCESSFUL,
        RETRY_ABORTED_AND_RESTARTING,
        RETRY_ABORTED_DUE_TO_CONCURRENT_MODIFICATION,
        RETRY_ABORTED_AND_MAX_ATTEMPTS_EXCEEDED,
        RETRY_ERROR;

    }
}

