/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.cloud.grpc.BaseGrpcServiceException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.XGoogSpannerRequestId;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.util.Map;
import javax.annotation.Nullable;

public class SpannerException
extends BaseGrpcServiceException {
    private static final long serialVersionUID = 20150916L;
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
    private final ErrorCode code;
    private final ApiException apiException;
    private final XGoogSpannerRequestId requestId;

    SpannerException(DoNotConstructDirectly token, ErrorCode code, boolean retryable, @Nullable String message, @Nullable Throwable cause) {
        this(token, code, retryable, message, cause, null);
    }

    SpannerException(DoNotConstructDirectly token, ErrorCode code, boolean retryable, @Nullable String message, @Nullable Throwable cause, @Nullable ApiException apiException) {
        this(token, code, retryable, message, cause, apiException, null);
    }

    SpannerException(DoNotConstructDirectly token, ErrorCode code, boolean retryable, @Nullable String message, @Nullable Throwable cause, @Nullable ApiException apiException, @Nullable XGoogSpannerRequestId requestId) {
        super(message, cause, code.getCode(), retryable);
        if (token != DoNotConstructDirectly.ALLOWED) {
            throw new AssertionError((Object)"Do not construct directly: use SpannerExceptionFactory");
        }
        this.code = (ErrorCode)((Object)Preconditions.checkNotNull((Object)((Object)code)));
        this.apiException = apiException;
        this.requestId = requestId;
    }

    public ErrorCode getErrorCode() {
        return this.code;
    }

    public String getRequestId() {
        if (this.requestId == null) {
            return "";
        }
        return this.requestId.toString();
    }

    public long getRetryDelayInMillis() {
        return SpannerException.extractRetryDelay(this.getCause());
    }

    static long extractRetryDelay(Throwable cause) {
        RetryInfo retryInfo;
        Metadata trailers;
        if (cause != null && (trailers = Status.trailersFromThrowable((Throwable)cause)) != null && trailers.containsKey(KEY_RETRY_INFO) && (retryInfo = (RetryInfo)trailers.get(KEY_RETRY_INFO)).hasRetryDelay()) {
            return Durations.toMillis((Duration)retryInfo.getRetryDelay());
        }
        return -1L;
    }

    public String getReason() {
        if (this.apiException != null) {
            return this.apiException.getReason();
        }
        return null;
    }

    public String getDomain() {
        if (this.apiException != null) {
            return this.apiException.getDomain();
        }
        return null;
    }

    public Map<String, String> getMetadata() {
        if (this.apiException != null) {
            return this.apiException.getMetadata();
        }
        return null;
    }

    public ErrorDetails getErrorDetails() {
        if (this.apiException != null) {
            return this.apiException.getErrorDetails();
        }
        return null;
    }

    static enum DoNotConstructDirectly {
        ALLOWED;

    }

    public static abstract class ResourceNotFoundException
    extends SpannerException {
        private final ResourceInfo resourceInfo;

        ResourceNotFoundException(DoNotConstructDirectly token, @Nullable String message, ResourceInfo resourceInfo, @Nullable Throwable cause, @Nullable ApiException apiException, @Nullable XGoogSpannerRequestId reqId) {
            super(token, ErrorCode.NOT_FOUND, false, message, cause, apiException, reqId);
            this.resourceInfo = resourceInfo;
        }

        public String getResourceName() {
            return this.resourceInfo.getResourceName();
        }
    }
}

