/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Struct;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartitionOptions;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.TransactionSelector;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class BatchClientImpl
implements BatchClient {
    private final SessionClient sessionClient;
    private final boolean isMultiplexedSessionEnabled;
    private final ReentrantLock multiplexedSessionLock = new ReentrantLock();
    private final Duration sessionExpirationDuration;
    @GuardedBy(value="multiplexedSessionLock")
    private final AtomicReference<Instant> expirationDate;
    @GuardedBy(value="multiplexedSessionLock")
    private final AtomicReference<SessionImpl> multiplexedSessionReference;
    @VisibleForTesting
    static final AtomicBoolean unimplementedForPartitionedOps = new AtomicBoolean(false);

    BatchClientImpl(SessionClient sessionClient, boolean isMultiplexedSessionEnabled) {
        this.sessionClient = (SessionClient)Preconditions.checkNotNull((Object)sessionClient);
        this.isMultiplexedSessionEnabled = isMultiplexedSessionEnabled;
        this.sessionExpirationDuration = Duration.ofMillis(((SpannerOptions)sessionClient.getSpanner().getOptions()).getSessionPoolOptions().getMultiplexedSessionMaintenanceDuration().toMillis());
        this.expirationDate = new AtomicReference<Instant>(Instant.MIN);
        this.multiplexedSessionReference = new AtomicReference();
    }

    @Override
    @Nullable
    public String getDatabaseRole() {
        return ((SpannerOptions)this.sessionClient.getSpanner().getOptions()).getDatabaseRole();
    }

    @Override
    public BatchReadOnlyTransaction batchReadOnlyTransaction(TimestampBound bound) {
        SessionImpl session = this.canUseMultiplexedSession() ? this.getMultiplexedSession() : this.sessionClient.createSession();
        return new BatchReadOnlyTransactionImpl((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)AbstractReadContext.MultiUseReadOnlyTransaction.newBuilder().setSession(session)).setCancelQueryWhenClientIsClosed(true)).setRpc(this.sessionClient.getSpanner().getRpc())).setTimestampBound(bound).setDefaultQueryOptions(this.sessionClient.getSpanner().getDefaultQueryOptions(this.sessionClient.getDatabaseId()))).setExecutorProvider(this.sessionClient.getSpanner().getAsyncExecutorProvider())).setDefaultPrefetchChunks(this.sessionClient.getSpanner().getDefaultPrefetchChunks())).setDefaultDecodeMode(this.sessionClient.getSpanner().getDefaultDecodeMode())).setDefaultDirectedReadOptions(((SpannerOptions)this.sessionClient.getSpanner().getOptions()).getDirectedReadOptions())).setSpan(this.sessionClient.getSpanner().getTracer().getCurrentSpan())).setTracer(this.sessionClient.getSpanner().getTracer()), (TimestampBound)Preconditions.checkNotNull((Object)bound), this.sessionClient);
    }

    @Override
    public BatchReadOnlyTransaction batchReadOnlyTransaction(BatchTransactionId batchTransactionId) {
        SessionImpl session = this.sessionClient.sessionWithId(((BatchTransactionId)Preconditions.checkNotNull((Object)batchTransactionId)).getSessionId());
        return new BatchReadOnlyTransactionImpl((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)AbstractReadContext.MultiUseReadOnlyTransaction.newBuilder().setSession(session)).setCancelQueryWhenClientIsClosed(true)).setRpc(this.sessionClient.getSpanner().getRpc())).setTransactionId(batchTransactionId.getTransactionId()).setTimestamp(batchTransactionId.getTimestamp()).setDefaultQueryOptions(this.sessionClient.getSpanner().getDefaultQueryOptions(this.sessionClient.getDatabaseId()))).setExecutorProvider(this.sessionClient.getSpanner().getAsyncExecutorProvider())).setDefaultPrefetchChunks(this.sessionClient.getSpanner().getDefaultPrefetchChunks())).setDefaultDecodeMode(this.sessionClient.getSpanner().getDefaultDecodeMode())).setDefaultDirectedReadOptions(((SpannerOptions)this.sessionClient.getSpanner().getOptions()).getDirectedReadOptions())).setSpan(this.sessionClient.getSpanner().getTracer().getCurrentSpan())).setTracer(this.sessionClient.getSpanner().getTracer()), batchTransactionId, this.sessionClient);
    }

    private boolean canUseMultiplexedSession() {
        return this.isMultiplexedSessionEnabled && !unimplementedForPartitionedOps.get();
    }

    private SessionImpl getMultiplexedSession() {
        this.multiplexedSessionLock.lock();
        try {
            if (Clock.systemUTC().instant().isAfter(this.expirationDate.get()) || this.multiplexedSessionReference.get() == null) {
                this.multiplexedSessionReference.set(this.sessionClient.createMultiplexedSession());
                this.expirationDate.set(Clock.systemUTC().instant().plus(this.sessionExpirationDuration));
            }
            SessionImpl sessionImpl = this.multiplexedSessionReference.get();
            return sessionImpl;
        }
        finally {
            this.multiplexedSessionLock.unlock();
        }
    }

    private static class BatchReadOnlyTransactionImpl
    extends AbstractReadContext.MultiUseReadOnlyTransaction
    implements BatchReadOnlyTransaction {
        private String sessionName;
        private final Map<SpannerRpc.Option, ?> options;
        private final SessionClient sessionClient;
        private final AtomicBoolean fallbackInitiated = new AtomicBoolean(false);

        BatchReadOnlyTransactionImpl(AbstractReadContext.MultiUseReadOnlyTransaction.Builder builder, TimestampBound bound, SessionClient sessionClient) {
            super(builder.setTimestampBound(bound));
            this.sessionClient = sessionClient;
            this.sessionName = this.session.getName();
            this.options = this.session.getOptions();
            this.initTransaction();
        }

        BatchReadOnlyTransactionImpl(AbstractReadContext.MultiUseReadOnlyTransaction.Builder builder, BatchTransactionId batchTransactionId, SessionClient sessionClient) {
            super(builder.setTransactionId(batchTransactionId.getTransactionId()));
            this.sessionClient = sessionClient;
            this.sessionName = this.session.getName();
            this.options = this.session.getOptions();
        }

        @Override
        public BatchTransactionId getBatchTransactionId() {
            return new BatchTransactionId(this.sessionName, this.getTransactionId(), this.getReadTimestamp());
        }

        @Override
        public List<Partition> partitionRead(PartitionOptions partitionOptions, String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) throws SpannerException {
            return this.partitionReadUsingIndex(partitionOptions, table, null, keys, columns, options);
        }

        @Override
        public List<Partition> partitionReadUsingIndex(PartitionOptions partitionOptions, String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... option) throws SpannerException {
            return this.partitionReadUsingIndex(partitionOptions, table, index, keys, columns, false, option);
        }

        private List<Partition> partitionReadUsingIndex(PartitionOptions partitionOptions, String table, String index, KeySet keys, Iterable<String> columns, boolean isFallback, Options.ReadOption ... option) throws SpannerException {
            TransactionSelector selector;
            Options readOptions = Options.fromReadOptions(option);
            Preconditions.checkArgument((!readOptions.hasLimit() ? 1 : 0) != 0, (Object)"Limit option not supported by partitionRead|partitionReadUsingIndex");
            PartitionReadRequest.Builder builder = PartitionReadRequest.newBuilder().setSession(this.sessionName).setTable((String)Preconditions.checkNotNull((Object)table)).addAllColumns(columns);
            keys.appendToProto(builder.getKeySetBuilder());
            if (index != null) {
                builder.setIndex(index);
            }
            if ((selector = this.getTransactionSelector()) != null) {
                builder.setTransaction(selector);
            }
            PartitionOptions.Builder pbuilder = com.google.spanner.v1.PartitionOptions.newBuilder();
            if (partitionOptions != null) {
                partitionOptions.appendToProto(pbuilder);
            }
            builder.setPartitionOptions(pbuilder.build());
            PartitionReadRequest request = builder.build();
            try {
                PartitionResponse response = this.rpc.partitionRead(request, this.options);
                ImmutableList.Builder partitions = ImmutableList.builder();
                for (com.google.spanner.v1.Partition p : response.getPartitionsList()) {
                    Partition partition = Partition.createReadPartition(p.getPartitionToken(), partitionOptions, table, index, keys, columns, readOptions);
                    partitions.add((Object)partition);
                }
                return partitions.build();
            }
            catch (SpannerException e) {
                if (!isFallback && this.maybeMarkUnimplementedForPartitionedOps(e)) {
                    return this.partitionReadUsingIndex(partitionOptions, table, index, keys, columns, true, option);
                }
                throw e;
            }
        }

        @Override
        public List<Partition> partitionQuery(PartitionOptions partitionOptions, Statement statement, Options.QueryOption ... option) throws SpannerException {
            return this.partitionQuery(partitionOptions, statement, false, option);
        }

        private List<Partition> partitionQuery(PartitionOptions partitionOptions, Statement statement, boolean isFallback, Options.QueryOption ... option) throws SpannerException {
            TransactionSelector selector;
            Options queryOptions = Options.fromQueryOptions(option);
            PartitionQueryRequest.Builder builder = PartitionQueryRequest.newBuilder().setSession(this.sessionName).setSql(statement.getSql());
            Map<String, Value> stmtParameters = statement.getParameters();
            if (!stmtParameters.isEmpty()) {
                Struct.Builder paramsBuilder = builder.getParamsBuilder();
                for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                    paramsBuilder.putFields(param.getKey(), Value.toProto(param.getValue()));
                    if (param.getValue() == null || param.getValue().getType() == null) continue;
                    builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
                }
            }
            if ((selector = this.getTransactionSelector()) != null) {
                builder.setTransaction(selector);
            }
            PartitionOptions.Builder pbuilder = com.google.spanner.v1.PartitionOptions.newBuilder();
            if (partitionOptions != null) {
                partitionOptions.appendToProto(pbuilder);
            }
            builder.setPartitionOptions(pbuilder.build());
            PartitionQueryRequest request = builder.build();
            try {
                PartitionResponse response = this.rpc.partitionQuery(request, this.options);
                ImmutableList.Builder partitions = ImmutableList.builder();
                for (com.google.spanner.v1.Partition p : response.getPartitionsList()) {
                    Partition partition = Partition.createQueryPartition(p.getPartitionToken(), partitionOptions, statement, queryOptions);
                    partitions.add((Object)partition);
                }
                return partitions.build();
            }
            catch (SpannerException e) {
                if (!isFallback && this.maybeMarkUnimplementedForPartitionedOps(e)) {
                    return this.partitionQuery(partitionOptions, statement, true, option);
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean maybeMarkUnimplementedForPartitionedOps(SpannerException spannerException) {
            if (MultiplexedSessionDatabaseClient.verifyErrorMessage(spannerException, "Partitioned operations are not supported with multiplexed sessions")) {
                AtomicBoolean atomicBoolean = this.fallbackInitiated;
                synchronized (atomicBoolean) {
                    if (!this.fallbackInitiated.get()) {
                        this.session.setFallbackSessionReference(this.sessionClient.createSession().getSessionReference());
                        this.sessionName = this.session.getName();
                        this.initFallbackTransaction();
                        unimplementedForPartitionedOps.set(true);
                        this.fallbackInitiated.set(true);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public ResultSet execute(Partition partition) throws SpannerException {
            if (partition.getStatement() != null) {
                return this.executeQueryInternalWithOptions(partition.getStatement(), ExecuteSqlRequest.QueryMode.NORMAL, partition.getQueryOptions(), partition.getPartitionToken());
            }
            return this.readInternalWithOptions(partition.getTable(), partition.getIndex(), partition.getKeys(), partition.getColumns(), partition.getReadOptions(), partition.getPartitionToken());
        }

        @Override
        public void cleanup() {
            this.session.close();
        }
    }
}

