/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.api.client.util.Preconditions;
import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.cloud.spanner.encryption.GoogleDefaultEncryption;
import com.google.cloud.spanner.encryption.UseBackupEncryption;
import com.google.cloud.spanner.encryption.UseDatabaseEncryption;

public class EncryptionConfigs {
    public static CustomerManagedEncryption customerManagedEncryption(String kmsKeyName) {
        Preconditions.checkArgument((kmsKeyName != null ? 1 : 0) != 0, (Object)"Customer managed encryption key name must not be null");
        return new CustomerManagedEncryption(kmsKeyName);
    }

    public static GoogleDefaultEncryption googleDefaultEncryption() {
        return GoogleDefaultEncryption.INSTANCE;
    }

    public static UseDatabaseEncryption useDatabaseEncryption() {
        return UseDatabaseEncryption.INSTANCE;
    }

    public static UseBackupEncryption useBackupEncryption() {
        return UseBackupEncryption.INSTANCE;
    }
}

