/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.RestoreInfo;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.common.base.Preconditions;
import com.google.longrunning.Operation;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;

public class Database
extends DatabaseInfo {
    private static final String FILTER_DB_OPERATIONS_TEMPLATE = "name:databases/%s";
    private final DatabaseAdminClient dbClient;

    public Database(DatabaseId id, DatabaseInfo.State state, DatabaseAdminClient dbClient) {
        super(id, state);
        this.dbClient = dbClient;
    }

    Database(Builder builder) {
        super(builder);
        this.dbClient = (DatabaseAdminClient)Preconditions.checkNotNull((Object)builder.dbClient);
    }

    public Database reload() throws SpannerException {
        return this.dbClient.getDatabase(this.instance(), this.database());
    }

    public OperationFuture<Void, UpdateDatabaseDdlMetadata> updateDdl(Iterable<String> statements, String operationId) throws SpannerException {
        return this.dbClient.updateDatabaseDdl(this.instance(), this.database(), statements, operationId);
    }

    public void drop() throws SpannerException {
        this.dbClient.dropDatabase(this.instance(), this.database());
    }

    public boolean exists() {
        try {
            this.dbClient.getDatabase(this.instance(), this.database());
        }
        catch (SpannerException e) {
            if (e.getErrorCode() == ErrorCode.NOT_FOUND) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public OperationFuture<Backup, CreateBackupMetadata> backup(Backup backup) {
        Preconditions.checkArgument((backup.getExpireTime() != null ? 1 : 0) != 0, (Object)"The backup does not have an expire time.");
        Preconditions.checkArgument((boolean)backup.getInstanceId().equals(this.getId().getInstanceId()), (Object)"The instance of the backup must be equal to the instance of this database.");
        return this.dbClient.createBackup(this.dbClient.newBackupBuilder(backup.getId()).setDatabase(this.getId()).setExpireTime(backup.getExpireTime()).setVersionTime(backup.getVersionTime()).build());
    }

    public Iterable<String> getDdl() throws SpannerException {
        return this.dbClient.getDatabaseDdl(this.instance(), this.database());
    }

    public Page<Operation> listDatabaseOperations() {
        return this.dbClient.listDatabaseOperations(this.instance(), Options.filter(String.format(FILTER_DB_OPERATIONS_TEMPLATE, this.database())));
    }

    public Policy getIAMPolicy() {
        return this.dbClient.getDatabaseIAMPolicy(this.instance(), this.database());
    }

    public Policy setIAMPolicy(Policy policy) {
        return this.dbClient.setDatabaseIAMPolicy(this.instance(), this.database(), policy);
    }

    public Iterable<String> testIAMPermissions(Iterable<String> permissions) {
        return this.dbClient.testDatabaseIAMPermissions(this.instance(), this.database(), permissions);
    }

    private String instance() {
        return this.getId().getInstanceId().getInstance();
    }

    private String database() {
        return this.getId().getDatabase();
    }

    static Database fromProto(com.google.spanner.admin.database.v1.Database proto, DatabaseAdminClient client) {
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Missing expected 'name' field");
        return new Builder(client, DatabaseId.of(proto.getName())).setState(Database.fromProtoState(proto.getState())).setCreateTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getCreateTime())).setRestoreInfo(RestoreInfo.fromProtoOrNullIfDefaultInstance(proto.getRestoreInfo())).setVersionRetentionPeriod(proto.getVersionRetentionPeriod()).setEarliestVersionTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getEarliestVersionTime())).setEncryptionConfig(CustomerManagedEncryption.fromProtoOrNull(proto.getEncryptionConfig())).setProto(proto).build();
    }

    static DatabaseInfo.State fromProtoState(Database.State protoState) {
        switch (protoState) {
            case STATE_UNSPECIFIED: {
                return DatabaseInfo.State.UNSPECIFIED;
            }
            case CREATING: {
                return DatabaseInfo.State.CREATING;
            }
            case READY: {
                return DatabaseInfo.State.READY;
            }
            case READY_OPTIMIZING: {
                return DatabaseInfo.State.READY_OPTIMIZING;
            }
        }
        throw new IllegalArgumentException("Unrecognized state " + protoState);
    }

    public static class Builder
    extends DatabaseInfo.BuilderImpl {
        private final DatabaseAdminClient dbClient;

        Builder(DatabaseAdminClient dbClient, DatabaseId databaseId) {
            super(databaseId);
            this.dbClient = (DatabaseAdminClient)Preconditions.checkNotNull((Object)dbClient);
        }

        private Builder(Database database) {
            super(database);
            this.dbClient = database.dbClient;
        }

        @Override
        public Database build() {
            return new Database(this);
        }
    }
}

