/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminSettings;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.BackupName;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.DeleteBackupRequest;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetBackupRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.InstanceName;
import com.google.spanner.admin.database.v1.ListBackupOperationsRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsResponse;
import com.google.spanner.admin.database.v1.ListBackupsRequest;
import com.google.spanner.admin.database.v1.ListBackupsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsRequest;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsResponse;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import com.google.spanner.admin.database.v1.UpdateBackupRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DatabaseAdminClient
implements BackgroundResource {
    private final DatabaseAdminSettings settings;
    private final DatabaseAdminStub stub;
    private final OperationsClient operationsClient;

    public static final DatabaseAdminClient create() throws IOException {
        return DatabaseAdminClient.create(DatabaseAdminSettings.newBuilder().build());
    }

    public static final DatabaseAdminClient create(DatabaseAdminSettings settings) throws IOException {
        return new DatabaseAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DatabaseAdminClient create(DatabaseAdminStub stub) {
        return new DatabaseAdminClient(stub);
    }

    protected DatabaseAdminClient(DatabaseAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatabaseAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DatabaseAdminClient(DatabaseAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DatabaseAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DatabaseAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListDatabasesPagedResponse listDatabases(InstanceName parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(String parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(ListDatabasesRequest request) {
        return (ListDatabasesPagedResponse)((Object)this.listDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesPagedResponse> listDatabasesPagedCallable() {
        return this.stub.listDatabasesPagedCallable();
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.stub.listDatabasesCallable();
    }

    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(InstanceName parent, String createStatement) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCreateStatement(createStatement).build();
        return this.createDatabaseAsync(request);
    }

    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(String parent, String createStatement) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent).setCreateStatement(createStatement).build();
        return this.createDatabaseAsync(request);
    }

    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(CreateDatabaseRequest request) {
        return this.createDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationCallable() {
        return this.stub.createDatabaseOperationCallable();
    }

    public final UnaryCallable<CreateDatabaseRequest, Operation> createDatabaseCallable() {
        return this.stub.createDatabaseCallable();
    }

    public final Database getDatabase(DatabaseName name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(String name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(GetDatabaseRequest request) {
        return (Database)this.getDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.stub.getDatabaseCallable();
    }

    public final OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlAsync(DatabaseName database, List<String> statements) {
        UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(database == null ? null : database.toString()).addAllStatements(statements).build();
        return this.updateDatabaseDdlAsync(request);
    }

    public final OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlAsync(String database, List<String> statements) {
        UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(database).addAllStatements(statements).build();
        return this.updateDatabaseDdlAsync(request);
    }

    public final OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlAsync(UpdateDatabaseDdlRequest request) {
        return this.updateDatabaseDdlOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationCallable() {
        return this.stub.updateDatabaseDdlOperationCallable();
    }

    public final UnaryCallable<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlCallable() {
        return this.stub.updateDatabaseDdlCallable();
    }

    public final void dropDatabase(DatabaseName database) {
        DropDatabaseRequest request = DropDatabaseRequest.newBuilder().setDatabase(database == null ? null : database.toString()).build();
        this.dropDatabase(request);
    }

    public final void dropDatabase(String database) {
        DropDatabaseRequest request = DropDatabaseRequest.newBuilder().setDatabase(database).build();
        this.dropDatabase(request);
    }

    public final void dropDatabase(DropDatabaseRequest request) {
        this.dropDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<DropDatabaseRequest, Empty> dropDatabaseCallable() {
        return this.stub.dropDatabaseCallable();
    }

    public final GetDatabaseDdlResponse getDatabaseDdl(DatabaseName database) {
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(database == null ? null : database.toString()).build();
        return this.getDatabaseDdl(request);
    }

    public final GetDatabaseDdlResponse getDatabaseDdl(String database) {
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(database).build();
        return this.getDatabaseDdl(request);
    }

    public final GetDatabaseDdlResponse getDatabaseDdl(GetDatabaseDdlRequest request) {
        return (GetDatabaseDdlResponse)this.getDatabaseDdlCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlCallable() {
        return this.stub.getDatabaseDdlCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final OperationFuture<Backup, CreateBackupMetadata> createBackupAsync(InstanceName parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, CreateBackupMetadata> createBackupAsync(String parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, CreateBackupMetadata> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationCallable() {
        return this.stub.createBackupOperationCallable();
    }

    public final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.stub.createBackupCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final Backup updateBackup(Backup backup, FieldMask updateMask) {
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        return this.updateBackup(request);
    }

    public final Backup updateBackup(UpdateBackupRequest request) {
        return (Backup)this.updateBackupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBackupRequest, Backup> updateBackupCallable() {
        return this.stub.updateBackupCallable();
    }

    public final void deleteBackup(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBackup(request);
    }

    public final void deleteBackup(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        this.deleteBackup(request);
    }

    public final void deleteBackup(DeleteBackupRequest request) {
        this.deleteBackupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBackupRequest, Empty> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final ListBackupsPagedResponse listBackups(InstanceName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseAsync(InstanceName parent, String databaseId, BackupName backup) {
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDatabaseId(databaseId).setBackup(backup == null ? null : backup.toString()).build();
        return this.restoreDatabaseAsync(request);
    }

    public final OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseAsync(InstanceName parent, String databaseId, String backup) {
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDatabaseId(databaseId).setBackup(backup).build();
        return this.restoreDatabaseAsync(request);
    }

    public final OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseAsync(String parent, String databaseId, BackupName backup) {
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setParent(parent).setDatabaseId(databaseId).setBackup(backup == null ? null : backup.toString()).build();
        return this.restoreDatabaseAsync(request);
    }

    public final OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseAsync(String parent, String databaseId, String backup) {
        RestoreDatabaseRequest request = RestoreDatabaseRequest.newBuilder().setParent(parent).setDatabaseId(databaseId).setBackup(backup).build();
        return this.restoreDatabaseAsync(request);
    }

    public final OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabaseAsync(RestoreDatabaseRequest request) {
        return this.restoreDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreDatabaseRequest, Database, RestoreDatabaseMetadata> restoreDatabaseOperationCallable() {
        return this.stub.restoreDatabaseOperationCallable();
    }

    public final UnaryCallable<RestoreDatabaseRequest, Operation> restoreDatabaseCallable() {
        return this.stub.restoreDatabaseCallable();
    }

    public final ListDatabaseOperationsPagedResponse listDatabaseOperations(InstanceName parent) {
        ListDatabaseOperationsRequest request = ListDatabaseOperationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabaseOperations(request);
    }

    public final ListDatabaseOperationsPagedResponse listDatabaseOperations(String parent) {
        ListDatabaseOperationsRequest request = ListDatabaseOperationsRequest.newBuilder().setParent(parent).build();
        return this.listDatabaseOperations(request);
    }

    public final ListDatabaseOperationsPagedResponse listDatabaseOperations(ListDatabaseOperationsRequest request) {
        return (ListDatabaseOperationsPagedResponse)((Object)this.listDatabaseOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabaseOperationsRequest, ListDatabaseOperationsPagedResponse> listDatabaseOperationsPagedCallable() {
        return this.stub.listDatabaseOperationsPagedCallable();
    }

    public final UnaryCallable<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse> listDatabaseOperationsCallable() {
        return this.stub.listDatabaseOperationsCallable();
    }

    public final ListBackupOperationsPagedResponse listBackupOperations(InstanceName parent) {
        ListBackupOperationsRequest request = ListBackupOperationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackupOperations(request);
    }

    public final ListBackupOperationsPagedResponse listBackupOperations(String parent) {
        ListBackupOperationsRequest request = ListBackupOperationsRequest.newBuilder().setParent(parent).build();
        return this.listBackupOperations(request);
    }

    public final ListBackupOperationsPagedResponse listBackupOperations(ListBackupOperationsRequest request) {
        return (ListBackupOperationsPagedResponse)((Object)this.listBackupOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupOperationsRequest, ListBackupOperationsPagedResponse> listBackupOperationsPagedCallable() {
        return this.stub.listBackupOperationsPagedCallable();
    }

    public final UnaryCallable<ListBackupOperationsRequest, ListBackupOperationsResponse> listBackupOperationsCallable() {
        return this.stub.listBackupOperationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBackupOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation, ListBackupOperationsPage, ListBackupOperationsFixedSizeCollection> {
        private ListBackupOperationsFixedSizeCollection(List<ListBackupOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupOperationsFixedSizeCollection createEmptyCollection() {
            return new ListBackupOperationsFixedSizeCollection(null, 0);
        }

        protected ListBackupOperationsFixedSizeCollection createCollection(List<ListBackupOperationsPage> pages, int collectionSize) {
            return new ListBackupOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupOperationsPage
    extends AbstractPage<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation, ListBackupOperationsPage> {
        private ListBackupOperationsPage(PageContext<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation> context, ListBackupOperationsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupOperationsPage createEmptyPage() {
            return new ListBackupOperationsPage(null, null);
        }

        protected ListBackupOperationsPage createPage(PageContext<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation> context, ListBackupOperationsResponse response) {
            return new ListBackupOperationsPage(context, response);
        }

        public ApiFuture<ListBackupOperationsPage> createPageAsync(PageContext<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation> context, ApiFuture<ListBackupOperationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupOperationsPagedResponse
    extends AbstractPagedListResponse<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation, ListBackupOperationsPage, ListBackupOperationsFixedSizeCollection> {
        public static ApiFuture<ListBackupOperationsPagedResponse> createAsync(PageContext<ListBackupOperationsRequest, ListBackupOperationsResponse, Operation> context, ApiFuture<ListBackupOperationsResponse> futureResponse) {
            ApiFuture<ListBackupOperationsPage> futurePage = ListBackupOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupOperationsPagedResponse((ListBackupOperationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupOperationsPagedResponse(ListBackupOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatabaseOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation, ListDatabaseOperationsPage, ListDatabaseOperationsFixedSizeCollection> {
        private ListDatabaseOperationsFixedSizeCollection(List<ListDatabaseOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabaseOperationsFixedSizeCollection createEmptyCollection() {
            return new ListDatabaseOperationsFixedSizeCollection(null, 0);
        }

        protected ListDatabaseOperationsFixedSizeCollection createCollection(List<ListDatabaseOperationsPage> pages, int collectionSize) {
            return new ListDatabaseOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabaseOperationsPage
    extends AbstractPage<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation, ListDatabaseOperationsPage> {
        private ListDatabaseOperationsPage(PageContext<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation> context, ListDatabaseOperationsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabaseOperationsPage createEmptyPage() {
            return new ListDatabaseOperationsPage(null, null);
        }

        protected ListDatabaseOperationsPage createPage(PageContext<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation> context, ListDatabaseOperationsResponse response) {
            return new ListDatabaseOperationsPage(context, response);
        }

        public ApiFuture<ListDatabaseOperationsPage> createPageAsync(PageContext<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation> context, ApiFuture<ListDatabaseOperationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabaseOperationsPagedResponse
    extends AbstractPagedListResponse<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation, ListDatabaseOperationsPage, ListDatabaseOperationsFixedSizeCollection> {
        public static ApiFuture<ListDatabaseOperationsPagedResponse> createAsync(PageContext<ListDatabaseOperationsRequest, ListDatabaseOperationsResponse, Operation> context, ApiFuture<ListDatabaseOperationsResponse> futureResponse) {
            ApiFuture<ListDatabaseOperationsPage> futurePage = ListDatabaseOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatabaseOperationsPagedResponse((ListDatabaseOperationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabaseOperationsPagedResponse(ListDatabaseOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabaseOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        private ListDatabasesFixedSizeCollection(List<ListDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListDatabasesFixedSizeCollection(null, 0);
        }

        protected ListDatabasesFixedSizeCollection createCollection(List<ListDatabasesPage> pages, int collectionSize) {
            return new ListDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabasesPage
    extends AbstractPage<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage> {
        private ListDatabasesPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabasesPage createEmptyPage() {
            return new ListDatabasesPage(null, null);
        }

        protected ListDatabasesPage createPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            return new ListDatabasesPage(context, response);
        }

        public ApiFuture<ListDatabasesPage> createPageAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabasesPagedResponse
    extends AbstractPagedListResponse<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        public static ApiFuture<ListDatabasesPagedResponse> createAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            ApiFuture<ListDatabasesPage> futurePage = ListDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatabasesPagedResponse((ListDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabasesPagedResponse(ListDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }
}

