/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.ServiceRpc;
import com.google.cloud.spanner.SpannerException;
import com.google.common.collect.ImmutableList;
import com.google.iam.v1.Policy;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalApi
public interface SpannerRpc
extends ServiceRpc {
    public Paginated<InstanceConfig> listInstanceConfigs(int var1, @Nullable String var2) throws SpannerException;

    public InstanceConfig getInstanceConfig(String var1) throws SpannerException;

    public Paginated<Instance> listInstances(int var1, @Nullable String var2, @Nullable String var3) throws SpannerException;

    public OperationFuture<Instance, CreateInstanceMetadata> createInstance(String var1, String var2, Instance var3) throws SpannerException;

    public OperationFuture<Instance, UpdateInstanceMetadata> updateInstance(Instance var1, FieldMask var2) throws SpannerException;

    public Instance getInstance(String var1) throws SpannerException;

    public void deleteInstance(String var1) throws SpannerException;

    public Paginated<Database> listDatabases(String var1, int var2, @Nullable String var3) throws SpannerException;

    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String var1, String var2, Iterable<String> var3) throws SpannerException;

    public OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdl(String var1, Iterable<String> var2, @Nullable String var3) throws SpannerException;

    public void dropDatabase(String var1) throws SpannerException;

    public Database getDatabase(String var1) throws SpannerException;

    public List<String> getDatabaseDdl(String var1) throws SpannerException;

    public Paginated<Backup> listBackups(String var1, int var2, @Nullable String var3, @Nullable String var4) throws SpannerException;

    public OperationFuture<Backup, CreateBackupMetadata> createBackup(String var1, String var2, Backup var3) throws SpannerException;

    public OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabase(String var1, String var2, String var3);

    public Backup getBackup(String var1) throws SpannerException;

    public Backup updateBackup(Backup var1, FieldMask var2);

    public Paginated<Operation> listBackupOperations(String var1, int var2, @Nullable String var3, @Nullable String var4);

    public void deleteBackup(String var1);

    public Paginated<Operation> listDatabaseOperations(String var1, int var2, @Nullable String var3, @Nullable String var4);

    public Operation getOperation(String var1) throws SpannerException;

    public void cancelOperation(String var1) throws SpannerException;

    public List<Session> batchCreateSessions(String var1, int var2, @Nullable Map<String, String> var3, @Nullable Map<Option, ?> var4) throws SpannerException;

    public Session createSession(String var1, @Nullable Map<String, String> var2, @Nullable Map<Option, ?> var3) throws SpannerException;

    public void deleteSession(String var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public ApiFuture<Empty> asyncDeleteSession(String var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public StreamingCall read(ReadRequest var1, ResultStreamConsumer var2, @Nullable Map<Option, ?> var3);

    public ResultSet executeQuery(ExecuteSqlRequest var1, @Nullable Map<Option, ?> var2);

    public ApiFuture<ResultSet> executeQueryAsync(ExecuteSqlRequest var1, @Nullable Map<Option, ?> var2);

    public ResultSet executePartitionedDml(ExecuteSqlRequest var1, @Nullable Map<Option, ?> var2);

    public RetrySettings getPartitionedDmlRetrySettings();

    public ServerStream<PartialResultSet> executeStreamingPartitionedDml(ExecuteSqlRequest var1, @Nullable Map<Option, ?> var2, Duration var3);

    public StreamingCall executeQuery(ExecuteSqlRequest var1, ResultStreamConsumer var2, @Nullable Map<Option, ?> var3);

    public ExecuteBatchDmlResponse executeBatchDml(ExecuteBatchDmlRequest var1, Map<Option, ?> var2);

    public ApiFuture<ExecuteBatchDmlResponse> executeBatchDmlAsync(ExecuteBatchDmlRequest var1, Map<Option, ?> var2);

    public Transaction beginTransaction(BeginTransactionRequest var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public ApiFuture<Transaction> beginTransactionAsync(BeginTransactionRequest var1, @Nullable Map<Option, ?> var2);

    public CommitResponse commit(CommitRequest var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public ApiFuture<CommitResponse> commitAsync(CommitRequest var1, @Nullable Map<Option, ?> var2);

    public void rollback(RollbackRequest var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public ApiFuture<Empty> rollbackAsync(RollbackRequest var1, @Nullable Map<Option, ?> var2);

    public PartitionResponse partitionQuery(PartitionQueryRequest var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public PartitionResponse partitionRead(PartitionReadRequest var1, @Nullable Map<Option, ?> var2) throws SpannerException;

    public Policy getDatabaseAdminIAMPolicy(String var1);

    public Policy setDatabaseAdminIAMPolicy(String var1, Policy var2);

    public TestIamPermissionsResponse testDatabaseAdminIAMPermissions(String var1, Iterable<String> var2);

    public Policy getInstanceAdminIAMPolicy(String var1);

    public Policy setInstanceAdminIAMPolicy(String var1, Policy var2);

    public TestIamPermissionsResponse testInstanceAdminIAMPermissions(String var1, Iterable<String> var2);

    public void shutdown();

    public boolean isClosed();

    public static interface StreamingCall {
        public void request(int var1);

        public void cancel(@Nullable String var1);
    }

    public static interface ResultStreamConsumer {
        public void onPartialResultSet(PartialResultSet var1);

        public void onCompleted();

        public void onError(SpannerException var1);
    }

    public static final class Paginated<T> {
        private final Iterable<T> results;
        private final String nextPageToken;

        public Paginated(@Nullable Iterable<T> results, @Nullable String nextPageToken) {
            this.results = results == null ? ImmutableList.of() : results;
            this.nextPageToken = nextPageToken == null || nextPageToken.isEmpty() ? null : nextPageToken;
        }

        public Iterable<T> getResults() {
            return this.results;
        }

        @Nullable
        public String getNextPageToken() {
            return this.nextPageToken;
        }
    }

    public static enum Option {
        CHANNEL_HINT("Channel Hint");

        private final String value;

        private Option(String value) {
            this.value = value;
        }

        <T> T get(@Nullable Map<Option, ?> options) {
            if (options == null) {
                return null;
            }
            return (T)options.get((Object)this);
        }

        Long getLong(@Nullable Map<Option, ?> options) {
            return (Long)this.get(options);
        }

        public String toString() {
            return this.value;
        }
    }
}

