/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.common.collect.ImmutableMap;
import io.grpc.Metadata;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SpannerMetadataProvider {
    private final Map<Metadata.Key<String>, String> headers;
    private final String resourceHeaderKey;
    private static final Pattern[] RESOURCE_TOKEN_PATTERNS = new Pattern[]{Pattern.compile("^(?<headerValue>projects/[^/]*/instances/[^/]*/databases/[^/]*)(.*)?"), Pattern.compile("^(?<headerValue>projects/[^/]*/instances/[^/]*)(.*)?")};

    private SpannerMetadataProvider(Map<String, String> headers, String resourceHeaderKey) {
        this.resourceHeaderKey = resourceHeaderKey;
        this.headers = this.constructHeadersAsMetadata(headers);
    }

    static SpannerMetadataProvider create(Map<String, String> headers, String resourceHeaderKey) {
        return new SpannerMetadataProvider(headers, resourceHeaderKey);
    }

    Metadata newMetadata(String resourceTokenTemplate, String defaultResourceToken) {
        Metadata metadata = new Metadata();
        for (Map.Entry<Metadata.Key<String>, String> header : this.headers.entrySet()) {
            metadata.put(header.getKey(), (Object)header.getValue());
        }
        metadata.put(Metadata.Key.of((String)this.resourceHeaderKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.getResourceHeaderValue(resourceTokenTemplate, defaultResourceToken));
        return metadata;
    }

    Map<String, List<String>> newExtraHeaders(String resourceTokenTemplate, String defaultResourceToken) {
        return ImmutableMap.builder().put((Object)this.resourceHeaderKey, Arrays.asList(this.getResourceHeaderValue(resourceTokenTemplate, defaultResourceToken))).build();
    }

    private Map<Metadata.Key<String>, String> constructHeadersAsMetadata(Map<String, String> headers) {
        ImmutableMap.Builder headersAsMetadataBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            headersAsMetadataBuilder.put((Object)Metadata.Key.of((String)entry.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)entry.getValue());
        }
        return headersAsMetadataBuilder.build();
    }

    private String getResourceHeaderValue(String resourceTokenTemplate, String defaultResourceToken) {
        String resourceToken = defaultResourceToken;
        if (resourceTokenTemplate != null) {
            for (Pattern pattern : RESOURCE_TOKEN_PATTERNS) {
                Matcher m = pattern.matcher(resourceTokenTemplate);
                if (!m.matches()) continue;
                resourceToken = m.group("headerValue");
                break;
            }
        }
        return resourceToken;
    }
}

