/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionContextFutureImpl;
import com.google.cloud.spanner.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class SessionPoolAsyncTransactionManager
implements TransactionContextFutureImpl.CommittableAsyncTransactionManager,
SessionPool.SessionNotFoundHandler {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private TransactionManager.TransactionState txnState;
    @GuardedBy(value="lock")
    private AbortedException abortedException;
    private final SessionPool pool;
    private final Options.TransactionOption[] options;
    private volatile SessionPool.PooledSessionFuture session;
    private volatile SettableApiFuture<AsyncTransactionManagerImpl> delegate;
    private boolean restartedAfterSessionNotFound;

    SessionPoolAsyncTransactionManager(SessionPool pool, SessionPool.PooledSessionFuture session, Options.TransactionOption ... options) {
        this.pool = (SessionPool)Preconditions.checkNotNull((Object)pool);
        this.options = options;
        this.createTransaction(session);
    }

    private void createTransaction(SessionPool.PooledSessionFuture session) {
        this.session = session;
        this.delegate = SettableApiFuture.create();
        this.session.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionPoolAsyncTransactionManager.this.delegate.set((Object)SessionPoolAsyncTransactionManager.this.session.get().transactionManagerAsync(SessionPoolAsyncTransactionManager.this.options));
                }
                catch (Throwable t) {
                    SessionPoolAsyncTransactionManager.this.delegate.setException(t);
                }
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public SpannerException handleSessionNotFound(SessionNotFoundException notFound) {
        this.createTransaction(this.pool.replaceSession(notFound, this.session));
        this.restartedAfterSessionNotFound = true;
        return SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, notFound.getMessage(), (Throwable)((Object)notFound));
    }

    @Override
    public void close() {
        SpannerApiFutures.get(this.closeAsync());
    }

    @Override
    public ApiFuture<Void> closeAsync() {
        final SettableApiFuture res = SettableApiFuture.create();
        ApiFutures.addCallback(this.delegate, (ApiFutureCallback)new ApiFutureCallback<AsyncTransactionManagerImpl>(){

            public void onFailure(Throwable t) {
                SessionPoolAsyncTransactionManager.this.session.close();
            }

            public void onSuccess(AsyncTransactionManagerImpl result) {
                ApiFutures.addCallback(result.closeAsync(), (ApiFutureCallback)new ApiFutureCallback<Void>(){

                    public void onFailure(Throwable t) {
                        res.setException(t);
                    }

                    public void onSuccess(Void result) {
                        SessionPoolAsyncTransactionManager.this.session.close();
                        res.set((Object)result);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncTransactionManager.TransactionContextFuture beginAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == null ? 1 : 0) != 0, (Object)"begin can only be called once");
            this.txnState = TransactionManager.TransactionState.STARTED;
        }
        final SettableApiFuture delegateTxnFuture = SettableApiFuture.create();
        ApiFutures.addCallback(this.delegate, (ApiFutureCallback)new ApiFutureCallback<AsyncTransactionManagerImpl>(){

            public void onFailure(Throwable t) {
                delegateTxnFuture.setException(t);
            }

            public void onSuccess(AsyncTransactionManagerImpl result) {
                ApiFutures.addCallback((ApiFuture)result.beginAsync(), (ApiFutureCallback)new ApiFutureCallback<TransactionContext>(){

                    public void onFailure(Throwable t) {
                        delegateTxnFuture.setException(t);
                    }

                    public void onSuccess(TransactionContext result) {
                        delegateTxnFuture.set((Object)new SessionPool.SessionPoolTransactionContext(SessionPoolAsyncTransactionManager.this, result));
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return new TransactionContextFutureImpl(this, (ApiFuture<TransactionContext>)delegateTxnFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        if (t instanceof AbortedException) {
            Object object = this.lock;
            synchronized (object) {
                this.txnState = TransactionManager.TransactionState.ABORTED;
                this.abortedException = (AbortedException)((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Timestamp> commitAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED || this.txnState == TransactionManager.TransactionState.ABORTED ? 1 : 0) != 0, (Object)("commit can only be invoked if the transaction is in progress. Current state: " + (Object)((Object)this.txnState)));
            if (this.txnState == TransactionManager.TransactionState.ABORTED) {
                return ApiFutures.immediateFailedFuture((Throwable)((Object)this.abortedException));
            }
            this.txnState = TransactionManager.TransactionState.COMMITTED;
        }
        return ApiFutures.transformAsync(this.delegate, (ApiAsyncFunction)new ApiAsyncFunction<AsyncTransactionManagerImpl, Timestamp>(){

            public ApiFuture<Timestamp> apply(AsyncTransactionManagerImpl input) throws Exception {
                final SettableApiFuture res = SettableApiFuture.create();
                ApiFutures.addCallback(input.commitAsync(), (ApiFutureCallback)new ApiFutureCallback<Timestamp>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFailure(Throwable t) {
                        Object object = SessionPoolAsyncTransactionManager.this.lock;
                        synchronized (object) {
                            if (t instanceof AbortedException) {
                                SessionPoolAsyncTransactionManager.this.txnState = TransactionManager.TransactionState.ABORTED;
                                SessionPoolAsyncTransactionManager.this.abortedException = (AbortedException)((Object)t);
                            } else {
                                SessionPoolAsyncTransactionManager.this.txnState = TransactionManager.TransactionState.COMMIT_FAILED;
                            }
                        }
                        res.setException(t);
                    }

                    public void onSuccess(Timestamp result) {
                        res.set((Object)result);
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return res;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> rollbackAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)"rollback can only be called if the transaction is in progress");
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
        return ApiFutures.transformAsync(this.delegate, (ApiAsyncFunction)new ApiAsyncFunction<AsyncTransactionManagerImpl, Void>(){

            public ApiFuture<Void> apply(AsyncTransactionManagerImpl input) throws Exception {
                ApiFuture<Void> res = input.rollbackAsync();
                res.addListener(new Runnable(){

                    @Override
                    public void run() {
                        SessionPoolAsyncTransactionManager.this.session.close();
                    }
                }, MoreExecutors.directExecutor());
                return res;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncTransactionManager.TransactionContextFuture resetForRetryAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == TransactionManager.TransactionState.ABORTED || this.restartedAfterSessionNotFound ? 1 : 0) != 0, (Object)"resetForRetry can only be called after the transaction aborted.");
            this.txnState = TransactionManager.TransactionState.STARTED;
        }
        return new TransactionContextFutureImpl(this, (ApiFuture<TransactionContext>)ApiFutures.transform((ApiFuture)ApiFutures.transformAsync(this.delegate, (ApiAsyncFunction)new ApiAsyncFunction<AsyncTransactionManagerImpl, TransactionContext>(){

            public ApiFuture<TransactionContext> apply(AsyncTransactionManagerImpl input) throws Exception {
                if (SessionPoolAsyncTransactionManager.this.restartedAfterSessionNotFound) {
                    SessionPoolAsyncTransactionManager.this.restartedAfterSessionNotFound = false;
                    return input.beginAsync();
                }
                return input.resetForRetryAsync();
            }
        }, (Executor)MoreExecutors.directExecutor()), (ApiFunction)new ApiFunction<TransactionContext, TransactionContext>(){

            public TransactionContext apply(TransactionContext input) {
                return new SessionPool.SessionPoolTransactionContext(SessionPoolAsyncTransactionManager.this, input);
            }
        }, (Executor)MoreExecutors.directExecutor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionManager.TransactionState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.txnState;
        }
    }
}

