/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class Options
implements Serializable {
    private static final long serialVersionUID = 8067099123096783941L;
    private Long limit;
    private Integer prefetchChunks;
    private Integer bufferRows;
    private Integer pageSize;
    private String pageToken;
    private String filter;

    public static ReadOption limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"Limit should be greater than 0");
        return new LimitOption(limit);
    }

    public static ReadAndQueryOption prefetchChunks(int prefetchChunks) {
        Preconditions.checkArgument((prefetchChunks > 0 ? 1 : 0) != 0, (Object)"prefetchChunks should be greater than 0");
        return new FlowControlOption(prefetchChunks);
    }

    public static ReadAndQueryOption bufferRows(int bufferRows) {
        Preconditions.checkArgument((bufferRows > 0 ? 1 : 0) != 0, (Object)"bufferRows should be greater than 0");
        return new BufferRowsOption(bufferRows);
    }

    public static ListOption pageSize(int pageSize) {
        return new PageSizeOption(pageSize);
    }

    public static ListOption pageToken(String pageToken) {
        return new PageTokenOption(pageToken);
    }

    public static ListOption filter(String filter) {
        return new FilterOption(filter);
    }

    private Options() {
    }

    boolean hasLimit() {
        return this.limit != null;
    }

    long limit() {
        return this.limit;
    }

    boolean hasPrefetchChunks() {
        return this.prefetchChunks != null;
    }

    int prefetchChunks() {
        return this.prefetchChunks;
    }

    boolean hasBufferRows() {
        return this.bufferRows != null;
    }

    int bufferRows() {
        return this.bufferRows;
    }

    boolean hasPageSize() {
        return this.pageSize != null;
    }

    int pageSize() {
        return this.pageSize;
    }

    boolean hasPageToken() {
        return this.pageToken != null;
    }

    String pageToken() {
        return this.pageToken;
    }

    boolean hasFilter() {
        return this.filter != null;
    }

    String filter() {
        return this.filter;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.limit != null) {
            b.append("limit: ").append(this.limit).append(' ');
        }
        if (this.prefetchChunks != null) {
            b.append("prefetchChunks: ").append(this.prefetchChunks).append(' ');
        }
        if (this.pageSize != null) {
            b.append("pageSize: ").append(this.pageSize).append(' ');
        }
        if (this.pageToken != null) {
            b.append("pageToken: ").append(this.pageToken).append(' ');
        }
        if (this.filter != null) {
            b.append("filter: ").append(this.filter).append(' ');
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options that = (Options)o;
        return (!this.hasLimit() && !that.hasLimit() || this.hasLimit() && that.hasLimit() && Objects.equals(this.limit(), that.limit())) && (!this.hasPrefetchChunks() && !that.hasPrefetchChunks() || this.hasPrefetchChunks() && that.hasPrefetchChunks() && Objects.equals(this.prefetchChunks(), that.prefetchChunks())) && (!this.hasBufferRows() && !that.hasBufferRows() || this.hasBufferRows() && that.hasBufferRows() && Objects.equals(this.bufferRows(), that.bufferRows())) && (!this.hasPageSize() && !that.hasPageSize() || this.hasPageSize() && that.hasPageSize() && Objects.equals(this.pageSize(), that.pageSize())) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.filter(), that.filter());
    }

    public int hashCode() {
        int result = 31;
        if (this.limit != null) {
            result = 31 * result + this.limit.hashCode();
        }
        if (this.prefetchChunks != null) {
            result = 31 * result + this.prefetchChunks.hashCode();
        }
        if (this.bufferRows != null) {
            result = 31 * result + this.bufferRows.hashCode();
        }
        if (this.pageSize != null) {
            result = 31 * result + this.pageSize.hashCode();
        }
        if (this.pageToken != null) {
            result = 31 * result + this.pageToken.hashCode();
        }
        if (this.filter != null) {
            result = 31 * result + this.filter.hashCode();
        }
        return result;
    }

    static Options fromReadOptions(ReadOption ... options) {
        Options readOptions = new Options();
        for (ReadOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(readOptions);
        }
        return readOptions;
    }

    static Options fromQueryOptions(QueryOption ... options) {
        Options readOptions = new Options();
        for (QueryOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(readOptions);
        }
        return readOptions;
    }

    static Options fromUpdateOptions(UpdateOption ... options) {
        Options updateOptions = new Options();
        for (UpdateOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(updateOptions);
        }
        return updateOptions;
    }

    static Options fromTransactionOptions(TransactionOption ... options) {
        Options transactionOptions = new Options();
        for (TransactionOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(transactionOptions);
        }
        return transactionOptions;
    }

    static Options fromListOptions(ListOption ... options) {
        Options listOptions = new Options();
        for (ListOption option : options) {
            if (!(option instanceof InternalOption)) continue;
            ((InternalOption)((Object)option)).appendToOptions(listOptions);
        }
        return listOptions;
    }

    static class FilterOption
    extends InternalOption
    implements ListOption {
        private final String filter;

        FilterOption(String filter) {
            this.filter = filter;
        }

        @Override
        void appendToOptions(Options options) {
            options.filter = this.filter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterOption)) {
                return false;
            }
            return Objects.equals(this.filter, ((FilterOption)o).filter);
        }
    }

    static class PageTokenOption
    extends InternalOption
    implements ListOption {
        private final String pageToken;

        PageTokenOption(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        void appendToOptions(Options options) {
            options.pageToken = this.pageToken;
        }
    }

    static class PageSizeOption
    extends InternalOption
    implements ListOption {
        private final int pageSize;

        PageSizeOption(int pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        void appendToOptions(Options options) {
            options.pageSize = this.pageSize;
        }
    }

    static class LimitOption
    extends InternalOption
    implements ReadOption {
        private final long limit;

        LimitOption(long limit) {
            this.limit = limit;
        }

        @Override
        void appendToOptions(Options options) {
            options.limit = this.limit;
        }
    }

    private static abstract class InternalOption {
        private InternalOption() {
        }

        abstract void appendToOptions(Options var1);
    }

    static final class BufferRowsOption
    extends InternalOption
    implements ReadAndQueryOption {
        final int bufferRows;

        BufferRowsOption(int bufferRows) {
            this.bufferRows = bufferRows;
        }

        @Override
        void appendToOptions(Options options) {
            options.bufferRows = this.bufferRows;
        }
    }

    static final class FlowControlOption
    extends InternalOption
    implements ReadAndQueryOption {
        final int prefetchChunks;

        FlowControlOption(int prefetchChunks) {
            this.prefetchChunks = prefetchChunks;
        }

        @Override
        void appendToOptions(Options options) {
            options.prefetchChunks = this.prefetchChunks;
        }
    }

    public static interface ListOption {
    }

    public static interface UpdateOption {
    }

    public static interface TransactionOption {
    }

    public static interface QueryOption {
    }

    public static interface ReadQueryUpdateTransactionOption
    extends ReadOption,
    QueryOption,
    UpdateOption,
    TransactionOption {
    }

    public static interface ReadOption {
    }

    public static interface ReadAndQueryOption
    extends ReadOption,
    QueryOption {
    }
}

