/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractMultiUseTransaction;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ChecksumResultSet;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.FailedBatchUpdate;
import com.google.cloud.spanner.connection.FailedQuery;
import com.google.cloud.spanner.connection.FailedUpdate;
import com.google.cloud.spanner.connection.RetriableBatchUpdate;
import com.google.cloud.spanner.connection.RetriableUpdate;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReadWriteTransaction
extends AbstractMultiUseTransaction {
    private static final Logger logger = Logger.getLogger(ReadWriteTransaction.class.getName());
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private static final String MAX_INTERNAL_RETRIES_EXCEEDED = "Internal transaction retry maximum exceeded";
    private static final int MAX_INTERNAL_RETRIES = 50;
    private final long transactionId;
    private final DatabaseClient dbClient;
    private TransactionManager txManager;
    private final boolean retryAbortsInternally;
    private int transactionRetryAttempts;
    private int successfulRetries;
    private final List<TransactionRetryListener> transactionRetryListeners;
    private volatile TransactionContext txContext;
    private volatile UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private boolean timedOutOrCancelled = false;
    private final List<RetriableStatement> statements = new ArrayList<RetriableStatement>();
    private final List<Mutation> mutations = new ArrayList<Mutation>();
    private Timestamp transactionStarted;
    static final StatementParser.ParsedStatement EXECUTE_BATCH_UPDATE_STATEMENT = StatementParser.INSTANCE.parse(Statement.of("RUN BATCH"));
    private static final StatementParser.ParsedStatement COMMIT_STATEMENT = StatementParser.INSTANCE.parse(Statement.of("COMMIT"));
    private final Callable<Void> commitCallable = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            ReadWriteTransaction.this.txContext.buffer(ReadWriteTransaction.this.mutations);
            ReadWriteTransaction.this.txManager.commit();
            return null;
        }
    };
    private final StatementParser.ParsedStatement rollbackStatement = StatementParser.INSTANCE.parse(Statement.of("ROLLBACK"));
    private final Callable<Void> rollbackCallable = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            ReadWriteTransaction.this.txManager.rollback();
            return null;
        }
    };

    static Builder newBuilder() {
        return new Builder();
    }

    private ReadWriteTransaction(Builder builder) {
        super(builder);
        this.transactionId = ID_GENERATOR.incrementAndGet();
        this.dbClient = builder.dbClient;
        this.retryAbortsInternally = builder.retryAbortsInternally;
        this.transactionRetryListeners = builder.transactionRetryListeners;
        this.txManager = this.dbClient.transactionManager();
    }

    public String toString() {
        return "ReadWriteTransaction - ID: " + this.transactionId + "; Status: " + this.internalGetStateName() + "; Started: " + this.internalGetTimeStarted() + "; Retry attempts: " + this.transactionRetryAttempts + "; Successful retries: " + this.successfulRetries;
    }

    private String internalGetStateName() {
        return this.transactionStarted == null ? "Not yet started" : this.getState().toString();
    }

    private String internalGetTimeStarted() {
        return this.transactionStarted == null ? "Not yet started" : this.transactionStarted.toString();
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    void checkValidTransaction() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "This transaction has status " + this.state.name() + ", only " + (Object)((Object)UnitOfWork.UnitOfWorkState.STARTED) + " is allowed.");
        ConnectionPreconditions.checkState(!this.timedOutOrCancelled, "The last statement of this transaction timed out or was cancelled. The transaction is no longer usable. Rollback the transaction and start a new one.");
        if (this.txManager.getState() == null) {
            this.transactionStarted = Timestamp.now();
            this.txContext = this.txManager.begin();
        }
        if (this.txManager.getState() != TransactionManager.TransactionState.STARTED) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, String.format("Invalid transaction state: %s", new Object[]{this.txManager.getState()}));
        }
    }

    @Override
    TransactionContext getReadContext() {
        ConnectionPreconditions.checkState(this.txContext != null, "Missing transaction context");
        return this.txContext;
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for read/write transactions.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    private boolean hasCommitTimestamp() {
        return this.txManager.getState() == TransactionManager.TransactionState.COMMITTED;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(this.hasCommitTimestamp(), "This transaction has not committed.");
        return this.txManager.getCommitTimestamp();
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return this.hasCommitTimestamp() ? this.txManager.getCommitTimestamp() : null;
    }

    @Override
    public void executeDdl(StatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DDL-statements are not allowed inside a read/write transaction.");
    }

    private void handlePossibleInvalidatingException(SpannerException e) {
        if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED || e.getErrorCode() == ErrorCode.CANCELLED) {
            this.timedOutOrCancelled = true;
        }
    }

    @Override
    public ResultSet executeQuery(final StatementParser.ParsedStatement statement, final AnalyzeMode analyzeMode, final Options.QueryOption ... options) {
        Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
        this.checkValidTransaction();
        try {
            if (this.retryAbortsInternally) {
                return this.asyncExecuteStatement(statement, new Callable<ResultSet>(){

                    @Override
                    public ResultSet call() throws Exception {
                        return ReadWriteTransaction.this.runWithRetry(new Callable<ResultSet>(){

                            @Override
                            public ResultSet call() throws Exception {
                                try {
                                    ReadWriteTransaction.this.getStatementExecutor().invokeInterceptors(statement, StatementExecutionStep.EXECUTE_STATEMENT, ReadWriteTransaction.this);
                                    DirectExecuteResultSet delegate = DirectExecuteResultSet.ofResultSet(ReadWriteTransaction.this.internalExecuteQuery(statement, analyzeMode, options));
                                    return ReadWriteTransaction.this.createAndAddRetryResultSet(delegate, statement, analyzeMode, options);
                                }
                                catch (AbortedException e) {
                                    throw e;
                                }
                                catch (SpannerException e) {
                                    ReadWriteTransaction.this.createAndAddFailedQuery(e, statement, analyzeMode, options);
                                    throw e;
                                }
                            }
                        });
                    }
                }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS);
            }
            return super.executeQuery(statement, analyzeMode, options);
        }
        catch (SpannerException e) {
            this.handlePossibleInvalidatingException(e);
            throw e;
        }
    }

    @Override
    public long executeUpdate(final StatementParser.ParsedStatement update) {
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"The statement is not an update statement");
        this.checkValidTransaction();
        try {
            if (this.retryAbortsInternally) {
                return this.asyncExecuteStatement(update, new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        return ReadWriteTransaction.this.runWithRetry(new Callable<Long>(){

                            @Override
                            public Long call() throws Exception {
                                try {
                                    ReadWriteTransaction.this.getStatementExecutor().invokeInterceptors(update, StatementExecutionStep.EXECUTE_STATEMENT, ReadWriteTransaction.this);
                                    long updateCount = ReadWriteTransaction.this.txContext.executeUpdate(update.getStatement());
                                    ReadWriteTransaction.this.createAndAddRetriableUpdate(update, updateCount);
                                    return updateCount;
                                }
                                catch (AbortedException e) {
                                    throw e;
                                }
                                catch (SpannerException e) {
                                    ReadWriteTransaction.this.createAndAddFailedUpdate(e, update);
                                    throw e;
                                }
                            }
                        });
                    }
                }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS);
            }
            return this.asyncExecuteStatement(update, new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return ReadWriteTransaction.this.txContext.executeUpdate(update.getStatement());
                }
            });
        }
        catch (SpannerException e) {
            this.handlePossibleInvalidatingException(e);
            throw e;
        }
    }

    @Override
    public long[] executeBatchUpdate(Iterable<StatementParser.ParsedStatement> updates) {
        Preconditions.checkNotNull(updates);
        final LinkedList<Statement> updateStatements = new LinkedList<Statement>();
        for (StatementParser.ParsedStatement update : updates) {
            Preconditions.checkArgument((boolean)update.isUpdate(), (Object)("Statement is not an update statement: " + update.getSqlWithoutComments()));
            updateStatements.add(update.getStatement());
        }
        this.checkValidTransaction();
        try {
            if (this.retryAbortsInternally) {
                return this.asyncExecuteStatement(EXECUTE_BATCH_UPDATE_STATEMENT, new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        return ReadWriteTransaction.this.runWithRetry(new Callable<long[]>(){

                            @Override
                            public long[] call() throws Exception {
                                try {
                                    ReadWriteTransaction.this.getStatementExecutor().invokeInterceptors(EXECUTE_BATCH_UPDATE_STATEMENT, StatementExecutionStep.EXECUTE_STATEMENT, ReadWriteTransaction.this);
                                    long[] updateCounts = ReadWriteTransaction.this.txContext.batchUpdate(updateStatements);
                                    ReadWriteTransaction.this.createAndAddRetriableBatchUpdate(updateStatements, updateCounts);
                                    return updateCounts;
                                }
                                catch (AbortedException e) {
                                    throw e;
                                }
                                catch (SpannerException e) {
                                    ReadWriteTransaction.this.createAndAddFailedBatchUpdate(e, updateStatements);
                                    throw e;
                                }
                            }
                        });
                    }
                }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS);
            }
            return this.asyncExecuteStatement(EXECUTE_BATCH_UPDATE_STATEMENT, new Callable<long[]>(){

                @Override
                public long[] call() throws Exception {
                    return ReadWriteTransaction.this.txContext.batchUpdate(updateStatements);
                }
            });
        }
        catch (SpannerException e) {
            this.handlePossibleInvalidatingException(e);
            throw e;
        }
    }

    @Override
    public void write(Mutation mutation) {
        Preconditions.checkNotNull((Object)mutation);
        this.checkValidTransaction();
        this.mutations.add(mutation);
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        this.checkValidTransaction();
        for (Mutation mutation : mutations) {
            this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
        }
    }

    @Override
    public void commit() {
        this.checkValidTransaction();
        try {
            if (this.retryAbortsInternally) {
                this.asyncExecuteStatement(COMMIT_STATEMENT, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        return ReadWriteTransaction.this.runWithRetry(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                ReadWriteTransaction.this.getStatementExecutor().invokeInterceptors(COMMIT_STATEMENT, StatementExecutionStep.EXECUTE_STATEMENT, ReadWriteTransaction.this);
                                ReadWriteTransaction.this.commitCallable.call();
                                return null;
                            }
                        });
                    }
                }, AbstractBaseUnitOfWork.InterceptorsUsage.IGNORE_INTERCEPTORS);
            } else {
                this.asyncExecuteStatement(COMMIT_STATEMENT, this.commitCallable);
            }
            this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
        }
        catch (SpannerException e) {
            try {
                this.txManager.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    <T> T runWithRetry(Callable<T> callable) throws SpannerException {
        while (true) {
            try {
                return callable.call();
            }
            catch (AbortedException aborted) {
                if (this.retryAbortsInternally) {
                    this.handleAborted(aborted);
                    continue;
                }
                throw aborted;
            }
            catch (SpannerException e) {
                throw e;
            }
            break;
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    private ResultSet createAndAddRetryResultSet(ResultSet resultSet, StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (this.retryAbortsInternally) {
            ChecksumResultSet checksumResultSet = this.createChecksumResultSet(resultSet, statement, analyzeMode, options);
            this.addRetryStatement(checksumResultSet);
            return checksumResultSet;
        }
        return resultSet;
    }

    private void createAndAddFailedQuery(SpannerException e, StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedQuery(this, e, statement, analyzeMode, options));
        }
    }

    private void createAndAddRetriableUpdate(StatementParser.ParsedStatement update, long updateCount) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new RetriableUpdate(this, update, updateCount));
        }
    }

    private void createAndAddRetriableBatchUpdate(Iterable<Statement> updates, long[] updateCounts) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new RetriableBatchUpdate(this, updates, updateCounts));
        }
    }

    private void createAndAddFailedUpdate(SpannerException e, StatementParser.ParsedStatement update) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedUpdate(this, e, update));
        }
    }

    private void createAndAddFailedBatchUpdate(SpannerException e, Iterable<Statement> updates) {
        if (this.retryAbortsInternally) {
            this.addRetryStatement(new FailedBatchUpdate(this, e, updates));
        }
    }

    private void addRetryStatement(RetriableStatement statement) {
        Preconditions.checkState((boolean)this.retryAbortsInternally, (Object)"retryAbortsInternally is not enabled for this transaction");
        this.statements.add(statement);
    }

    private void handleAborted(AbortedException aborted) {
        block18: {
            if (this.transactionRetryAttempts >= 50) {
                this.throwAbortWithRetryAttemptsExceeded();
            } else {
                if (this.retryAbortsInternally) {
                    logger.fine(this.toString() + ": Starting internal transaction retry");
                    while (true) {
                        try {
                            Thread.sleep(aborted.getRetryDelayInMillis() / 1000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "The statement was cancelled");
                        }
                        try {
                            this.txContext = this.txManager.resetForRetry();
                            this.invokeTransactionRetryListenersOnStart();
                            ++this.transactionRetryAttempts;
                            for (RetriableStatement statement : this.statements) {
                                statement.retry(aborted);
                            }
                            ++this.successfulRetries;
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_SUCCESSFUL);
                            logger.fine(this.toString() + ": Internal transaction retry succeeded. Starting retry of original statement.");
                            break block18;
                        }
                        catch (AbortedDueToConcurrentModificationException e) {
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_DUE_TO_CONCURRENT_MODIFICATION);
                            logger.fine(this.toString() + ": Internal transaction retry aborted due to a concurrent modification");
                            try {
                                this.txManager.rollback();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                            throw e;
                        }
                        catch (AbortedException e) {
                            if (this.transactionRetryAttempts >= 50) {
                                this.throwAbortWithRetryAttemptsExceeded();
                            }
                            this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_AND_RESTARTING);
                            logger.fine(this.toString() + ": Internal transaction retry aborted, trying again");
                            continue;
                        }
                        catch (SpannerException e) {
                            logger.log(Level.FINE, this.toString() + ": Internal transaction retry failed due to an unexpected exception", (Throwable)((Object)e));
                            try {
                                this.txManager.rollback();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                            throw e;
                        }
                        break;
                    }
                }
                try {
                    this.txManager.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.state = UnitOfWork.UnitOfWorkState.ABORTED;
                throw aborted;
            }
        }
    }

    private void throwAbortWithRetryAttemptsExceeded() throws SpannerException {
        this.invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult.RETRY_ABORTED_AND_MAX_ATTEMPTS_EXCEEDED);
        logger.fine(this.toString() + ": Internal transaction retry aborted and max number of retry attempts has been exceeded");
        try {
            this.txManager.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, MAX_INTERNAL_RETRIES_EXCEEDED);
    }

    private void invokeTransactionRetryListenersOnStart() {
        for (TransactionRetryListener listener : this.transactionRetryListeners) {
            listener.retryStarting(this.transactionStarted, this.transactionId, this.transactionRetryAttempts);
        }
    }

    private void invokeTransactionRetryListenersOnFinish(TransactionRetryListener.RetryResult result) {
        for (TransactionRetryListener listener : this.transactionRetryListeners) {
            listener.retryFinished(this.transactionStarted, this.transactionId, this.transactionRetryAttempts, result);
        }
    }

    @Override
    public void rollback() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "This transaction has status " + this.state.name());
        try {
            this.asyncExecuteStatement(this.rollbackStatement, this.rollbackCallable);
        }
        finally {
            try {
                this.txManager.close();
            }
            catch (Throwable throwable) {}
            this.state = UnitOfWork.UnitOfWorkState.ROLLED_BACK;
        }
    }

    @VisibleForTesting
    ChecksumResultSet createChecksumResultSet(ResultSet delegate, StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        return new ChecksumResultSet(this, delegate, statement, analyzeMode, options);
    }

    static interface RetriableStatement {
        public void retry(AbortedException var1) throws AbortedException;
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, ReadWriteTransaction> {
        private DatabaseClient dbClient;
        private Boolean retryAbortsInternally;
        private List<TransactionRetryListener> transactionRetryListeners;

        private Builder() {
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setRetryAbortsInternally(boolean retryAbortsInternally) {
            this.retryAbortsInternally = retryAbortsInternally;
            return this;
        }

        Builder setTransactionRetryListeners(List<TransactionRetryListener> listeners) {
            Preconditions.checkNotNull(listeners);
            this.transactionRetryListeners = listeners;
            return this;
        }

        @Override
        ReadWriteTransaction build() {
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.retryAbortsInternally != null ? 1 : 0) != 0, (Object)"RetryAbortsInternally is not specified");
            Preconditions.checkState((this.transactionRetryListeners != null ? 1 : 0) != 0, (Object)"TransactionRetryListeners are not specified");
            return new ReadWriteTransaction(this);
        }
    }
}

