/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

class DmlBatch
extends AbstractBaseUnitOfWork {
    private final UnitOfWork transaction;
    private final List<StatementParser.ParsedStatement> statements = new ArrayList<StatementParser.ParsedStatement>();
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;

    static Builder newBuilder() {
        return new Builder();
    }

    private DmlBatch(Builder builder) {
        super(builder);
        this.transaction = builder.transaction;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.BATCH;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultSet executeQuery(StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing queries is not allowed for DML batches.");
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for DML batches.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for DML batches.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public void executeDdl(StatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing DDL statements is not allowed for DML batches.");
    }

    @Override
    public long executeUpdate(StatementParser.ParsedStatement update) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be used for further statements");
        Preconditions.checkArgument((update.getType() == StatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)("Only DML statements are allowed. \"" + update.getSqlWithoutComments() + "\" is not a DML-statement."));
        this.statements.add(update);
        return -1L;
    }

    @Override
    public long[] executeBatchUpdate(Iterable<StatementParser.ParsedStatement> updates) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing batch updates is not allowed for DML batches.");
    }

    @Override
    public void write(Mutation mutation) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DML batches.");
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DML batches.");
    }

    @Override
    public long[] runBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be ran");
        try {
            long[] res = this.statements.isEmpty() ? new long[]{} : this.transaction.executeBatchUpdate(this.statements);
            this.state = UnitOfWork.UnitOfWorkState.RAN;
            return res;
        }
        catch (SpannerException e) {
            this.state = UnitOfWork.UnitOfWorkState.RUN_FAILED;
            throw e;
        }
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be aborted.");
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    public void commit() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not allowed for DML batches.");
    }

    @Override
    public void rollback() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not allowed for DML batches.");
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, DmlBatch> {
        private UnitOfWork transaction;

        private Builder() {
        }

        Builder setTransaction(UnitOfWork transaction) {
            Preconditions.checkNotNull((Object)transaction);
            this.transaction = transaction;
            return this;
        }

        @Override
        DmlBatch build() {
            Preconditions.checkState((this.transaction != null ? 1 : 0) != 0, (Object)"No transaction specified");
            return new DmlBatch(this);
        }
    }
}

