/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.Empty;
import io.opencensus.common.Scope;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

final class SessionPool {
    private static final Logger logger = Logger.getLogger(SessionPool.class.getName());
    private static final Tracer tracer = Tracing.getTracer();
    static final String WAIT_FOR_SESSION = "SessionPool.WaitForSession";
    private final SessionPoolOptions options;
    private final SessionClient sessionClient;
    private final ScheduledExecutorService executor;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    final PoolMaintainer poolMaintainer;
    private final Clock clock;
    private final Object lock = new Object();
    private final Random random = new Random();
    @GuardedBy(value="lock")
    private int pendingClosure;
    @GuardedBy(value="lock")
    private SettableFuture<Void> closureFuture;
    @GuardedBy(value="lock")
    private DatabaseNotFoundException databaseNotFound;
    @GuardedBy(value="lock")
    private final LinkedList<PooledSession> readSessions = new LinkedList();
    @GuardedBy(value="lock")
    private final LinkedList<PooledSession> writePreparedSessions = new LinkedList();
    @GuardedBy(value="lock")
    private final Queue<Waiter> readWaiters = new LinkedList<Waiter>();
    @GuardedBy(value="lock")
    private final Queue<Waiter> readWriteWaiters = new LinkedList<Waiter>();
    @GuardedBy(value="lock")
    private int numSessionsBeingPrepared = 0;
    @GuardedBy(value="lock")
    private int numSessionsBeingCreated = 0;
    @GuardedBy(value="lock")
    private int numSessionsInUse = 0;
    @GuardedBy(value="lock")
    private int maxSessionsInUse = 0;
    private AtomicLong numWaiterTimeouts = new AtomicLong();
    @GuardedBy(value="lock")
    private final Set<PooledSession> allSessions = new HashSet<PooledSession>();
    private final SessionClient.SessionConsumer sessionConsumer = new SessionConsumerImpl();

    static SessionPool createPool(SpannerOptions spannerOptions, SessionClient sessionClient) {
        return SessionPool.createPool(spannerOptions.getSessionPoolOptions(), (GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>)((GrpcTransportOptions)spannerOptions.getTransportOptions()).getExecutorFactory(), sessionClient);
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient) {
        return SessionPool.createPool(poolOptions, executorFactory, sessionClient, new Clock());
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient, Clock clock) {
        SessionPool pool = new SessionPool(poolOptions, executorFactory, (ScheduledExecutorService)executorFactory.get(), sessionClient, clock);
        pool.initPool();
        return pool;
    }

    private SessionPool(SessionPoolOptions options, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, ScheduledExecutorService executor, SessionClient sessionClient, Clock clock) {
        this.options = options;
        this.executorFactory = executorFactory;
        this.executor = executor;
        this.sessionClient = sessionClient;
        this.clock = clock;
        this.poolMaintainer = new PoolMaintainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfAvailableWritePreparedSessions() {
        Object object = this.lock;
        synchronized (object) {
            return this.writePreparedSessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsInPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.readSessions.size() + this.writePreparedSessions.size() + this.numSessionsBeingPrepared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsBeingCreated() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsBeingCreated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsBeingPrepared() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsBeingPrepared;
        }
    }

    @VisibleForTesting
    long getNumWaiterTimeouts() {
        return this.numWaiterTimeouts.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPool() {
        Object object = this.lock;
        synchronized (object) {
            this.poolMaintainer.init();
            if (this.options.getMinSessions() > 0) {
                this.createSessions(this.options.getMinSessions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture != null;
        }
    }

    private void handleException(SpannerException e, PooledSession session) {
        if (this.isSessionNotFound(e)) {
            this.invalidateSession(session);
        } else {
            this.releaseSession(session, Position.FIRST);
        }
    }

    private boolean isSessionNotFound(SpannerException e) {
        return e.getErrorCode() == ErrorCode.NOT_FOUND && e.getMessage().contains("Session not found");
    }

    private boolean isDatabaseNotFound(SpannerException e) {
        return e instanceof DatabaseNotFoundException;
    }

    private boolean isPermissionDenied(SpannerException e) {
        return e.getErrorCode() == ErrorCode.PERMISSION_DENIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                this.decrementPendingClosures(1);
                return;
            }
            this.allSessions.remove(session);
            this.createSessions(this.getAllowedCreateSessions(1));
        }
    }

    private PooledSession findSessionToKeepAlive(Queue<PooledSession> queue, Instant keepAliveThreshold) {
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            PooledSession session = (PooledSession)iterator.next();
            if (!session.lastUseTime.isBefore(keepAliveThreshold)) continue;
            iterator.remove();
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture == null && this.databaseNotFound == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledSession getReadSession() throws SpannerException {
        Span span = Tracing.getTracer().getCurrentSpan();
        span.addAnnotation("Acquiring session");
        Waiter waiter = null;
        PooledSession sess = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                span.addAnnotation("Pool has been closed");
                throw new IllegalStateException("Pool has been closed");
            }
            if (this.databaseNotFound != null) {
                span.addAnnotation("Database has been deleted");
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.NOT_FOUND, String.format("The session pool has been invalidated because a previous RPC returned 'Database not found': %s", this.databaseNotFound.getMessage()), (Throwable)((Object)this.databaseNotFound));
            }
            sess = this.readSessions.poll();
            if (sess == null) {
                sess = this.writePreparedSessions.poll();
                if (sess == null) {
                    span.addAnnotation("No session available");
                    this.maybeCreateSession();
                    waiter = new Waiter();
                    this.readWaiters.add(waiter);
                } else {
                    span.addAnnotation("Acquired read write session");
                }
            } else {
                span.addAnnotation("Acquired read only session");
            }
        }
        if (waiter != null) {
            logger.log(Level.FINE, "No session available in the pool. Blocking for one to become available/created");
            span.addAnnotation("Waiting for read only session to be available");
            sess = waiter.take();
        }
        sess.markBusy();
        this.incrementNumSessionsInUse();
        span.addAnnotation(this.sessionAnnotation(sess));
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledSession getReadWriteSession() {
        Span span = Tracing.getTracer().getCurrentSpan();
        span.addAnnotation("Acquiring read write session");
        Waiter waiter = null;
        PooledSession sess = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                span.addAnnotation("Pool has been closed");
                throw new IllegalStateException("Pool has been closed");
            }
            if (this.databaseNotFound != null) {
                span.addAnnotation("Database has been deleted");
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.NOT_FOUND, String.format("The session pool has been invalidated because a previous RPC returned 'Database not found': %s", this.databaseNotFound.getMessage()), (Throwable)((Object)this.databaseNotFound));
            }
            sess = this.writePreparedSessions.poll();
            if (sess == null) {
                if (this.numSessionsBeingPrepared <= this.readWriteWaiters.size()) {
                    PooledSession readSession = this.readSessions.poll();
                    if (readSession != null) {
                        span.addAnnotation("Acquired read only session. Preparing for read write transaction");
                        this.prepareSession(readSession);
                    } else {
                        span.addAnnotation("No session available");
                        this.maybeCreateSession();
                    }
                }
                waiter = new Waiter();
                this.readWriteWaiters.add(waiter);
            } else {
                span.addAnnotation("Acquired read write session");
            }
        }
        if (waiter != null) {
            logger.log(Level.FINE, "No session available in the pool. Blocking for one to become available/created");
            span.addAnnotation("Waiting for read write session to be available");
            sess = waiter.take();
        }
        sess.markBusy();
        this.incrementNumSessionsInUse();
        span.addAnnotation(this.sessionAnnotation(sess));
        return sess;
    }

    PooledSession replaceReadSession(SessionNotFoundException e, PooledSession session) {
        return this.replaceSession(e, session, false);
    }

    PooledSession replaceReadWriteSession(SessionNotFoundException e, PooledSession session) {
        return this.replaceSession(e, session, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledSession replaceSession(SessionNotFoundException e, PooledSession session, boolean write) {
        if (!this.options.isFailIfSessionNotFound() && session.allowReplacing) {
            Object object = this.lock;
            synchronized (object) {
                --this.numSessionsInUse;
            }
            session.leakedException = null;
            this.invalidateSession(session);
            return write ? this.getReadWriteSession() : this.getReadSession();
        }
        throw e;
    }

    private Annotation sessionAnnotation(Session session) {
        AttributeValue sessionId = AttributeValue.stringAttributeValue((String)session.getName());
        return Annotation.fromDescriptionAndAttributes((String)"Using Session", (Map)ImmutableMap.of((Object)"sessionId", (Object)sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            if (this.maxSessionsInUse < ++this.numSessionsInUse) {
                this.maxSessionsInUse = this.numSessionsInUse;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCreateSession() {
        Span span = Tracing.getTracer().getCurrentSpan();
        Object object = this.lock;
        synchronized (object) {
            if (this.numWaiters() >= this.numSessionsBeingCreated) {
                if (this.canCreateSession()) {
                    span.addAnnotation("Creating sessions");
                    this.createSessions(this.getAllowedCreateSessions(this.numWaiters() - this.numSessionsBeingCreated + 1));
                } else if (this.options.isFailIfPoolExhausted()) {
                    span.addAnnotation("Pool exhausted. Failing");
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.RESOURCE_EXHAUSTED, "No session available in the pool. Maximum number of sessions in the pool can be overridden by invoking SessionPoolOptions#Builder#setMaxSessions. Client can be made to block rather than fail by setting SessionPoolOptions#Builder#setBlockIfPoolExhausted.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession(PooledSession session, Position position) {
        Preconditions.checkNotNull((Object)session);
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                return;
            }
            if (this.readWaiters.size() == 0 && this.numSessionsBeingPrepared >= this.readWriteWaiters.size()) {
                if (this.shouldPrepareSession()) {
                    this.prepareSession(session);
                } else {
                    switch (position) {
                        case RANDOM: {
                            if (!this.readSessions.isEmpty()) {
                                int pos = this.random.nextInt(this.readSessions.size() + 1);
                                this.readSessions.add(pos, session);
                                break;
                            }
                        }
                        default: {
                            this.readSessions.addFirst(session);
                            break;
                        }
                    }
                }
            } else if (this.shouldUnblockReader()) {
                this.readWaiters.poll().put(session);
            } else {
                this.prepareSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreateSessionsFailure(SpannerException e, int count) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < count; ++i) {
                if (this.readWaiters.size() > 0) {
                    this.readWaiters.poll().put(e);
                    continue;
                }
                if (this.readWriteWaiters.size() <= 0) break;
                this.readWriteWaiters.poll().put(e);
            }
            this.databaseNotFound = (DatabaseNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)this.databaseNotFound), (Object)((Object)(this.isDatabaseNotFound(e) ? (DatabaseNotFoundException)e : null))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepareSessionFailure(SpannerException e, PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isSessionNotFound(e)) {
                this.invalidateSession(session);
            } else if (this.isDatabaseNotFound(e) || this.isPermissionDenied(e)) {
                while (this.readWriteWaiters.size() > 0) {
                    this.readWriteWaiters.poll().put(e);
                }
                while (this.readWaiters.size() > 0) {
                    this.readWaiters.poll().put(e);
                }
                this.allSessions.remove(session);
                if (this.isClosed()) {
                    this.decrementPendingClosures(1);
                }
                this.databaseNotFound = (DatabaseNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)this.databaseNotFound), (Object)((Object)(this.isDatabaseNotFound(e) ? (DatabaseNotFoundException)e : null))));
            } else if (this.readWriteWaiters.size() > 0) {
                this.releaseSession(session, Position.FIRST);
                this.readWriteWaiters.poll().put(e);
            } else {
                this.releaseSession(session, Position.FIRST);
            }
        }
    }

    private void decrementPendingClosures(int count) {
        this.pendingClosure -= count;
        if (this.pendingClosure == 0) {
            this.closureFuture.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> closeAsync() {
        SettableFuture<Void> retFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                throw new IllegalStateException("Close has already been invoked");
            }
            Waiter waiter = this.readWaiters.poll();
            while (waiter != null) {
                waiter.put(SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Client has been closed"));
                waiter = this.readWaiters.poll();
            }
            waiter = this.readWriteWaiters.poll();
            while (waiter != null) {
                waiter.put(SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Client has been closed"));
                waiter = this.readWriteWaiters.poll();
            }
            this.closureFuture = SettableFuture.create();
            retFuture = this.closureFuture;
            this.pendingClosure = this.totalSessions() + this.numSessionsBeingCreated + 1;
            this.poolMaintainer.close();
            this.readSessions.clear();
            this.writePreparedSessions.clear();
            for (PooledSession session : ImmutableList.copyOf(this.allSessions)) {
                if (session.leakedException != null) {
                    logger.log(Level.WARNING, "Leaked session", session.leakedException);
                }
                if (session.state == SessionState.CLOSING) continue;
                this.closeSessionAsync(session);
            }
        }
        retFuture.addListener(new Runnable(){

            @Override
            public void run() {
                SessionPool.this.executorFactory.release((ExecutorService)SessionPool.this.executor);
            }
        }, MoreExecutors.directExecutor());
        return retFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldUnblockReader() {
        Object object = this.lock;
        synchronized (object) {
            int numWriteWaiters = this.readWriteWaiters.size() - this.numSessionsBeingPrepared;
            return this.readWaiters.size() > numWriteWaiters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldPrepareSession() {
        Object object = this.lock;
        synchronized (object) {
            int preparedSessions = this.writePreparedSessions.size() + this.numSessionsBeingPrepared;
            return (double)preparedSessions < Math.floor(this.options.getWriteSessionsFraction() * (float)this.totalSessions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numWaiters() {
        Object object = this.lock;
        synchronized (object) {
            return this.readWaiters.size() + this.readWriteWaiters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int totalSessions() {
        Object object = this.lock;
        synchronized (object) {
            return this.allSessions.size();
        }
    }

    private ApiFuture<Empty> closeSessionAsync(final PooledSession sess) {
        ApiFuture<Empty> res = sess.delegate.asyncClose();
        res.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SessionPool.this.lock;
                synchronized (object) {
                    SessionPool.this.allSessions.remove(sess);
                    if (SessionPool.this.isClosed()) {
                        SessionPool.this.decrementPendingClosures(1);
                        return;
                    }
                    if (SessionPool.this.numWaiters() > SessionPool.this.numSessionsBeingCreated) {
                        SessionPool.this.createSessions(SessionPool.this.getAllowedCreateSessions(SessionPool.this.numWaiters() - SessionPool.this.numSessionsBeingCreated));
                    }
                }
            }
        }, (Executor)this.executor);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSession(final PooledSession sess) {
        Object object = this.lock;
        synchronized (object) {
            ++this.numSessionsBeingPrepared;
        }
        this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    logger.log(Level.FINE, "Preparing session");
                    sess.prepareReadWriteTransaction();
                    logger.log(Level.FINE, "Session prepared");
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.numSessionsBeingPrepared--;
                        if (!SessionPool.this.isClosed()) {
                            if (SessionPool.this.readWriteWaiters.size() > 0) {
                                ((Waiter)SessionPool.this.readWriteWaiters.poll()).put(sess);
                            } else if (SessionPool.this.readWaiters.size() > 0) {
                                ((Waiter)SessionPool.this.readWaiters.poll()).put(sess);
                            } else {
                                SessionPool.this.writePreparedSessions.add(sess);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.numSessionsBeingPrepared--;
                        if (!SessionPool.this.isClosed()) {
                            SessionPool.this.handlePrepareSessionFailure(SpannerExceptionFactory.newSpannerException(t), sess);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAllowedCreateSessions(int wantedSessions) {
        Object object = this.lock;
        synchronized (object) {
            return Math.min(wantedSessions, this.options.getMaxSessions() - (this.totalSessions() + this.numSessionsBeingCreated));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCreateSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalSessions() + this.numSessionsBeingCreated < this.options.getMaxSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessions(int sessionCount) {
        logger.log(Level.FINE, String.format("Creating %d sessions", sessionCount));
        Object object = this.lock;
        synchronized (object) {
            this.numSessionsBeingCreated += sessionCount;
            try {
                this.sessionClient.asyncBatchCreateSessions(sessionCount, this.sessionConsumer);
                logger.log(Level.FINE, "Sessions created");
            }
            catch (Throwable t) {
                this.numSessionsBeingCreated -= sessionCount;
                if (this.isClosed()) {
                    this.decrementPendingClosures(sessionCount);
                }
                this.handleCreateSessionsFailure(SpannerExceptionFactory.newSpannerException(t), sessionCount);
            }
        }
    }

    class SessionConsumerImpl
    implements SessionClient.SessionConsumer {
        SessionConsumerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionReady(SessionImpl session) {
            PooledSession pooledSession = null;
            boolean closeSession = false;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                pooledSession = new PooledSession(session);
                SessionPool.this.numSessionsBeingCreated--;
                if (SessionPool.this.closureFuture != null) {
                    closeSession = true;
                } else {
                    Preconditions.checkState((SessionPool.this.totalSessions() <= SessionPool.this.options.getMaxSessions() - 1 ? 1 : 0) != 0);
                    SessionPool.this.allSessions.add(pooledSession);
                    SessionPool.this.releaseSession(pooledSession, Position.RANDOM);
                }
            }
            if (closeSession) {
                SessionPool.this.closeSessionAsync(pooledSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionCreateFailure(Throwable t, int createFailureForSessionCount) {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsBeingCreated = SessionPool.this.numSessionsBeingCreated - createFailureForSessionCount;
                if (SessionPool.this.isClosed()) {
                    SessionPool.this.decrementPendingClosures(createFailureForSessionCount);
                }
                SessionPool.this.handleCreateSessionsFailure(SpannerExceptionFactory.newSpannerException(t), createFailureForSessionCount);
            }
        }
    }

    private static enum Position {
        FIRST,
        RANDOM;

    }

    final class PoolMaintainer {
        private final Duration windowLength = Duration.ofMillis((long)TimeUnit.MINUTES.toMillis(10L));
        @VisibleForTesting
        static final long LOOP_FREQUENCY = 10000L;
        @VisibleForTesting
        final long numClosureCycles = this.windowLength.toMillis() / 10000L;
        private final Duration keepAliveMilis = Duration.ofMillis((long)TimeUnit.MINUTES.toMillis(SessionPool.access$2200(SessionPool.this).getKeepAliveIntervalMinutes()));
        @VisibleForTesting
        final long numKeepAliveCycles = this.keepAliveMilis.toMillis() / 10000L;
        Instant lastResetTime = Instant.ofEpochMilli((long)0L);
        int numSessionsToClose = 0;
        int sessionsToClosePerLoop = 0;
        @GuardedBy(value="lock")
        ScheduledFuture<?> scheduledFuture;
        @GuardedBy(value="lock")
        boolean running;

        PoolMaintainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                this.scheduledFuture = SessionPool.this.executor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        PoolMaintainer.this.maintainPool();
                    }
                }, 10000L, 10000L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                this.scheduledFuture.cancel(false);
                if (!this.running) {
                    SessionPool.this.decrementPendingClosures(1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maintainPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (SessionPool.this.isClosed()) {
                    return;
                }
                this.running = true;
            }
            Instant currTime = SessionPool.this.clock.instant();
            this.closeIdleSessions(currTime);
            this.keepAliveSessions(currTime);
            this.replenishPool();
            Object object2 = SessionPool.this.lock;
            synchronized (object2) {
                this.running = false;
                if (SessionPool.this.isClosed()) {
                    SessionPool.this.decrementPendingClosures(1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeIdleSessions(Instant currTime) {
            LinkedList<PooledSession> sessionsToClose = new LinkedList<PooledSession>();
            Iterator iterator = SessionPool.this.lock;
            synchronized (iterator) {
                if (currTime.isAfter(this.lastResetTime.plus((TemporalAmount)this.windowLength))) {
                    int sessionsToKeep = Math.max(SessionPool.this.options.getMinSessions(), SessionPool.this.maxSessionsInUse + SessionPool.this.options.getMaxIdleSessions());
                    this.numSessionsToClose = SessionPool.this.totalSessions() - sessionsToKeep;
                    this.sessionsToClosePerLoop = (int)Math.ceil((double)this.numSessionsToClose / (double)this.numClosureCycles);
                    SessionPool.this.maxSessionsInUse = 0;
                    this.lastResetTime = currTime;
                }
                if (this.numSessionsToClose > 0) {
                    while (sessionsToClose.size() < Math.min(this.numSessionsToClose, this.sessionsToClosePerLoop)) {
                        PooledSession sess;
                        PooledSession pooledSession = sess = SessionPool.this.readSessions.size() > 0 ? (PooledSession)SessionPool.this.readSessions.poll() : (PooledSession)SessionPool.this.writePreparedSessions.poll();
                        if (sess == null) break;
                        if (sess.state == SessionState.CLOSING) continue;
                        sess.markClosing();
                        sessionsToClose.add(sess);
                    }
                    this.numSessionsToClose -= sessionsToClose.size();
                }
            }
            for (PooledSession sess : sessionsToClose) {
                logger.log(Level.FINE, "Closing session {0}", sess.getName());
                SessionPool.this.closeSessionAsync(sess);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAliveSessions(Instant currTime) {
            long numSessionsToKeepAlive = 0L;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                numSessionsToKeepAlive = (long)Math.ceil((double)SessionPool.this.totalSessions() / (double)this.numKeepAliveCycles);
            }
            Instant keepAliveThreshold = currTime.minus((TemporalAmount)this.keepAliveMilis);
            while (numSessionsToKeepAlive > 0L) {
                PooledSession sessionToKeepAlive = null;
                Object object2 = SessionPool.this.lock;
                synchronized (object2) {
                    sessionToKeepAlive = SessionPool.this.findSessionToKeepAlive(SessionPool.this.readSessions, keepAliveThreshold);
                    if (sessionToKeepAlive == null) {
                        sessionToKeepAlive = SessionPool.this.findSessionToKeepAlive(SessionPool.this.writePreparedSessions, keepAliveThreshold);
                    }
                }
                if (sessionToKeepAlive == null) break;
                try {
                    logger.log(Level.FINE, "Keeping alive session " + sessionToKeepAlive.getName());
                    --numSessionsToKeepAlive;
                    sessionToKeepAlive.keepAlive();
                    SessionPool.this.releaseSession(sessionToKeepAlive, Position.FIRST);
                }
                catch (SpannerException e) {
                    SessionPool.this.handleException(e, sessionToKeepAlive);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replenishPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                int sessionCount = SessionPool.this.options.getMinSessions() - (SessionPool.this.totalSessions() + SessionPool.this.numSessionsBeingCreated);
                if (sessionCount > 0) {
                    SessionPool.this.createSessions(SessionPool.this.getAllowedCreateSessions(sessionCount));
                }
            }
        }
    }

    private final class Waiter {
        private static final long MAX_SESSION_WAIT_TIMEOUT = 240000L;
        private final SynchronousQueue<SessionOrError> waiter = new SynchronousQueue();

        private Waiter() {
        }

        private void put(PooledSession session) {
            Uninterruptibles.putUninterruptibly(this.waiter, (Object)new SessionOrError(session));
        }

        private void put(SpannerException e) {
            Uninterruptibles.putUninterruptibly(this.waiter, (Object)new SessionOrError(e));
        }

        private PooledSession take() throws SpannerException {
            long currentTimeout = SessionPool.this.options.getInitialWaitForSessionTimeoutMillis();
            while (true) {
                Span span = tracer.spanBuilder(SessionPool.WAIT_FOR_SESSION).startSpan();
                try {
                    Scope waitScope = tracer.withSpan(span);
                    Throwable throwable = null;
                    try {
                        SessionOrError s = this.pollUninterruptiblyWithTimeout(currentTimeout);
                        if (s == null) {
                            SessionPool.this.numWaiterTimeouts.incrementAndGet();
                            tracer.getCurrentSpan().setStatus(Status.DEADLINE_EXCEEDED);
                            currentTimeout = Math.min(currentTimeout * 2L, 240000L);
                            continue;
                        }
                        if (s.e != null) {
                            throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)s.e));
                        }
                        PooledSession pooledSession = s.session;
                        return pooledSession;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (waitScope == null) continue;
                        if (throwable != null) {
                            try {
                                waitScope.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        waitScope.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    TraceUtil.endSpanWithFailure(tracer.getCurrentSpan(), e);
                    throw e;
                }
                finally {
                    span.end(TraceUtil.END_SPAN_OPTIONS);
                    continue;
                }
                break;
            }
        }

        private SessionOrError pollUninterruptiblyWithTimeout(long timeoutMillis) {
            boolean interrupted = false;
            while (true) {
                try {
                    SessionOrError sessionOrError = this.waiter.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                    return sessionOrError;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static final class SessionOrError {
        private final PooledSession session;
        private final SpannerException e;

        SessionOrError(PooledSession session) {
            this.session = session;
            this.e = null;
        }

        SessionOrError(SpannerException e) {
            this.session = null;
            this.e = e;
        }
    }

    final class PooledSession
    implements Session {
        @VisibleForTesting
        SessionImpl delegate;
        private volatile Instant lastUseTime;
        private volatile SpannerException lastException;
        private volatile LeakedSessionException leakedException;
        private volatile boolean allowReplacing = true;
        @GuardedBy(value="lock")
        private SessionState state;

        private PooledSession(SessionImpl delegate) {
            this.delegate = delegate;
            this.state = SessionState.AVAILABLE;
            this.lastUseTime = SessionPool.this.clock.instant();
        }

        @VisibleForTesting
        void setAllowReplacing(boolean allowReplacing) {
            this.allowReplacing = allowReplacing;
        }

        @VisibleForTesting
        void clearLeakedException() {
            this.leakedException = null;
        }

        private void markBusy() {
            this.state = SessionState.BUSY;
            this.leakedException = new LeakedSessionException();
        }

        private void markClosing() {
            this.state = SessionState.CLOSING;
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            try {
                this.markUsed();
                Timestamp timestamp = this.delegate.write(mutations);
                return timestamp;
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
            finally {
                this.close();
            }
        }

        @Override
        public long executePartitionedUpdate(Statement stmt) throws SpannerException {
            try {
                this.markUsed();
                long l = this.delegate.executePartitionedUpdate(stmt);
                return l;
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
            finally {
                this.close();
            }
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            try {
                this.markUsed();
                Timestamp timestamp = this.delegate.writeAtLeastOnce(mutations);
                return timestamp;
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
            finally {
                this.close();
            }
        }

        @Override
        public ReadContext singleUse() {
            try {
                return new AutoClosingReadContext((Function)new Function<PooledSession, ReadContext>(){

                    public ReadContext apply(PooledSession session) {
                        return session.delegate.singleUse();
                    }
                }, SessionPool.this, this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadContext singleUse(final TimestampBound bound) {
            try {
                return new AutoClosingReadContext((Function)new Function<PooledSession, ReadContext>(){

                    public ReadContext apply(PooledSession session) {
                        return session.delegate.singleUse(bound);
                    }
                }, SessionPool.this, this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.internalReadOnlyTransaction(new Function<PooledSession, ReadOnlyTransaction>(){

                public ReadOnlyTransaction apply(PooledSession session) {
                    return session.delegate.singleUseReadOnlyTransaction();
                }
            }, true);
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(final TimestampBound bound) {
            return this.internalReadOnlyTransaction(new Function<PooledSession, ReadOnlyTransaction>(){

                public ReadOnlyTransaction apply(PooledSession session) {
                    return session.delegate.singleUseReadOnlyTransaction(bound);
                }
            }, true);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            return this.internalReadOnlyTransaction(new Function<PooledSession, ReadOnlyTransaction>(){

                public ReadOnlyTransaction apply(PooledSession session) {
                    return session.delegate.readOnlyTransaction();
                }
            }, false);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(final TimestampBound bound) {
            return this.internalReadOnlyTransaction(new Function<PooledSession, ReadOnlyTransaction>(){

                public ReadOnlyTransaction apply(PooledSession session) {
                    return session.delegate.readOnlyTransaction(bound);
                }
            }, false);
        }

        private ReadOnlyTransaction internalReadOnlyTransaction(Function<PooledSession, ReadOnlyTransaction> transactionSupplier, boolean isSingleUse) {
            try {
                return new AutoClosingReadTransaction(transactionSupplier, SessionPool.this, this, isSingleUse);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public TransactionRunner readWriteTransaction() {
            return new SessionPoolTransactionRunner(SessionPool.this, this);
        }

        @Override
        public ApiFuture<Empty> asyncClose() {
            this.close();
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsInUse--;
            }
            this.leakedException = null;
            if (this.lastException != null && SessionPool.this.isSessionNotFound(this.lastException)) {
                SessionPool.this.invalidateSession(this);
            } else {
                if (this.lastException != null && SessionPool.this.isDatabaseNotFound(this.lastException)) {
                    object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.databaseNotFound = (DatabaseNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)SessionPool.this.databaseNotFound), (Object)((Object)((DatabaseNotFoundException)this.lastException))));
                    }
                }
                this.lastException = null;
                if (this.state != SessionState.CLOSING) {
                    this.state = SessionState.AVAILABLE;
                }
                SessionPool.this.releaseSession(this, Position.FIRST);
            }
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void prepareReadWriteTransaction() {
            this.markUsed();
            this.delegate.prepareReadWriteTransaction();
        }

        private void keepAlive() {
            this.markUsed();
            try (ResultSet resultSet = this.delegate.singleUse(TimestampBound.ofMaxStaleness(60L, TimeUnit.SECONDS)).executeQuery(Statement.newBuilder("SELECT 1").build(), new Options.QueryOption[0]);){
                resultSet.next();
            }
        }

        private void markUsed() {
            this.lastUseTime = SessionPool.this.clock.instant();
        }

        @Override
        public TransactionManager transactionManager() {
            return new AutoClosingTransactionManager(SessionPool.this, this);
        }
    }

    private static enum SessionState {
        AVAILABLE,
        BUSY,
        CLOSING;

    }

    private final class LeakedSessionException
    extends RuntimeException {
        private static final long serialVersionUID = 1451131180314064914L;

        private LeakedSessionException() {
            super("Session was checked out from the pool at " + SessionPool.this.clock.instant());
        }
    }

    private static final class SessionPoolTransactionRunner
    implements TransactionRunner {
        private final SessionPool sessionPool;
        private PooledSession session;
        private TransactionRunner runner;

        private SessionPoolTransactionRunner(SessionPool sessionPool, PooledSession session) {
            this.sessionPool = sessionPool;
            this.session = session;
            this.runner = session.delegate.readWriteTransaction();
        }

        @Override
        @Nullable
        public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
            try {
                T result;
                while (true) {
                    try {
                        result = this.runner.run(callable);
                    }
                    catch (SessionNotFoundException e) {
                        this.session = this.sessionPool.replaceReadWriteSession(e, this.session);
                        this.runner = this.session.delegate.readWriteTransaction();
                        continue;
                    }
                    break;
                }
                this.session.markUsed();
                T t = result;
                return t;
            }
            catch (SpannerException e) {
                throw this.session.lastException = e;
            }
            finally {
                this.session.close();
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.runner.getCommitTimestamp();
        }

        @Override
        public TransactionRunner allowNestedTransaction() {
            this.runner.allowNestedTransaction();
            return this;
        }
    }

    private static class AutoClosingTransactionManager
    implements TransactionManager {
        private TransactionManager delegate;
        private final SessionPool sessionPool;
        private PooledSession session;
        private boolean closed;
        private boolean restartedAfterSessionNotFound;

        AutoClosingTransactionManager(SessionPool sessionPool, PooledSession session) {
            this.sessionPool = sessionPool;
            this.session = session;
            this.delegate = session.delegate.transactionManager();
        }

        @Override
        public TransactionContext begin() {
            while (true) {
                try {
                    return this.internalBegin();
                }
                catch (SessionNotFoundException e) {
                    this.session = this.sessionPool.replaceReadWriteSession(e, this.session);
                    this.delegate = this.session.delegate.transactionManager();
                    continue;
                }
                break;
            }
        }

        private TransactionContext internalBegin() {
            SessionPoolTransactionContext res = new SessionPoolTransactionContext(this.delegate.begin());
            this.session.markUsed();
            return res;
        }

        private SpannerException handleSessionNotFound(SessionNotFoundException e) {
            this.session = this.sessionPool.replaceReadWriteSession(e, this.session);
            this.delegate = this.session.delegate.transactionManager();
            this.restartedAfterSessionNotFound = true;
            return SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, e.getMessage(), (Throwable)((Object)e));
        }

        @Override
        public void commit() {
            try {
                this.delegate.commit();
            }
            catch (SessionNotFoundException e) {
                throw this.handleSessionNotFound(e);
            }
            finally {
                if (this.getState() != TransactionManager.TransactionState.ABORTED) {
                    this.close();
                }
            }
        }

        @Override
        public void rollback() {
            try {
                this.delegate.rollback();
            }
            finally {
                this.close();
            }
        }

        @Override
        public TransactionContext resetForRetry() {
            while (true) {
                try {
                    if (this.restartedAfterSessionNotFound) {
                        SessionPoolTransactionContext res = new SessionPoolTransactionContext(this.delegate.begin());
                        this.restartedAfterSessionNotFound = false;
                        return res;
                    }
                    return new SessionPoolTransactionContext(this.delegate.resetForRetry());
                }
                catch (SessionNotFoundException e) {
                    this.session = this.sessionPool.replaceReadWriteSession(e, this.session);
                    this.delegate = this.session.delegate.transactionManager();
                    this.restartedAfterSessionNotFound = true;
                    continue;
                }
                break;
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.delegate.getCommitTimestamp();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.delegate.close();
            }
            finally {
                this.session.close();
            }
        }

        @Override
        public TransactionManager.TransactionState getState() {
            if (this.restartedAfterSessionNotFound) {
                return TransactionManager.TransactionState.ABORTED;
            }
            return this.delegate.getState();
        }

        private class SessionPoolTransactionContext
        implements TransactionContext {
            private final TransactionContext delegate;

            private SessionPoolTransactionContext(TransactionContext delegate) {
                this.delegate = delegate;
            }

            @Override
            public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
                return new SessionPoolResultSet(this.delegate.read(table, keys, columns, options));
            }

            @Override
            public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
                return new SessionPoolResultSet(this.delegate.readUsingIndex(table, index, keys, columns, options));
            }

            @Override
            public Struct readRow(String table, Key key, Iterable<String> columns) {
                try {
                    return this.delegate.readRow(table, key, columns);
                }
                catch (SessionNotFoundException e) {
                    throw AutoClosingTransactionManager.this.handleSessionNotFound(e);
                }
            }

            @Override
            public void buffer(Mutation mutation) {
                this.delegate.buffer(mutation);
            }

            @Override
            public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
                try {
                    return this.delegate.readRowUsingIndex(table, index, key, columns);
                }
                catch (SessionNotFoundException e) {
                    throw AutoClosingTransactionManager.this.handleSessionNotFound(e);
                }
            }

            @Override
            public void buffer(Iterable<Mutation> mutations) {
                this.delegate.buffer(mutations);
            }

            @Override
            public long executeUpdate(Statement statement) {
                try {
                    return this.delegate.executeUpdate(statement);
                }
                catch (SessionNotFoundException e) {
                    throw AutoClosingTransactionManager.this.handleSessionNotFound(e);
                }
            }

            @Override
            public long[] batchUpdate(Iterable<Statement> statements) {
                try {
                    return this.delegate.batchUpdate(statements);
                }
                catch (SessionNotFoundException e) {
                    throw AutoClosingTransactionManager.this.handleSessionNotFound(e);
                }
            }

            @Override
            public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
                return new SessionPoolResultSet(this.delegate.executeQuery(statement, options));
            }

            @Override
            public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
                return new SessionPoolResultSet(this.delegate.analyzeQuery(statement, queryMode));
            }

            @Override
            public void close() {
                this.delegate.close();
            }
        }

        private class SessionPoolResultSet
        extends ForwardingResultSet {
            private SessionPoolResultSet(ResultSet delegate) {
                super(delegate);
            }

            @Override
            public boolean next() {
                try {
                    return super.next();
                }
                catch (SessionNotFoundException e) {
                    throw AutoClosingTransactionManager.this.handleSessionNotFound(e);
                }
            }
        }
    }

    private static class AutoClosingReadTransaction
    extends AutoClosingReadContext<ReadOnlyTransaction>
    implements ReadOnlyTransaction {
        AutoClosingReadTransaction(Function<PooledSession, ReadOnlyTransaction> txnSupplier, SessionPool sessionPool, PooledSession session, boolean isSingleUse) {
            super(txnSupplier, sessionPool, session, isSingleUse);
        }

        @Override
        public Timestamp getReadTimestamp() {
            return ((ReadOnlyTransaction)this.getReadContextDelegate()).getReadTimestamp();
        }
    }

    private static class AutoClosingReadContext<T extends ReadContext>
    implements ReadContext {
        private final Function<PooledSession, T> readContextDelegateSupplier;
        private T readContextDelegate;
        private final SessionPool sessionPool;
        private PooledSession session;
        private final boolean isSingleUse;
        private boolean closed;
        private boolean sessionUsedForQuery = false;

        private AutoClosingReadContext(Function<PooledSession, T> delegateSupplier, SessionPool sessionPool, PooledSession session, boolean isSingleUse) {
            this.readContextDelegateSupplier = delegateSupplier;
            this.sessionPool = sessionPool;
            this.session = session;
            this.isSingleUse = isSingleUse;
            while (true) {
                try {
                    this.readContextDelegate = (ReadContext)this.readContextDelegateSupplier.apply((Object)this.session);
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
        }

        T getReadContextDelegate() {
            return this.readContextDelegate;
        }

        private ResultSet wrap(final Supplier<ResultSet> resultSetSupplier) {
            ResultSet res;
            while (true) {
                try {
                    res = (ResultSet)resultSetSupplier.get();
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            return new ForwardingResultSet(res){
                private boolean beforeFirst;
                {
                    super(delegate);
                    this.beforeFirst = true;
                }

                @Override
                public boolean next() throws SpannerException {
                    while (true) {
                        try {
                            return this.internalNext();
                        }
                        catch (SessionNotFoundException e) {
                            AutoClosingReadContext.this.replaceSessionIfPossible(e);
                            this.replaceDelegate((ResultSet)resultSetSupplier.get());
                            continue;
                        }
                        break;
                    }
                }

                private boolean internalNext() {
                    try {
                        boolean ret = super.next();
                        if (this.beforeFirst) {
                            AutoClosingReadContext.this.session.markUsed();
                            this.beforeFirst = false;
                            AutoClosingReadContext.this.sessionUsedForQuery = true;
                        }
                        if (!ret && AutoClosingReadContext.this.isSingleUse) {
                            this.close();
                        }
                        return ret;
                    }
                    catch (SessionNotFoundException e) {
                        throw e;
                    }
                    catch (SpannerException e) {
                        if (!AutoClosingReadContext.this.closed && AutoClosingReadContext.this.isSingleUse) {
                            AutoClosingReadContext.this.session.lastException = e;
                            AutoClosingReadContext.this.close();
                        }
                        throw e;
                    }
                }

                @Override
                public void close() {
                    super.close();
                    if (AutoClosingReadContext.this.isSingleUse) {
                        AutoClosingReadContext.this.close();
                    }
                }
            };
        }

        private void replaceSessionIfPossible(SessionNotFoundException e) {
            if (!this.isSingleUse && this.sessionUsedForQuery) {
                throw e;
            }
            this.session = this.sessionPool.replaceReadSession(e, this.session);
            this.readContextDelegate = (ReadContext)this.readContextDelegateSupplier.apply((Object)this.session);
        }

        @Override
        public ResultSet read(final String table, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return this.wrap(new Supplier<ResultSet>(){

                public ResultSet get() {
                    return AutoClosingReadContext.this.readContextDelegate.read(table, keys, columns, options);
                }
            });
        }

        @Override
        public ResultSet readUsingIndex(final String table, final String index, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return this.wrap(new Supplier<ResultSet>(){

                public ResultSet get() {
                    return AutoClosingReadContext.this.readContextDelegate.readUsingIndex(table, index, keys, columns, options);
                }
            });
        }

        @Override
        @Nullable
        public Struct readRow(String table, Key key, Iterable<String> columns) {
            while (true) {
                try {
                    this.session.markUsed();
                    Struct struct = this.readContextDelegate.readRow(table, key, columns);
                    return struct;
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            finally {
                this.sessionUsedForQuery = true;
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        @Nullable
        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            while (true) {
                try {
                    this.session.markUsed();
                    Struct struct = this.readContextDelegate.readRowUsingIndex(table, index, key, columns);
                    return struct;
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            finally {
                this.sessionUsedForQuery = true;
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        public ResultSet executeQuery(final Statement statement, final Options.QueryOption ... options) {
            return this.wrap(new Supplier<ResultSet>(){

                public ResultSet get() {
                    return AutoClosingReadContext.this.readContextDelegate.executeQuery(statement, options);
                }
            });
        }

        @Override
        public ResultSet analyzeQuery(final Statement statement, final ReadContext.QueryAnalyzeMode queryMode) {
            return this.wrap(new Supplier<ResultSet>(){

                public ResultSet get() {
                    return AutoClosingReadContext.this.readContextDelegate.analyzeQuery(statement, queryMode);
                }
            });
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.readContextDelegate.close();
            this.session.close();
        }
    }

    static class Clock {
        Clock() {
        }

        Instant instant() {
            return Instant.now();
        }
    }
}

