/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.ByteString;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TypeCode;
import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class AbstractResultSet<R>
extends AbstractStructReader
implements ResultSet {
    private static final Tracer tracer = Tracing.getTracer();

    AbstractResultSet() {
    }

    private static double valueProtoToFloat64(Value proto) {
        if (proto.getKindCase() == Value.KindCase.STRING_VALUE) {
            switch (proto.getStringValue()) {
                case "-Infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
                case "Infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "NaN": {
                    return Double.NaN;
                }
            }
        }
        if (proto.getKindCase() != Value.KindCase.NUMBER_VALUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value for column type " + Type.float64() + " expected NUMBER_VALUE or STRING_VALUE with value one of \"Infinity\", \"-Infinity\", or \"NaN\" but was " + proto.getKindCase() + (proto.getKindCase() == Value.KindCase.STRING_VALUE ? " with value \"" + proto.getStringValue() + "\"" : ""));
        }
        return proto.getNumberValue();
    }

    private static NullPointerException throwNotNull(int columnIndex) {
        throw new NullPointerException("Cannot call array getter for column " + columnIndex + " with null elements");
    }

    protected abstract GrpcStruct currRow();

    @Override
    public Struct getCurrentRowAsStruct() {
        return this.currRow().immutableCopy();
    }

    @Override
    protected boolean getBooleanInternal(int columnIndex) {
        return this.currRow().getBooleanInternal(columnIndex);
    }

    @Override
    protected long getLongInternal(int columnIndex) {
        return this.currRow().getLongInternal(columnIndex);
    }

    @Override
    protected double getDoubleInternal(int columnIndex) {
        return this.currRow().getDoubleInternal(columnIndex);
    }

    @Override
    protected String getStringInternal(int columnIndex) {
        return this.currRow().getStringInternal(columnIndex);
    }

    @Override
    protected ByteArray getBytesInternal(int columnIndex) {
        return this.currRow().getBytesInternal(columnIndex);
    }

    @Override
    protected Timestamp getTimestampInternal(int columnIndex) {
        return this.currRow().getTimestampInternal(columnIndex);
    }

    @Override
    protected Date getDateInternal(int columnIndex) {
        return this.currRow().getDateInternal(columnIndex);
    }

    @Override
    protected boolean[] getBooleanArrayInternal(int columnIndex) {
        return this.currRow().getBooleanArrayInternal(columnIndex);
    }

    @Override
    protected List<Boolean> getBooleanListInternal(int columnIndex) {
        return this.currRow().getBooleanListInternal(columnIndex);
    }

    @Override
    protected long[] getLongArrayInternal(int columnIndex) {
        return this.currRow().getLongArrayInternal(columnIndex);
    }

    @Override
    protected List<Long> getLongListInternal(int columnIndex) {
        return this.currRow().getLongListInternal(columnIndex);
    }

    @Override
    protected double[] getDoubleArrayInternal(int columnIndex) {
        return this.currRow().getDoubleArrayInternal(columnIndex);
    }

    @Override
    protected List<Double> getDoubleListInternal(int columnIndex) {
        return this.currRow().getDoubleListInternal(columnIndex);
    }

    @Override
    protected List<String> getStringListInternal(int columnIndex) {
        return this.currRow().getStringListInternal(columnIndex);
    }

    @Override
    protected List<ByteArray> getBytesListInternal(int columnIndex) {
        return this.currRow().getBytesListInternal(columnIndex);
    }

    @Override
    protected List<Timestamp> getTimestampListInternal(int columnIndex) {
        return this.currRow().getTimestampListInternal(columnIndex);
    }

    @Override
    protected List<Date> getDateListInternal(int columnIndex) {
        return this.currRow().getDateListInternal(columnIndex);
    }

    @Override
    protected List<Struct> getStructListInternal(int columnIndex) {
        return this.currRow().getStructListInternal(columnIndex);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.currRow().isNull(columnIndex);
    }

    private static class Float64Array
    extends PrimitiveArray<Double, double[]> {
        Float64Array(ListValue protoList) {
            super(protoList);
        }

        Float64Array(double[] data, BitSet nulls) {
            super(data, nulls, data.length);
        }

        @Override
        double[] newArray(int size) {
            return new double[size];
        }

        @Override
        void setProto(double[] array, int i, Value protoValue) {
            array[i] = AbstractResultSet.valueProtoToFloat64(protoValue);
        }

        @Override
        Double get(double[] array, int i) {
            return array[i];
        }
    }

    private static class Int64Array
    extends PrimitiveArray<Long, long[]> {
        Int64Array(ListValue protoList) {
            super(protoList);
        }

        Int64Array(long[] data, BitSet nulls) {
            super(data, nulls, data.length);
        }

        @Override
        long[] newArray(int size) {
            return new long[size];
        }

        @Override
        void setProto(long[] array, int i, Value protoValue) {
            array[i] = Long.parseLong(protoValue.getStringValue());
        }

        @Override
        Long get(long[] array, int i) {
            return array[i];
        }
    }

    private static abstract class PrimitiveArray<T, A>
    extends AbstractList<T> {
        private final A data;
        private final BitSet nulls;
        private final int size;

        PrimitiveArray(ListValue protoList) {
            this.size = protoList.getValuesCount();
            A data = this.newArray(this.size);
            BitSet nulls = new BitSet(this.size);
            for (int i = 0; i < protoList.getValuesCount(); ++i) {
                if (protoList.getValues(i).getKindCase() == Value.KindCase.NULL_VALUE) {
                    nulls.set(i);
                    continue;
                }
                this.setProto(data, i, protoList.getValues(i));
            }
            this.data = data;
            this.nulls = nulls;
        }

        PrimitiveArray(A data, BitSet nulls, int size) {
            this.data = data;
            this.nulls = nulls;
            this.size = size;
        }

        abstract A newArray(int var1);

        abstract void setProto(A var1, int var2, Value var3);

        abstract T get(A var1, int var2);

        @Override
        public T get(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException("index=" + index + " size=" + this.size);
            }
            return this.nulls.get(index) ? null : (T)this.get(this.data, index);
        }

        @Override
        public int size() {
            return this.size;
        }

        A toPrimitiveArray(int columnIndex) {
            if (this.nulls.length() > 0) {
                throw AbstractResultSet.throwNotNull(columnIndex);
            }
            A r = this.newArray(this.size);
            System.arraycopy(this.data, 0, r, 0, this.size);
            return r;
        }
    }

    @VisibleForTesting
    static abstract class ResumableStreamIterator
    extends AbstractIterator<PartialResultSet>
    implements CloseableIterator<PartialResultSet> {
        private static final Logger logger = Logger.getLogger(ResumableStreamIterator.class.getName());
        private final BackOff backOff = SpannerImpl.newBackOff();
        private final LinkedList<PartialResultSet> buffer = new LinkedList();
        private final int maxBufferSize;
        private final Span span;
        private CloseableIterator<PartialResultSet> stream;
        private ByteString resumeToken;
        private boolean finished;
        private boolean safeToRetry = true;

        protected ResumableStreamIterator(int maxBufferSize, String streamName, Span parent) {
            Preconditions.checkArgument((maxBufferSize >= 0 ? 1 : 0) != 0);
            this.maxBufferSize = maxBufferSize;
            this.span = tracer.spanBuilderWithExplicitParent(streamName, parent).startSpan();
        }

        abstract CloseableIterator<PartialResultSet> startStream(@Nullable ByteString var1);

        @Override
        public void close(@Nullable String message) {
            if (this.stream != null) {
                this.stream.close(message);
                this.span.end(TraceUtil.END_SPAN_OPTIONS);
            }
        }

        protected PartialResultSet computeNext() {
            Context context = Context.current();
            while (true) {
                if (this.stream == null) {
                    this.span.addAnnotation("Starting/Resuming stream", (Map)ImmutableMap.of((Object)"ResumeToken", (Object)AttributeValue.stringAttributeValue((String)(this.resumeToken == null ? "null" : this.resumeToken.toStringUtf8()))));
                    try (Scope s = tracer.withSpan(this.span);){
                        this.stream = (CloseableIterator)Preconditions.checkNotNull(this.startStream(this.resumeToken));
                    }
                }
                if (!(this.buffer.isEmpty() || !this.finished && this.safeToRetry && this.buffer.getLast().getResumeToken().isEmpty())) {
                    return this.buffer.pop();
                }
                try {
                    if (this.stream.hasNext()) {
                        boolean hasResumeToken;
                        PartialResultSet next = (PartialResultSet)this.stream.next();
                        boolean bl = hasResumeToken = !next.getResumeToken().isEmpty();
                        if (hasResumeToken) {
                            this.resumeToken = next.getResumeToken();
                            this.safeToRetry = true;
                        }
                        if ((hasResumeToken || !this.safeToRetry) && this.buffer.isEmpty()) {
                            return next;
                        }
                        this.buffer.add(next);
                        if (this.buffer.size() <= this.maxBufferSize || !this.buffer.getLast().getResumeToken().isEmpty()) continue;
                        this.safeToRetry = false;
                        continue;
                    }
                    this.finished = true;
                    if (!this.buffer.isEmpty()) continue;
                    this.endOfData();
                    return null;
                }
                catch (SpannerException e) {
                    if (this.safeToRetry && e.isRetryable()) {
                        this.span.addAnnotation("Stream broken. Safe to retry", TraceUtil.getExceptionAnnotations(e));
                        logger.log(Level.FINE, "Retryable exception, will sleep and retry", (Throwable)((Object)e));
                        while (!this.buffer.isEmpty() && this.buffer.getLast().getResumeToken().isEmpty()) {
                            this.buffer.removeLast();
                        }
                        assert (this.buffer.isEmpty() || this.buffer.getLast().getResumeToken().equals((Object)this.resumeToken));
                        this.stream = null;
                        Scope s = tracer.withSpan(this.span);
                        Throwable throwable = null;
                        try {
                            long delay = e.getRetryDelayInMillis();
                            if (delay != -1L) {
                                SpannerImpl.backoffSleep(context, delay);
                                continue;
                            }
                            SpannerImpl.backoffSleep(context, this.backOff);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (s == null) continue;
                            if (throwable != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            s.close();
                            continue;
                        }
                    }
                    this.span.addAnnotation("Stream broken. Not safe to retry");
                    TraceUtil.endSpanWithFailure(this.span, e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.span.addAnnotation("Stream broken. Not safe to retry");
                    TraceUtil.endSpanWithFailure(this.span, e);
                    throw e;
                }
                break;
            }
        }
    }

    @VisibleForTesting
    static class GrpcStreamIterator
    extends AbstractIterator<PartialResultSet>
    implements CloseableIterator<PartialResultSet> {
        private static final PartialResultSet END_OF_STREAM = PartialResultSet.newBuilder().build();
        private final ConsumerImpl consumer = new ConsumerImpl();
        private final BlockingQueue<PartialResultSet> stream;
        private SpannerRpc.StreamingCall call;
        private SpannerException error;

        GrpcStreamIterator(int prefetchChunks) {
            this.stream = new LinkedBlockingQueue<PartialResultSet>(prefetchChunks + 1);
        }

        protected final SpannerRpc.ResultStreamConsumer consumer() {
            return this.consumer;
        }

        public void setCall(SpannerRpc.StreamingCall call) {
            this.call = call;
        }

        @Override
        public void close(@Nullable String message) {
            if (this.call != null) {
                this.call.cancel(message);
            }
        }

        protected final PartialResultSet computeNext() {
            PartialResultSet next;
            try {
                next = this.stream.take();
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            if (next != END_OF_STREAM) {
                this.call.request(1);
                return next;
            }
            this.call = null;
            if (this.error != null) {
                throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)this.error));
            }
            this.endOfData();
            return null;
        }

        private void addToStream(PartialResultSet results) {
            Uninterruptibles.putUninterruptibly(this.stream, (Object)results);
        }

        private class ConsumerImpl
        implements SpannerRpc.ResultStreamConsumer {
            private ConsumerImpl() {
            }

            @Override
            public void onPartialResultSet(PartialResultSet results) {
                GrpcStreamIterator.this.addToStream(results);
            }

            @Override
            public void onCompleted() {
                GrpcStreamIterator.this.addToStream(END_OF_STREAM);
            }

            @Override
            public void onError(SpannerException e) {
                GrpcStreamIterator.this.error = e;
                GrpcStreamIterator.this.addToStream(END_OF_STREAM);
            }

            @VisibleForTesting
            void setCall(SpannerRpc.StreamingCall call) {
                GrpcStreamIterator.this.setCall(call);
            }
        }
    }

    @VisibleForTesting
    static interface CloseableIterator<T>
    extends Iterator<T> {
        public void close(@Nullable String var1);
    }

    static class GrpcStruct
    extends Struct
    implements Serializable {
        private final Type type;
        private final List<Object> rowData;

        private Object writeReplace() {
            Struct.Builder builder = Struct.newBuilder();
            List<Type.StructField> structFields = this.getType().getStructFields();
            block21: for (int i = 0; i < structFields.size(); ++i) {
                Type.StructField field = structFields.get(i);
                String fieldName = field.getName();
                Object value = this.rowData.get(i);
                Type fieldType = field.getType();
                switch (fieldType.getCode()) {
                    case BOOL: {
                        builder.set(fieldName).to((Boolean)value);
                        continue block21;
                    }
                    case INT64: {
                        builder.set(fieldName).to((Long)value);
                        continue block21;
                    }
                    case FLOAT64: {
                        builder.set(fieldName).to((Double)value);
                        continue block21;
                    }
                    case STRING: {
                        builder.set(fieldName).to((String)value);
                        continue block21;
                    }
                    case BYTES: {
                        builder.set(fieldName).to((ByteArray)value);
                        continue block21;
                    }
                    case TIMESTAMP: {
                        builder.set(fieldName).to((Timestamp)value);
                        continue block21;
                    }
                    case DATE: {
                        builder.set(fieldName).to((Date)value);
                        continue block21;
                    }
                    case ARRAY: {
                        switch (fieldType.getArrayElementType().getCode()) {
                            case BOOL: {
                                builder.set(fieldName).toBoolArray((Iterable)value);
                                continue block21;
                            }
                            case INT64: {
                                builder.set(fieldName).toInt64Array((Iterable)value);
                                continue block21;
                            }
                            case FLOAT64: {
                                builder.set(fieldName).toFloat64Array((Iterable)value);
                                continue block21;
                            }
                            case STRING: {
                                builder.set(fieldName).toStringArray((Iterable)value);
                                continue block21;
                            }
                            case BYTES: {
                                builder.set(fieldName).toBytesArray((Iterable)value);
                                continue block21;
                            }
                            case TIMESTAMP: {
                                builder.set(fieldName).toTimestampArray((Iterable)value);
                                continue block21;
                            }
                            case DATE: {
                                builder.set(fieldName).toDateArray((Iterable)value);
                                continue block21;
                            }
                            case STRUCT: {
                                builder.set(fieldName).toStructArray(fieldType.getArrayElementType(), (Iterable)value);
                                continue block21;
                            }
                        }
                        throw new AssertionError((Object)("Unhandled array type code: " + fieldType.getArrayElementType()));
                    }
                    case STRUCT: {
                        if (value == null) {
                            builder.set(fieldName).to(fieldType, null);
                            continue block21;
                        }
                        builder.set(fieldName).to((Struct)value);
                        continue block21;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)fieldType.getCode())));
                    }
                }
            }
            return builder.build();
        }

        GrpcStruct(Type type, List<Object> rowData) {
            this.type = type;
            this.rowData = rowData;
        }

        public String toString() {
            return this.rowData.toString();
        }

        boolean consumeRow(Iterator<Value> iterator) {
            this.rowData.clear();
            if (!iterator.hasNext()) {
                return false;
            }
            for (Type.StructField fieldType : this.getType().getStructFields()) {
                if (!iterator.hasNext()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value stream: end of stream reached before row is complete");
                }
                Value value = iterator.next();
                this.rowData.add(GrpcStruct.decodeValue(fieldType.getType(), value));
            }
            return true;
        }

        private static Object decodeValue(Type fieldType, Value proto) {
            if (proto.getKindCase() == Value.KindCase.NULL_VALUE) {
                return null;
            }
            switch (fieldType.getCode()) {
                case BOOL: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.BOOL_VALUE);
                    return proto.getBoolValue();
                }
                case INT64: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return Long.parseLong(proto.getStringValue());
                }
                case FLOAT64: {
                    return AbstractResultSet.valueProtoToFloat64(proto);
                }
                case STRING: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return proto.getStringValue();
                }
                case BYTES: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return ByteArray.fromBase64((String)proto.getStringValue());
                }
                case TIMESTAMP: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return Timestamp.parseTimestamp((String)proto.getStringValue());
                }
                case DATE: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return Date.parseDate((String)proto.getStringValue());
                }
                case ARRAY: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.LIST_VALUE);
                    ListValue listValue = proto.getListValue();
                    return GrpcStruct.decodeArrayValue(fieldType.getArrayElementType(), listValue);
                }
                case STRUCT: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.LIST_VALUE);
                    ListValue structValue = proto.getListValue();
                    return GrpcStruct.decodeStructValue(fieldType, structValue);
                }
            }
            throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)fieldType.getCode())));
        }

        private static Struct decodeStructValue(Type structType, ListValue structValue) {
            List<Type.StructField> fieldTypes = structType.getStructFields();
            Preconditions.checkArgument((structValue.getValuesCount() == fieldTypes.size() ? 1 : 0) != 0, (Object)"Size mismatch between type descriptor and actual values.");
            ArrayList<Object> fields = new ArrayList<Object>(fieldTypes.size());
            List fieldValues = structValue.getValuesList();
            for (int i = 0; i < fieldTypes.size(); ++i) {
                fields.add(GrpcStruct.decodeValue(fieldTypes.get(i).getType(), (Value)fieldValues.get(i)));
            }
            return new GrpcStruct(structType, fields);
        }

        private static Object decodeArrayValue(Type elementType, ListValue listValue) {
            switch (elementType.getCode()) {
                case BOOL: {
                    return Lists.transform((List)listValue.getValuesList(), (Function)new Function<Value, Boolean>(){

                        public Boolean apply(Value input) {
                            return input.getKindCase() == Value.KindCase.NULL_VALUE ? null : Boolean.valueOf(input.getBoolValue());
                        }
                    });
                }
                case INT64: {
                    return new Int64Array(listValue);
                }
                case FLOAT64: {
                    return new Float64Array(listValue);
                }
                case STRING: {
                    return Lists.transform((List)listValue.getValuesList(), (Function)new Function<Value, String>(){

                        public String apply(Value input) {
                            return input.getKindCase() == Value.KindCase.NULL_VALUE ? null : input.getStringValue();
                        }
                    });
                }
                case BYTES: {
                    ArrayList<ByteArray> list = new ArrayList<ByteArray>(listValue.getValuesCount());
                    for (Value value : listValue.getValuesList()) {
                        list.add(value.getKindCase() == Value.KindCase.NULL_VALUE ? null : ByteArray.fromBase64((String)value.getStringValue()));
                    }
                    return list;
                }
                case TIMESTAMP: {
                    ArrayList<Timestamp> list = new ArrayList<Timestamp>(listValue.getValuesCount());
                    for (Value value : listValue.getValuesList()) {
                        list.add(value.getKindCase() == Value.KindCase.NULL_VALUE ? null : Timestamp.parseTimestamp((String)value.getStringValue()));
                    }
                    return list;
                }
                case DATE: {
                    ArrayList<Date> list = new ArrayList<Date>(listValue.getValuesCount());
                    for (Value value : listValue.getValuesList()) {
                        list.add(value.getKindCase() == Value.KindCase.NULL_VALUE ? null : Date.parseDate((String)value.getStringValue()));
                    }
                    return list;
                }
                case STRUCT: {
                    ArrayList<Struct> list = new ArrayList<Struct>(listValue.getValuesCount());
                    for (Value value : listValue.getValuesList()) {
                        if (value.getKindCase() == Value.KindCase.NULL_VALUE) {
                            list.add(null);
                            continue;
                        }
                        ListValue structValue = value.getListValue();
                        list.add(GrpcStruct.decodeStructValue(elementType, structValue));
                    }
                    return list;
                }
            }
            throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)elementType.getCode())));
        }

        private static void checkType(Type fieldType, Value proto, Value.KindCase expected) {
            if (proto.getKindCase() != expected) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value for column type " + fieldType + " expected " + expected + " but was " + proto.getKindCase());
            }
        }

        Struct immutableCopy() {
            return new GrpcStruct(this.type, new ArrayList<Object>(this.rowData));
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isNull(int columnIndex) {
            return this.rowData.get(columnIndex) == null;
        }

        @Override
        protected boolean getBooleanInternal(int columnIndex) {
            return (Boolean)this.rowData.get(columnIndex);
        }

        @Override
        protected long getLongInternal(int columnIndex) {
            return (Long)this.rowData.get(columnIndex);
        }

        @Override
        protected double getDoubleInternal(int columnIndex) {
            return (Double)this.rowData.get(columnIndex);
        }

        @Override
        protected String getStringInternal(int columnIndex) {
            return (String)this.rowData.get(columnIndex);
        }

        @Override
        protected ByteArray getBytesInternal(int columnIndex) {
            return (ByteArray)this.rowData.get(columnIndex);
        }

        @Override
        protected Timestamp getTimestampInternal(int columnIndex) {
            return (Timestamp)this.rowData.get(columnIndex);
        }

        @Override
        protected Date getDateInternal(int columnIndex) {
            return (Date)this.rowData.get(columnIndex);
        }

        @Override
        protected Struct getStructInternal(int columnIndex) {
            return (Struct)this.rowData.get(columnIndex);
        }

        @Override
        protected boolean[] getBooleanArrayInternal(int columnIndex) {
            List values = (List)this.rowData.get(columnIndex);
            boolean[] r = new boolean[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) {
                    throw AbstractResultSet.throwNotNull(columnIndex);
                }
                r[i] = (Boolean)values.get(i);
            }
            return r;
        }

        @Override
        protected List<Boolean> getBooleanListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected long[] getLongArrayInternal(int columnIndex) {
            return (long[])this.getLongListInternal(columnIndex).toPrimitiveArray(columnIndex);
        }

        protected Int64Array getLongListInternal(int columnIndex) {
            return (Int64Array)this.rowData.get(columnIndex);
        }

        @Override
        protected double[] getDoubleArrayInternal(int columnIndex) {
            return (double[])this.getDoubleListInternal(columnIndex).toPrimitiveArray(columnIndex);
        }

        protected Float64Array getDoubleListInternal(int columnIndex) {
            return (Float64Array)this.rowData.get(columnIndex);
        }

        @Override
        protected List<String> getStringListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<ByteArray> getBytesListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<Timestamp> getTimestampListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<Date> getDateListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<Struct> getStructListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }
    }

    private static class GrpcValueIterator
    extends AbstractIterator<Value> {
        private final CloseableIterator<PartialResultSet> stream;
        private ResultSetMetadata metadata;
        private Type type;
        private PartialResultSet current;
        private int pos;
        private ResultSetStats statistics;

        GrpcValueIterator(CloseableIterator<PartialResultSet> stream) {
            this.stream = stream;
        }

        protected Value computeNext() {
            Object merged;
            Value value;
            Value.KindCase kind;
            if (!this.ensureReady(StreamValue.RESULT)) {
                this.endOfData();
                return null;
            }
            if (!this.isMergeable(kind = (value = this.current.getValues(this.pos++)).getKindCase())) {
                if (this.pos == this.current.getValuesCount() && this.current.getChunkedValue()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Unexpected chunked PartialResultSet.");
                }
                return value;
            }
            if (!this.current.getChunkedValue() || this.pos != this.current.getValuesCount()) {
                return value;
            }
            Object object = merged = kind == Value.KindCase.STRING_VALUE ? value.getStringValue() : new ArrayList(value.getListValue().getValuesList());
            while (this.current.getChunkedValue() && this.pos == this.current.getValuesCount()) {
                Value newValue;
                if (!this.ensureReady(StreamValue.RESULT)) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed in the middle of chunked value");
                }
                if ((newValue = this.current.getValues(this.pos++)).getKindCase() != kind) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Unexpected type in middle of chunked value. Expected: " + kind + " but got: " + newValue.getKindCase());
                }
                if (kind == Value.KindCase.STRING_VALUE) {
                    merged = (String)merged + newValue.getStringValue();
                    continue;
                }
                this.concatLists((List)merged, newValue.getListValue().getValuesList());
            }
            if (kind == Value.KindCase.STRING_VALUE) {
                return Value.newBuilder().setStringValue((String)merged).build();
            }
            return Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)((List)merged))).build();
        }

        ResultSetMetadata getMetadata() throws SpannerException {
            if (this.metadata == null && !this.ensureReady(StreamValue.METADATA)) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed without sending metadata");
            }
            return this.metadata;
        }

        @Nullable
        ResultSetStats getStats() {
            return this.statistics;
        }

        Type type() {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"metadata has not been received");
            return this.type;
        }

        private boolean ensureReady(StreamValue requiredValue) throws SpannerException {
            while (this.current == null || this.pos >= this.current.getValuesCount()) {
                if (!this.stream.hasNext()) {
                    return false;
                }
                this.current = (PartialResultSet)this.stream.next();
                this.pos = 0;
                if (this.type == null) {
                    if (!this.current.hasMetadata() || !this.current.getMetadata().hasRowType()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing type metadata in first message");
                    }
                    this.metadata = this.current.getMetadata();
                    com.google.spanner.v1.Type typeProto = com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRUCT).setStructType(this.metadata.getRowType()).build();
                    try {
                        this.type = Type.fromProto(typeProto);
                    }
                    catch (IllegalArgumentException e) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid type metadata: " + e.getMessage(), e);
                    }
                }
                if (this.current.hasStats()) {
                    this.statistics = this.current.getStats();
                }
                if (requiredValue != StreamValue.METADATA) continue;
                return true;
            }
            return true;
        }

        void close(@Nullable String message) {
            this.stream.close(message);
        }

        private void concatLists(List<Value> a, List<Value> b) {
            if (a.size() == 0 || b.size() == 0) {
                a.addAll(b);
                return;
            }
            Value last = a.get(a.size() - 1);
            Value first = b.get(0);
            Value.KindCase lastKind = last.getKindCase();
            Value.KindCase firstKind = first.getKindCase();
            if (this.isMergeable(lastKind) && lastKind == firstKind) {
                Value merged = null;
                if (lastKind == Value.KindCase.STRING_VALUE) {
                    String lastStr = last.getStringValue();
                    String firstStr = first.getStringValue();
                    merged = Value.newBuilder().setStringValue(lastStr + firstStr).build();
                } else {
                    ArrayList<Value> mergedList = new ArrayList<Value>();
                    mergedList.addAll(last.getListValue().getValuesList());
                    this.concatLists(mergedList, first.getListValue().getValuesList());
                    merged = Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(mergedList)).build();
                }
                a.set(a.size() - 1, merged);
                a.addAll(b.subList(1, b.size()));
            } else {
                a.addAll(b);
            }
        }

        private boolean isMergeable(Value.KindCase kind) {
            return kind == Value.KindCase.STRING_VALUE || kind == Value.KindCase.LIST_VALUE;
        }

        private static enum StreamValue {
            METADATA,
            RESULT;

        }
    }

    @VisibleForTesting
    static class GrpcResultSet
    extends AbstractResultSet<List<Object>> {
        private final GrpcValueIterator iterator;
        private final Listener listener;
        private GrpcStruct currRow;
        private SpannerException error;
        private ResultSetStats statistics;
        private boolean closed;

        GrpcResultSet(CloseableIterator<PartialResultSet> iterator, Listener listener) {
            this.iterator = new GrpcValueIterator(iterator);
            this.listener = listener;
        }

        @Override
        protected GrpcStruct currRow() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
            Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
            return this.currRow;
        }

        @Override
        public boolean next() throws SpannerException {
            if (this.error != null) {
                throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)this.error));
            }
            try {
                boolean hasNext;
                if (this.currRow == null) {
                    ResultSetMetadata metadata = this.iterator.getMetadata();
                    if (metadata.hasTransaction()) {
                        this.listener.onTransactionMetadata(metadata.getTransaction());
                    }
                    this.currRow = new GrpcStruct(this.iterator.type(), new ArrayList<Object>());
                }
                if (!(hasNext = this.currRow.consumeRow((Iterator<Value>)((Object)this.iterator)))) {
                    this.statistics = this.iterator.getStats();
                }
                return hasNext;
            }
            catch (SpannerException e) {
                throw this.yieldError(e);
            }
        }

        @Override
        @Nullable
        public ResultSetStats getStats() {
            return this.statistics;
        }

        @Override
        public void close() {
            this.iterator.close("ResultSet closed");
            this.closed = true;
        }

        @Override
        public Type getType() {
            Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
            return this.currRow.getType();
        }

        private SpannerException yieldError(SpannerException e) {
            this.close();
            this.listener.onError(e);
            throw e;
        }
    }

    static interface Listener {
        public void onTransactionMetadata(Transaction var1) throws SpannerException;

        public void onError(SpannerException var1);

        public void onDone();
    }
}

