/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.spi.SpannerRpcFactory;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class SpannerOptions
extends ServiceOptions<Spanner, SpannerOptions> {
    private static final long serialVersionUID = 2789571558532701170L;
    private static final String JDBC_API_CLIENT_LIB_TOKEN = "sp-jdbc";
    private static final String HIBERNATE_API_CLIENT_LIB_TOKEN = "sp-hib";
    private static final String API_SHORT_NAME = "Spanner";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final ImmutableSet<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/spanner.admin", (Object)"https://www.googleapis.com/auth/spanner.data");
    private static final int MAX_CHANNELS = 256;
    private final TransportChannelProvider channelProvider;
    private final ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
    private final GrpcInterceptorProvider interceptorProvider;
    private final SessionPoolOptions sessionPoolOptions;
    private final int prefetchChunks;
    private final int numChannels;
    private final ImmutableMap<String, String> sessionLabels;
    private final SpannerStubSettings spannerStubSettings;
    private final InstanceAdminStubSettings instanceAdminStubSettings;
    private final DatabaseAdminStubSettings databaseAdminStubSettings;
    private final Duration partitionedDmlTimeout;

    private SpannerOptions(Builder builder) {
        super(SpannerFactory.class, SpannerRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new SpannerDefaults());
        this.numChannels = builder.numChannels;
        Preconditions.checkArgument((this.numChannels >= 1 && this.numChannels <= 256 ? 1 : 0) != 0, (String)"Number of channels must fall in the range [1, %s], found: %s", (int)256, (int)this.numChannels);
        this.channelProvider = builder.channelProvider;
        this.channelConfigurator = builder.channelConfigurator;
        this.interceptorProvider = builder.interceptorProvider;
        this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : SessionPoolOptions.newBuilder().build();
        this.prefetchChunks = builder.prefetchChunks;
        this.sessionLabels = builder.sessionLabels;
        try {
            this.spannerStubSettings = builder.spannerStubSettingsBuilder.build();
            this.instanceAdminStubSettings = builder.instanceAdminStubSettingsBuilder.build();
            this.databaseAdminStubSettings = builder.databaseAdminStubSettingsBuilder.build();
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
        this.partitionedDmlTimeout = builder.partitionedDmlTimeout;
    }

    public static SpannerOptions getDefaultInstance() {
        return SpannerOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public TransportChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
        return this.channelConfigurator;
    }

    public GrpcInterceptorProvider getInterceptorProvider() {
        return this.interceptorProvider;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public Map<String, String> getSessionLabels() {
        return this.sessionLabels;
    }

    public SpannerStubSettings getSpannerStubSettings() {
        return this.spannerStubSettings;
    }

    public InstanceAdminStubSettings getInstanceAdminStubSettings() {
        return this.instanceAdminStubSettings;
    }

    public DatabaseAdminStubSettings getDatabaseAdminStubSettings() {
        return this.databaseAdminStubSettings;
    }

    public Duration getPartitionedDmlTimeout() {
        return this.partitionedDmlTimeout;
    }

    public int getPrefetchChunks() {
        return this.prefetchChunks;
    }

    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    public Set<String> getScopes() {
        return SCOPES;
    }

    protected SpannerRpc getSpannerRpcV1() {
        return (SpannerRpc)this.getRpc();
    }

    protected boolean shouldRefreshService(Spanner cachedService) {
        return cachedService == null || cachedService.isClosed();
    }

    protected boolean shouldRefreshRpc(ServiceRpc cachedRpc) {
        return cachedRpc == null || ((SpannerRpc)cachedRpc).isClosed();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getEndpoint() {
        URL url;
        try {
            url = new URL(this.getHost());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid host: " + this.getHost(), e);
        }
        return String.format("%s:%s", url.getHost(), url.getPort() < 0 ? url.getDefaultPort() : url.getPort());
    }

    private static class SpannerDefaults
    implements ServiceDefaults<Spanner, SpannerOptions> {
        private SpannerDefaults() {
        }

        public SpannerFactory getDefaultServiceFactory() {
            return DefaultSpannerFactory.INSTANCE;
        }

        public SpannerRpcFactory getDefaultRpcFactory() {
            return DefaultSpannerRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return SpannerOptions.getDefaultGrpcTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Spanner, SpannerOptions, Builder> {
        private static final int DEFAULT_PREFETCH_CHUNKS = 4;
        private final ImmutableSet<String> allowedClientLibTokens = ImmutableSet.of((Object)ServiceOptions.getGoogApiClientLibName(), (Object)"sp-jdbc", (Object)"sp-hib");
        private TransportChannelProvider channelProvider;
        private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        private GrpcInterceptorProvider interceptorProvider;
        private int numChannels = 4;
        private int prefetchChunks = 4;
        private SessionPoolOptions sessionPoolOptions;
        private ImmutableMap<String, String> sessionLabels;
        private SpannerStubSettings.Builder spannerStubSettingsBuilder = SpannerStubSettings.newBuilder();
        private InstanceAdminStubSettings.Builder instanceAdminStubSettingsBuilder = InstanceAdminStubSettings.newBuilder();
        private DatabaseAdminStubSettings.Builder databaseAdminStubSettingsBuilder = DatabaseAdminStubSettings.newBuilder();
        private Duration partitionedDmlTimeout = Duration.ofHours((long)2L);

        private Builder() {
        }

        Builder(SpannerOptions options) {
            super((ServiceOptions)options);
            this.numChannels = options.numChannels;
            this.sessionPoolOptions = options.sessionPoolOptions;
            this.prefetchChunks = options.prefetchChunks;
            this.sessionLabels = options.sessionLabels;
            this.spannerStubSettingsBuilder = options.spannerStubSettings.toBuilder();
            this.instanceAdminStubSettingsBuilder = options.instanceAdminStubSettings.toBuilder();
            this.databaseAdminStubSettingsBuilder = options.databaseAdminStubSettings.toBuilder();
            this.partitionedDmlTimeout = options.partitionedDmlTimeout;
            this.channelProvider = options.channelProvider;
            this.channelConfigurator = options.channelConfigurator;
            this.interceptorProvider = options.interceptorProvider;
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only grpc transport is allowed for Spanner.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        protected Set<String> getAllowedClientLibTokens() {
            return this.allowedClientLibTokens;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = channelProvider;
            return this;
        }

        public Builder setChannelConfigurator(ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        public Builder setInterceptorProvider(GrpcInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public Builder setNumChannels(int numChannels) {
            this.numChannels = numChannels;
            return this;
        }

        public Builder setSessionPoolOption(SessionPoolOptions sessionPoolOptions) {
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setSessionLabels(Map<String, String> sessionLabels) {
            Preconditions.checkNotNull(sessionLabels, (Object)"Session labels map cannot be null");
            for (String value : sessionLabels.values()) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed in the labels map.");
            }
            this.sessionLabels = ImmutableMap.copyOf(sessionLabels);
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            throw new UnsupportedOperationException("SpannerOptions does not support setting global retry settings. Call spannerStubSettingsBuilder().<method-name>Settings().setRetrySettings(RetrySettings) instead.");
        }

        public SpannerStubSettings.Builder getSpannerStubSettingsBuilder() {
            return this.spannerStubSettingsBuilder;
        }

        public InstanceAdminStubSettings.Builder getInstanceAdminStubSettingsBuilder() {
            return this.instanceAdminStubSettingsBuilder;
        }

        public DatabaseAdminStubSettings.Builder getDatabaseAdminStubSettingsBuilder() {
            return this.databaseAdminStubSettingsBuilder;
        }

        public Builder setPartitionedDmlTimeout(Duration timeout) {
            this.partitionedDmlTimeout = timeout;
            return this;
        }

        public Builder setPrefetchChunks(int prefetchChunks) {
            this.prefetchChunks = prefetchChunks;
            return this;
        }

        public SpannerOptions build() {
            return new SpannerOptions(this);
        }
    }

    private static class DefaultSpannerRpcFactory
    implements SpannerRpcFactory {
        private static final DefaultSpannerRpcFactory INSTANCE = new DefaultSpannerRpcFactory();

        private DefaultSpannerRpcFactory() {
        }

        public ServiceRpc create(SpannerOptions options) {
            return new GapicSpannerRpc(options);
        }
    }

    private static class DefaultSpannerFactory
    implements SpannerFactory {
        private static final DefaultSpannerFactory INSTANCE = new DefaultSpannerFactory();

        private DefaultSpannerFactory() {
        }

        public Spanner create(SpannerOptions serviceOptions) {
            return new SpannerImpl(serviceOptions);
        }
    }
}

