/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Struct;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartitionOptions;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.TransactionSelector;
import java.util.List;
import java.util.Map;

public class BatchClientImpl
implements BatchClient {
    private final SessionClient sessionClient;

    BatchClientImpl(SessionClient sessionClient) {
        this.sessionClient = (SessionClient)Preconditions.checkNotNull((Object)sessionClient);
    }

    @Override
    public BatchReadOnlyTransaction batchReadOnlyTransaction(TimestampBound bound) {
        SessionImpl session = this.sessionClient.createSession();
        return new BatchReadOnlyTransactionImpl(this.sessionClient.getSpanner(), session, (TimestampBound)Preconditions.checkNotNull((Object)bound));
    }

    @Override
    public BatchReadOnlyTransaction batchReadOnlyTransaction(BatchTransactionId batchTransactionId) {
        SessionImpl session = this.sessionClient.sessionWithId(((BatchTransactionId)Preconditions.checkNotNull((Object)batchTransactionId)).getSessionId());
        return new BatchReadOnlyTransactionImpl(this.sessionClient.getSpanner(), session, batchTransactionId);
    }

    private static class BatchReadOnlyTransactionImpl
    extends AbstractReadContext.MultiUseReadOnlyTransaction
    implements BatchReadOnlyTransaction {
        private final String sessionName;
        private final Map<SpannerRpc.Option, ?> options;

        BatchReadOnlyTransactionImpl(SpannerImpl spanner, SessionImpl session, TimestampBound bound) {
            super((SessionImpl)Preconditions.checkNotNull((Object)session), (TimestampBound)Preconditions.checkNotNull((Object)bound), ((SpannerOptions)((SpannerImpl)Preconditions.checkNotNull((Object)spanner)).getOptions()).getSpannerRpcV1(), ((SpannerOptions)spanner.getOptions()).getPrefetchChunks());
            this.sessionName = session.getName();
            this.options = session.getOptions();
            this.initTransaction();
        }

        BatchReadOnlyTransactionImpl(SpannerImpl spanner, SessionImpl session, BatchTransactionId batchTransactionId) {
            super((SessionImpl)Preconditions.checkNotNull((Object)session), ((BatchTransactionId)Preconditions.checkNotNull((Object)batchTransactionId)).getTransactionId(), batchTransactionId.getTimestamp(), ((SpannerOptions)((SpannerImpl)Preconditions.checkNotNull((Object)spanner)).getOptions()).getSpannerRpcV1(), ((SpannerOptions)spanner.getOptions()).getPrefetchChunks());
            this.sessionName = session.getName();
            this.options = session.getOptions();
        }

        @Override
        public BatchTransactionId getBatchTransactionId() {
            return new BatchTransactionId(this.sessionName, this.getTransactionId(), this.getReadTimestamp());
        }

        @Override
        public List<Partition> partitionRead(PartitionOptions partitionOptions, String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) throws SpannerException {
            return this.partitionReadUsingIndex(partitionOptions, table, null, keys, columns, options);
        }

        @Override
        public List<Partition> partitionReadUsingIndex(PartitionOptions partitionOptions, String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... option) throws SpannerException {
            TransactionSelector selector;
            Options readOptions = Options.fromReadOptions(option);
            Preconditions.checkArgument((!readOptions.hasLimit() ? 1 : 0) != 0, (Object)"Limit option not supported by partitionRead|partitionReadUsingIndex");
            PartitionReadRequest.Builder builder = PartitionReadRequest.newBuilder().setSession(this.sessionName).setTable((String)Preconditions.checkNotNull((Object)table)).addAllColumns(columns);
            keys.appendToProto(builder.getKeySetBuilder());
            if (index != null) {
                builder.setIndex(index);
            }
            if ((selector = this.getTransactionSelector()) != null) {
                builder.setTransaction(selector);
            }
            PartitionOptions.Builder pbuilder = com.google.spanner.v1.PartitionOptions.newBuilder();
            if (partitionOptions != null) {
                partitionOptions.appendToProto(pbuilder);
            }
            builder.setPartitionOptions(pbuilder.build());
            PartitionReadRequest request = builder.build();
            PartitionResponse response = this.rpc.partitionRead(request, this.options);
            ImmutableList.Builder partitions = ImmutableList.builder();
            for (com.google.spanner.v1.Partition p : response.getPartitionsList()) {
                Partition partition = Partition.createReadPartition(p.getPartitionToken(), partitionOptions, table, index, keys, columns, readOptions);
                partitions.add((Object)partition);
            }
            return partitions.build();
        }

        @Override
        public List<Partition> partitionQuery(PartitionOptions partitionOptions, Statement statement, Options.QueryOption ... option) throws SpannerException {
            TransactionSelector selector;
            Options queryOptions = Options.fromQueryOptions(option);
            PartitionQueryRequest.Builder builder = PartitionQueryRequest.newBuilder().setSession(this.sessionName).setSql(statement.getSql());
            Map<String, Value> stmtParameters = statement.getParameters();
            if (!stmtParameters.isEmpty()) {
                Struct.Builder paramsBuilder = builder.getParamsBuilder();
                for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                    paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                    builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
                }
            }
            if ((selector = this.getTransactionSelector()) != null) {
                builder.setTransaction(selector);
            }
            PartitionOptions.Builder pbuilder = com.google.spanner.v1.PartitionOptions.newBuilder();
            if (partitionOptions != null) {
                partitionOptions.appendToProto(pbuilder);
            }
            builder.setPartitionOptions(pbuilder.build());
            PartitionQueryRequest request = builder.build();
            PartitionResponse response = this.rpc.partitionQuery(request, this.options);
            ImmutableList.Builder partitions = ImmutableList.builder();
            for (com.google.spanner.v1.Partition p : response.getPartitionsList()) {
                Partition partition = Partition.createQueryPartition(p.getPartitionToken(), partitionOptions, statement, queryOptions);
                partitions.add((Object)partition);
            }
            return partitions.build();
        }

        @Override
        public ResultSet execute(Partition partition) throws SpannerException {
            if (partition.getStatement() != null) {
                return this.executeQueryInternalWithOptions(partition.getStatement(), ExecuteSqlRequest.QueryMode.NORMAL, partition.getQueryOptions(), partition.getPartitionToken());
            }
            return this.readInternalWithOptions(partition.getTable(), partition.getIndex(), partition.getKeys(), partition.getColumns(), partition.getReadOptions(), partition.getPartitionToken());
        }

        @Override
        public void close() {
            super.close();
            this.session.close();
        }
    }
}

