/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicedirectory.v1beta1.CreateEndpointRequest;
import com.google.cloud.servicedirectory.v1beta1.CreateNamespaceRequest;
import com.google.cloud.servicedirectory.v1beta1.CreateServiceRequest;
import com.google.cloud.servicedirectory.v1beta1.DeleteEndpointRequest;
import com.google.cloud.servicedirectory.v1beta1.DeleteNamespaceRequest;
import com.google.cloud.servicedirectory.v1beta1.DeleteServiceRequest;
import com.google.cloud.servicedirectory.v1beta1.Endpoint;
import com.google.cloud.servicedirectory.v1beta1.GetEndpointRequest;
import com.google.cloud.servicedirectory.v1beta1.GetNamespaceRequest;
import com.google.cloud.servicedirectory.v1beta1.GetServiceRequest;
import com.google.cloud.servicedirectory.v1beta1.ListEndpointsRequest;
import com.google.cloud.servicedirectory.v1beta1.ListEndpointsResponse;
import com.google.cloud.servicedirectory.v1beta1.ListNamespacesRequest;
import com.google.cloud.servicedirectory.v1beta1.ListNamespacesResponse;
import com.google.cloud.servicedirectory.v1beta1.ListServicesRequest;
import com.google.cloud.servicedirectory.v1beta1.ListServicesResponse;
import com.google.cloud.servicedirectory.v1beta1.Namespace;
import com.google.cloud.servicedirectory.v1beta1.RegistrationServiceClient;
import com.google.cloud.servicedirectory.v1beta1.Service;
import com.google.cloud.servicedirectory.v1beta1.UpdateEndpointRequest;
import com.google.cloud.servicedirectory.v1beta1.UpdateNamespaceRequest;
import com.google.cloud.servicedirectory.v1beta1.UpdateServiceRequest;
import com.google.cloud.servicedirectory.v1beta1.stub.GrpcRegistrationServiceStub;
import com.google.cloud.servicedirectory.v1beta1.stub.HttpJsonRegistrationServiceStub;
import com.google.cloud.servicedirectory.v1beta1.stub.RegistrationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegistrationServiceStubSettings
extends StubSettings<RegistrationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateNamespaceRequest, Namespace> createNamespaceSettings;
    private final PagedCallSettings<ListNamespacesRequest, ListNamespacesResponse, RegistrationServiceClient.ListNamespacesPagedResponse> listNamespacesSettings;
    private final UnaryCallSettings<GetNamespaceRequest, Namespace> getNamespaceSettings;
    private final UnaryCallSettings<UpdateNamespaceRequest, Namespace> updateNamespaceSettings;
    private final UnaryCallSettings<DeleteNamespaceRequest, Empty> deleteNamespaceSettings;
    private final UnaryCallSettings<CreateServiceRequest, Service> createServiceSettings;
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, RegistrationServiceClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final UnaryCallSettings<UpdateServiceRequest, Service> updateServiceSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Empty> deleteServiceSettings;
    private final UnaryCallSettings<CreateEndpointRequest, Endpoint> createEndpointSettings;
    private final PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, RegistrationServiceClient.ListEndpointsPagedResponse> listEndpointsSettings;
    private final UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings;
    private final UnaryCallSettings<UpdateEndpointRequest, Endpoint> updateEndpointSettings;
    private final UnaryCallSettings<DeleteEndpointRequest, Empty> deleteEndpointSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListNamespacesRequest, ListNamespacesResponse, Namespace> LIST_NAMESPACES_PAGE_STR_DESC = new PagedListDescriptor<ListNamespacesRequest, ListNamespacesResponse, Namespace>(){

        public String emptyToken() {
            return "";
        }

        public ListNamespacesRequest injectToken(ListNamespacesRequest payload, String token) {
            return ListNamespacesRequest.newBuilder((ListNamespacesRequest)payload).setPageToken(token).build();
        }

        public ListNamespacesRequest injectPageSize(ListNamespacesRequest payload, int pageSize) {
            return ListNamespacesRequest.newBuilder((ListNamespacesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNamespacesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNamespacesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Namespace> extractResources(ListNamespacesResponse payload) {
            return payload.getNamespacesList() == null ? ImmutableList.of() : payload.getNamespacesList();
        }
    };
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint> LIST_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint>(){

        public String emptyToken() {
            return "";
        }

        public ListEndpointsRequest injectToken(ListEndpointsRequest payload, String token) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageToken(token).build();
        }

        public ListEndpointsRequest injectPageSize(ListEndpointsRequest payload, int pageSize) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEndpointsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEndpointsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Endpoint> extractResources(ListEndpointsResponse payload) {
            return payload.getEndpointsList() == null ? ImmutableList.of() : payload.getEndpointsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListNamespacesRequest, ListNamespacesResponse, RegistrationServiceClient.ListNamespacesPagedResponse> LIST_NAMESPACES_PAGE_STR_FACT = new PagedListResponseFactory<ListNamespacesRequest, ListNamespacesResponse, RegistrationServiceClient.ListNamespacesPagedResponse>(){

        public ApiFuture<RegistrationServiceClient.ListNamespacesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> callable, ListNamespacesRequest request, ApiCallContext context, ApiFuture<ListNamespacesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NAMESPACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistrationServiceClient.ListNamespacesPagedResponse.createAsync((PageContext<ListNamespacesRequest, ListNamespacesResponse, Namespace>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, RegistrationServiceClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, RegistrationServiceClient.ListServicesPagedResponse>(){

        public ApiFuture<RegistrationServiceClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistrationServiceClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, RegistrationServiceClient.ListEndpointsPagedResponse> LIST_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, RegistrationServiceClient.ListEndpointsPagedResponse>(){

        public ApiFuture<RegistrationServiceClient.ListEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> callable, ListEndpointsRequest request, ApiCallContext context, ApiFuture<ListEndpointsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistrationServiceClient.ListEndpointsPagedResponse.createAsync((PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RegistrationServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, RegistrationServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<RegistrationServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegistrationServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateNamespaceRequest, Namespace> createNamespaceSettings() {
        return this.createNamespaceSettings;
    }

    public PagedCallSettings<ListNamespacesRequest, ListNamespacesResponse, RegistrationServiceClient.ListNamespacesPagedResponse> listNamespacesSettings() {
        return this.listNamespacesSettings;
    }

    public UnaryCallSettings<GetNamespaceRequest, Namespace> getNamespaceSettings() {
        return this.getNamespaceSettings;
    }

    public UnaryCallSettings<UpdateNamespaceRequest, Namespace> updateNamespaceSettings() {
        return this.updateNamespaceSettings;
    }

    public UnaryCallSettings<DeleteNamespaceRequest, Empty> deleteNamespaceSettings() {
        return this.deleteNamespaceSettings;
    }

    public UnaryCallSettings<CreateServiceRequest, Service> createServiceSettings() {
        return this.createServiceSettings;
    }

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, RegistrationServiceClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public UnaryCallSettings<UpdateServiceRequest, Service> updateServiceSettings() {
        return this.updateServiceSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Empty> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public UnaryCallSettings<CreateEndpointRequest, Endpoint> createEndpointSettings() {
        return this.createEndpointSettings;
    }

    public PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, RegistrationServiceClient.ListEndpointsPagedResponse> listEndpointsSettings() {
        return this.listEndpointsSettings;
    }

    public UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings() {
        return this.getEndpointSettings;
    }

    public UnaryCallSettings<UpdateEndpointRequest, Endpoint> updateEndpointSettings() {
        return this.updateEndpointSettings;
    }

    public UnaryCallSettings<DeleteEndpointRequest, Empty> deleteEndpointSettings() {
        return this.deleteEndpointSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, RegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public RegistrationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRegistrationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegistrationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RegistrationServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "servicedirectory";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "servicedirectory.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "servicedirectory.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegistrationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegistrationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegistrationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RegistrationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegistrationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createNamespaceSettings = settingsBuilder.createNamespaceSettings().build();
        this.listNamespacesSettings = settingsBuilder.listNamespacesSettings().build();
        this.getNamespaceSettings = settingsBuilder.getNamespaceSettings().build();
        this.updateNamespaceSettings = settingsBuilder.updateNamespaceSettings().build();
        this.deleteNamespaceSettings = settingsBuilder.deleteNamespaceSettings().build();
        this.createServiceSettings = settingsBuilder.createServiceSettings().build();
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.updateServiceSettings = settingsBuilder.updateServiceSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.createEndpointSettings = settingsBuilder.createEndpointSettings().build();
        this.listEndpointsSettings = settingsBuilder.listEndpointsSettings().build();
        this.getEndpointSettings = settingsBuilder.getEndpointSettings().build();
        this.updateEndpointSettings = settingsBuilder.updateEndpointSettings().build();
        this.deleteEndpointSettings = settingsBuilder.deleteEndpointSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegistrationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateNamespaceRequest, Namespace> createNamespaceSettings;
        private final PagedCallSettings.Builder<ListNamespacesRequest, ListNamespacesResponse, RegistrationServiceClient.ListNamespacesPagedResponse> listNamespacesSettings;
        private final UnaryCallSettings.Builder<GetNamespaceRequest, Namespace> getNamespaceSettings;
        private final UnaryCallSettings.Builder<UpdateNamespaceRequest, Namespace> updateNamespaceSettings;
        private final UnaryCallSettings.Builder<DeleteNamespaceRequest, Empty> deleteNamespaceSettings;
        private final UnaryCallSettings.Builder<CreateServiceRequest, Service> createServiceSettings;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, RegistrationServiceClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final UnaryCallSettings.Builder<UpdateServiceRequest, Service> updateServiceSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Empty> deleteServiceSettings;
        private final UnaryCallSettings.Builder<CreateEndpointRequest, Endpoint> createEndpointSettings;
        private final PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, RegistrationServiceClient.ListEndpointsPagedResponse> listEndpointsSettings;
        private final UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings;
        private final UnaryCallSettings.Builder<UpdateEndpointRequest, Endpoint> updateEndpointSettings;
        private final UnaryCallSettings.Builder<DeleteEndpointRequest, Empty> deleteEndpointSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createNamespaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNamespacesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NAMESPACES_PAGE_STR_FACT);
            this.getNamespaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNamespaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNamespaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENDPOINTS_PAGE_STR_FACT);
            this.getEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createNamespaceSettings, this.listNamespacesSettings, this.getNamespaceSettings, this.updateNamespaceSettings, this.deleteNamespaceSettings, this.createServiceSettings, this.listServicesSettings, this.getServiceSettings, this.updateServiceSettings, this.deleteServiceSettings, this.createEndpointSettings, this.listEndpointsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getEndpointSettings, this.updateEndpointSettings, this.deleteEndpointSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RegistrationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createNamespaceSettings = settings.createNamespaceSettings.toBuilder();
            this.listNamespacesSettings = settings.listNamespacesSettings.toBuilder();
            this.getNamespaceSettings = settings.getNamespaceSettings.toBuilder();
            this.updateNamespaceSettings = settings.updateNamespaceSettings.toBuilder();
            this.deleteNamespaceSettings = settings.deleteNamespaceSettings.toBuilder();
            this.createServiceSettings = settings.createServiceSettings.toBuilder();
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.updateServiceSettings = settings.updateServiceSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.createEndpointSettings = settings.createEndpointSettings.toBuilder();
            this.listEndpointsSettings = settings.listEndpointsSettings.toBuilder();
            this.getEndpointSettings = settings.getEndpointSettings.toBuilder();
            this.updateEndpointSettings = settings.updateEndpointSettings.toBuilder();
            this.deleteEndpointSettings = settings.deleteEndpointSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createNamespaceSettings, this.listNamespacesSettings, this.getNamespaceSettings, this.updateNamespaceSettings, this.deleteNamespaceSettings, this.createServiceSettings, this.listServicesSettings, this.getServiceSettings, this.updateServiceSettings, this.deleteServiceSettings, this.createEndpointSettings, this.listEndpointsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getEndpointSettings, this.updateEndpointSettings, this.deleteEndpointSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegistrationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegistrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegistrationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegistrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RegistrationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RegistrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegistrationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegistrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createNamespaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listNamespacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNamespaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateNamespaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteNamespaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateNamespaceRequest, Namespace> createNamespaceSettings() {
            return this.createNamespaceSettings;
        }

        public PagedCallSettings.Builder<ListNamespacesRequest, ListNamespacesResponse, RegistrationServiceClient.ListNamespacesPagedResponse> listNamespacesSettings() {
            return this.listNamespacesSettings;
        }

        public UnaryCallSettings.Builder<GetNamespaceRequest, Namespace> getNamespaceSettings() {
            return this.getNamespaceSettings;
        }

        public UnaryCallSettings.Builder<UpdateNamespaceRequest, Namespace> updateNamespaceSettings() {
            return this.updateNamespaceSettings;
        }

        public UnaryCallSettings.Builder<DeleteNamespaceRequest, Empty> deleteNamespaceSettings() {
            return this.deleteNamespaceSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceRequest, Service> createServiceSettings() {
            return this.createServiceSettings;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, RegistrationServiceClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceRequest, Service> updateServiceSettings() {
            return this.updateServiceSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Empty> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        public UnaryCallSettings.Builder<CreateEndpointRequest, Endpoint> createEndpointSettings() {
            return this.createEndpointSettings;
        }

        public PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, RegistrationServiceClient.ListEndpointsPagedResponse> listEndpointsSettings() {
            return this.listEndpointsSettings;
        }

        public UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings() {
            return this.getEndpointSettings;
        }

        public UnaryCallSettings.Builder<UpdateEndpointRequest, Endpoint> updateEndpointSettings() {
            return this.updateEndpointSettings;
        }

        public UnaryCallSettings.Builder<DeleteEndpointRequest, Empty> deleteEndpointSettings() {
            return this.deleteEndpointSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, RegistrationServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RegistrationServiceStubSettings.getDefaultEndpoint();
        }

        public RegistrationServiceStubSettings build() throws IOException {
            return new RegistrationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)15000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)15000L)).setTotalTimeout(Duration.ofMillis((long)15000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

