/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.serviceusage.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.serviceusage.v1.BatchEnableServicesRequest;
import com.google.api.serviceusage.v1.BatchEnableServicesResponse;
import com.google.api.serviceusage.v1.BatchGetServicesRequest;
import com.google.api.serviceusage.v1.BatchGetServicesResponse;
import com.google.api.serviceusage.v1.DisableServiceRequest;
import com.google.api.serviceusage.v1.DisableServiceResponse;
import com.google.api.serviceusage.v1.EnableServiceRequest;
import com.google.api.serviceusage.v1.EnableServiceResponse;
import com.google.api.serviceusage.v1.GetServiceRequest;
import com.google.api.serviceusage.v1.ListServicesRequest;
import com.google.api.serviceusage.v1.ListServicesResponse;
import com.google.api.serviceusage.v1.OperationMetadata;
import com.google.api.serviceusage.v1.Service;
import com.google.api.serviceusage.v1.ServiceUsageClient;
import com.google.api.serviceusage.v1.stub.GrpcServiceUsageStub;
import com.google.api.serviceusage.v1.stub.HttpJsonServiceUsageStub;
import com.google.api.serviceusage.v1.stub.ServiceUsageStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ServiceUsageStubSettings
extends StubSettings<ServiceUsageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/service.management").build();
    private final UnaryCallSettings<EnableServiceRequest, Operation> enableServiceSettings;
    private final OperationCallSettings<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationSettings;
    private final UnaryCallSettings<DisableServiceRequest, Operation> disableServiceSettings;
    private final OperationCallSettings<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<BatchEnableServicesRequest, Operation> batchEnableServicesSettings;
    private final OperationCallSettings<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationSettings;
    private final UnaryCallSettings<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse>(){

        public ApiFuture<ServiceUsageClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceUsageClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<EnableServiceRequest, Operation> enableServiceSettings() {
        return this.enableServiceSettings;
    }

    public OperationCallSettings<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationSettings() {
        return this.enableServiceOperationSettings;
    }

    public UnaryCallSettings<DisableServiceRequest, Operation> disableServiceSettings() {
        return this.disableServiceSettings;
    }

    public OperationCallSettings<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationSettings() {
        return this.disableServiceOperationSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<BatchEnableServicesRequest, Operation> batchEnableServicesSettings() {
        return this.batchEnableServicesSettings;
    }

    public OperationCallSettings<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationSettings() {
        return this.batchEnableServicesOperationSettings;
    }

    public UnaryCallSettings<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesSettings() {
        return this.batchGetServicesSettings;
    }

    public ServiceUsageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServiceUsageStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonServiceUsageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "serviceusage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "serviceusage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "serviceusage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServiceUsageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceUsageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceUsageStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ServiceUsageStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServiceUsageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.enableServiceSettings = settingsBuilder.enableServiceSettings().build();
        this.enableServiceOperationSettings = settingsBuilder.enableServiceOperationSettings().build();
        this.disableServiceSettings = settingsBuilder.disableServiceSettings().build();
        this.disableServiceOperationSettings = settingsBuilder.disableServiceOperationSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.batchEnableServicesSettings = settingsBuilder.batchEnableServicesSettings().build();
        this.batchEnableServicesOperationSettings = settingsBuilder.batchEnableServicesOperationSettings().build();
        this.batchGetServicesSettings = settingsBuilder.batchGetServicesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServiceUsageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<EnableServiceRequest, Operation> enableServiceSettings;
        private final OperationCallSettings.Builder<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationSettings;
        private final UnaryCallSettings.Builder<DisableServiceRequest, Operation> disableServiceSettings;
        private final OperationCallSettings.Builder<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<BatchEnableServicesRequest, Operation> batchEnableServicesSettings;
        private final OperationCallSettings.Builder<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationSettings;
        private final UnaryCallSettings.Builder<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.enableServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableServiceOperationSettings = OperationCallSettings.newBuilder();
            this.disableServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableServiceOperationSettings = OperationCallSettings.newBuilder();
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.batchEnableServicesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchEnableServicesOperationSettings = OperationCallSettings.newBuilder();
            this.batchGetServicesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.enableServiceSettings, this.disableServiceSettings, this.getServiceSettings, this.listServicesSettings, this.batchEnableServicesSettings, this.batchGetServicesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ServiceUsageStubSettings settings) {
            super((StubSettings)settings);
            this.enableServiceSettings = settings.enableServiceSettings.toBuilder();
            this.enableServiceOperationSettings = settings.enableServiceOperationSettings.toBuilder();
            this.disableServiceSettings = settings.disableServiceSettings.toBuilder();
            this.disableServiceOperationSettings = settings.disableServiceOperationSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.batchEnableServicesSettings = settings.batchEnableServicesSettings.toBuilder();
            this.batchEnableServicesOperationSettings = settings.batchEnableServicesOperationSettings.toBuilder();
            this.batchGetServicesSettings = settings.batchGetServicesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.enableServiceSettings, this.disableServiceSettings, this.getServiceSettings, this.listServicesSettings, this.batchEnableServicesSettings, this.batchGetServicesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServiceUsageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServiceUsageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceUsageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceUsageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ServiceUsageStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ServiceUsageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceUsageStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceUsageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.enableServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.disableServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.batchEnableServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.batchGetServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.enableServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EnableServiceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.disableServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DisableServiceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.batchEnableServicesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchEnableServicesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<EnableServiceRequest, Operation> enableServiceSettings() {
            return this.enableServiceSettings;
        }

        public OperationCallSettings.Builder<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationSettings() {
            return this.enableServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<DisableServiceRequest, Operation> disableServiceSettings() {
            return this.disableServiceSettings;
        }

        public OperationCallSettings.Builder<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationSettings() {
            return this.disableServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceUsageClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<BatchEnableServicesRequest, Operation> batchEnableServicesSettings() {
            return this.batchEnableServicesSettings;
        }

        public OperationCallSettings.Builder<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationSettings() {
            return this.batchEnableServicesOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesSettings() {
            return this.batchGetServicesSettings;
        }

        public ServiceUsageStubSettings build() throws IOException {
            return new ServiceUsageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

