/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.serviceusage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.serviceusage.v1.BatchEnableServicesRequest;
import com.google.api.serviceusage.v1.BatchEnableServicesResponse;
import com.google.api.serviceusage.v1.BatchGetServicesRequest;
import com.google.api.serviceusage.v1.BatchGetServicesResponse;
import com.google.api.serviceusage.v1.DisableServiceRequest;
import com.google.api.serviceusage.v1.DisableServiceResponse;
import com.google.api.serviceusage.v1.EnableServiceRequest;
import com.google.api.serviceusage.v1.EnableServiceResponse;
import com.google.api.serviceusage.v1.GetServiceRequest;
import com.google.api.serviceusage.v1.ListServicesRequest;
import com.google.api.serviceusage.v1.ListServicesResponse;
import com.google.api.serviceusage.v1.OperationMetadata;
import com.google.api.serviceusage.v1.Service;
import com.google.api.serviceusage.v1.ServiceUsageSettings;
import com.google.api.serviceusage.v1.stub.ServiceUsageStub;
import com.google.api.serviceusage.v1.stub.ServiceUsageStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServiceUsageClient
implements BackgroundResource {
    private final ServiceUsageSettings settings;
    private final ServiceUsageStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ServiceUsageClient create() throws IOException {
        return ServiceUsageClient.create(ServiceUsageSettings.newBuilder().build());
    }

    public static final ServiceUsageClient create(ServiceUsageSettings settings) throws IOException {
        return new ServiceUsageClient(settings);
    }

    public static final ServiceUsageClient create(ServiceUsageStub stub) {
        return new ServiceUsageClient(stub);
    }

    protected ServiceUsageClient(ServiceUsageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServiceUsageStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ServiceUsageClient(ServiceUsageStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ServiceUsageSettings getSettings() {
        return this.settings;
    }

    public ServiceUsageStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<EnableServiceResponse, OperationMetadata> enableServiceAsync(EnableServiceRequest request) {
        return this.enableServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable() {
        return this.stub.enableServiceOperationCallable();
    }

    public final UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable() {
        return this.stub.enableServiceCallable();
    }

    public final OperationFuture<DisableServiceResponse, OperationMetadata> disableServiceAsync(DisableServiceRequest request) {
        return this.disableServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable() {
        return this.stub.disableServiceOperationCallable();
    }

    public final UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable() {
        return this.stub.disableServiceCallable();
    }

    public final Service getService(GetServiceRequest request) {
        return (Service)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final OperationFuture<BatchEnableServicesResponse, OperationMetadata> batchEnableServicesAsync(BatchEnableServicesRequest request) {
        return this.batchEnableServicesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationCallable() {
        return this.stub.batchEnableServicesOperationCallable();
    }

    public final UnaryCallable<BatchEnableServicesRequest, Operation> batchEnableServicesCallable() {
        return this.stub.batchEnableServicesCallable();
    }

    public final BatchGetServicesResponse batchGetServices(BatchGetServicesRequest request) {
        return (BatchGetServicesResponse)this.batchGetServicesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesCallable() {
        return this.stub.batchGetServicesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

