/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.serviceusage.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.serviceusage.v1.BatchEnableServicesRequest;
import com.google.api.serviceusage.v1.BatchEnableServicesResponse;
import com.google.api.serviceusage.v1.BatchGetServicesRequest;
import com.google.api.serviceusage.v1.BatchGetServicesResponse;
import com.google.api.serviceusage.v1.DisableServiceRequest;
import com.google.api.serviceusage.v1.DisableServiceResponse;
import com.google.api.serviceusage.v1.EnableServiceRequest;
import com.google.api.serviceusage.v1.EnableServiceResponse;
import com.google.api.serviceusage.v1.GetServiceRequest;
import com.google.api.serviceusage.v1.ListServicesRequest;
import com.google.api.serviceusage.v1.ListServicesResponse;
import com.google.api.serviceusage.v1.OperationMetadata;
import com.google.api.serviceusage.v1.Service;
import com.google.api.serviceusage.v1.ServiceUsageClient;
import com.google.api.serviceusage.v1.stub.GrpcServiceUsageCallableFactory;
import com.google.api.serviceusage.v1.stub.ServiceUsageStub;
import com.google.api.serviceusage.v1.stub.ServiceUsageStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcServiceUsageStub
extends ServiceUsageStub {
    private static final MethodDescriptor<EnableServiceRequest, Operation> enableServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.serviceusage.v1.ServiceUsage/EnableService").setRequestMarshaller(ProtoUtils.marshaller((Message)EnableServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DisableServiceRequest, Operation> disableServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.serviceusage.v1.ServiceUsage/DisableService").setRequestMarshaller(ProtoUtils.marshaller((Message)DisableServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.serviceusage.v1.ServiceUsage/GetService").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).build();
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.serviceusage.v1.ServiceUsage/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchEnableServicesRequest, Operation> batchEnableServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.serviceusage.v1.ServiceUsage/BatchEnableServices").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchEnableServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.serviceusage.v1.ServiceUsage/BatchGetServices").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchGetServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchGetServicesResponse.getDefaultInstance())).build();
    private final UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable;
    private final OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable;
    private final UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable;
    private final OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, ServiceUsageClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<BatchEnableServicesRequest, Operation> batchEnableServicesCallable;
    private final OperationCallable<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationCallable;
    private final UnaryCallable<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcServiceUsageStub create(ServiceUsageStubSettings settings) throws IOException {
        return new GrpcServiceUsageStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServiceUsageStub create(ClientContext clientContext) throws IOException {
        return new GrpcServiceUsageStub(ServiceUsageStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServiceUsageStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServiceUsageStub(ServiceUsageStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServiceUsageStub(ServiceUsageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServiceUsageCallableFactory());
    }

    protected GrpcServiceUsageStub(ServiceUsageStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings enableServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enableServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings disableServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(disableServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings batchEnableServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchEnableServicesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings batchGetServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchGetServicesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.enableServiceCallable = callableFactory.createUnaryCallable(enableServiceTransportSettings, settings.enableServiceSettings(), clientContext);
        this.enableServiceOperationCallable = callableFactory.createOperationCallable(enableServiceTransportSettings, settings.enableServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.disableServiceCallable = callableFactory.createUnaryCallable(disableServiceTransportSettings, settings.disableServiceSettings(), clientContext);
        this.disableServiceOperationCallable = callableFactory.createOperationCallable(disableServiceTransportSettings, settings.disableServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.batchEnableServicesCallable = callableFactory.createUnaryCallable(batchEnableServicesTransportSettings, settings.batchEnableServicesSettings(), clientContext);
        this.batchEnableServicesOperationCallable = callableFactory.createOperationCallable(batchEnableServicesTransportSettings, settings.batchEnableServicesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.batchGetServicesCallable = callableFactory.createUnaryCallable(batchGetServicesTransportSettings, settings.batchGetServicesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable() {
        return this.enableServiceCallable;
    }

    @Override
    public OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable() {
        return this.enableServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable() {
        return this.disableServiceCallable;
    }

    @Override
    public OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable() {
        return this.disableServiceOperationCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ServiceUsageClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<BatchEnableServicesRequest, Operation> batchEnableServicesCallable() {
        return this.batchEnableServicesCallable;
    }

    @Override
    public OperationCallable<BatchEnableServicesRequest, BatchEnableServicesResponse, OperationMetadata> batchEnableServicesOperationCallable() {
        return this.batchEnableServicesOperationCallable;
    }

    @Override
    public UnaryCallable<BatchGetServicesRequest, BatchGetServicesResponse> batchGetServicesCallable() {
        return this.batchGetServicesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

