/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.servicecontrol.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicecontrol.v1.AllocateQuotaRequest;
import com.google.api.servicecontrol.v1.AllocateQuotaResponse;
import com.google.api.servicecontrol.v1.QuotaControllerSettings;
import com.google.api.servicecontrol.v1.stub.QuotaControllerStub;
import com.google.api.servicecontrol.v1.stub.QuotaControllerStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class QuotaControllerClient
implements BackgroundResource {
    private final QuotaControllerSettings settings;
    private final QuotaControllerStub stub;

    public static final QuotaControllerClient create() throws IOException {
        return QuotaControllerClient.create(QuotaControllerSettings.newBuilder().build());
    }

    public static final QuotaControllerClient create(QuotaControllerSettings settings) throws IOException {
        return new QuotaControllerClient(settings);
    }

    public static final QuotaControllerClient create(QuotaControllerStub stub) {
        return new QuotaControllerClient(stub);
    }

    protected QuotaControllerClient(QuotaControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((QuotaControllerStubSettings)settings.getStubSettings()).createStub();
    }

    protected QuotaControllerClient(QuotaControllerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final QuotaControllerSettings getSettings() {
        return this.settings;
    }

    public QuotaControllerStub getStub() {
        return this.stub;
    }

    public final AllocateQuotaResponse allocateQuota(AllocateQuotaRequest request) {
        return (AllocateQuotaResponse)this.allocateQuotaCallable().call((Object)request);
    }

    public final UnaryCallable<AllocateQuotaRequest, AllocateQuotaResponse> allocateQuotaCallable() {
        return this.stub.allocateQuotaCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

