/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securityposture.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.securityposture.v1.CreatePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.CreatePostureRequest;
import com.google.cloud.securityposture.v1.DeletePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.DeletePostureRequest;
import com.google.cloud.securityposture.v1.ExtractPostureRequest;
import com.google.cloud.securityposture.v1.GetPostureDeploymentRequest;
import com.google.cloud.securityposture.v1.GetPostureRequest;
import com.google.cloud.securityposture.v1.GetPostureTemplateRequest;
import com.google.cloud.securityposture.v1.ListPostureDeploymentsRequest;
import com.google.cloud.securityposture.v1.ListPostureDeploymentsResponse;
import com.google.cloud.securityposture.v1.ListPostureRevisionsRequest;
import com.google.cloud.securityposture.v1.ListPostureRevisionsResponse;
import com.google.cloud.securityposture.v1.ListPostureTemplatesRequest;
import com.google.cloud.securityposture.v1.ListPostureTemplatesResponse;
import com.google.cloud.securityposture.v1.ListPosturesRequest;
import com.google.cloud.securityposture.v1.ListPosturesResponse;
import com.google.cloud.securityposture.v1.OperationMetadata;
import com.google.cloud.securityposture.v1.Posture;
import com.google.cloud.securityposture.v1.PostureDeployment;
import com.google.cloud.securityposture.v1.PostureTemplate;
import com.google.cloud.securityposture.v1.SecurityPostureClient;
import com.google.cloud.securityposture.v1.UpdatePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.UpdatePostureRequest;
import com.google.cloud.securityposture.v1.stub.GrpcSecurityPostureStub;
import com.google.cloud.securityposture.v1.stub.HttpJsonSecurityPostureStub;
import com.google.cloud.securityposture.v1.stub.SecurityPostureStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SecurityPostureStubSettings
extends StubSettings<SecurityPostureStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListPosturesRequest, ListPosturesResponse, SecurityPostureClient.ListPosturesPagedResponse> listPosturesSettings;
    private final PagedCallSettings<ListPostureRevisionsRequest, ListPostureRevisionsResponse, SecurityPostureClient.ListPostureRevisionsPagedResponse> listPostureRevisionsSettings;
    private final UnaryCallSettings<GetPostureRequest, Posture> getPostureSettings;
    private final UnaryCallSettings<CreatePostureRequest, Operation> createPostureSettings;
    private final OperationCallSettings<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationSettings;
    private final UnaryCallSettings<UpdatePostureRequest, Operation> updatePostureSettings;
    private final OperationCallSettings<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationSettings;
    private final UnaryCallSettings<DeletePostureRequest, Operation> deletePostureSettings;
    private final OperationCallSettings<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationSettings;
    private final UnaryCallSettings<ExtractPostureRequest, Operation> extractPostureSettings;
    private final OperationCallSettings<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationSettings;
    private final PagedCallSettings<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, SecurityPostureClient.ListPostureDeploymentsPagedResponse> listPostureDeploymentsSettings;
    private final UnaryCallSettings<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentSettings;
    private final UnaryCallSettings<CreatePostureDeploymentRequest, Operation> createPostureDeploymentSettings;
    private final OperationCallSettings<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationSettings;
    private final UnaryCallSettings<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentSettings;
    private final OperationCallSettings<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationSettings;
    private final UnaryCallSettings<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentSettings;
    private final OperationCallSettings<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationSettings;
    private final PagedCallSettings<ListPostureTemplatesRequest, ListPostureTemplatesResponse, SecurityPostureClient.ListPostureTemplatesPagedResponse> listPostureTemplatesSettings;
    private final UnaryCallSettings<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SecurityPostureClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListPosturesRequest, ListPosturesResponse, Posture> LIST_POSTURES_PAGE_STR_DESC = new PagedListDescriptor<ListPosturesRequest, ListPosturesResponse, Posture>(){

        public String emptyToken() {
            return "";
        }

        public ListPosturesRequest injectToken(ListPosturesRequest payload, String token) {
            return ListPosturesRequest.newBuilder((ListPosturesRequest)payload).setPageToken(token).build();
        }

        public ListPosturesRequest injectPageSize(ListPosturesRequest payload, int pageSize) {
            return ListPosturesRequest.newBuilder((ListPosturesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPosturesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPosturesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Posture> extractResources(ListPosturesResponse payload) {
            return payload.getPosturesList();
        }
    };
    private static final PagedListDescriptor<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture> LIST_POSTURE_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture>(){

        public String emptyToken() {
            return "";
        }

        public ListPostureRevisionsRequest injectToken(ListPostureRevisionsRequest payload, String token) {
            return ListPostureRevisionsRequest.newBuilder((ListPostureRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListPostureRevisionsRequest injectPageSize(ListPostureRevisionsRequest payload, int pageSize) {
            return ListPostureRevisionsRequest.newBuilder((ListPostureRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPostureRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPostureRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Posture> extractResources(ListPostureRevisionsResponse payload) {
            return payload.getRevisionsList();
        }
    };
    private static final PagedListDescriptor<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment> LIST_POSTURE_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment>(){

        public String emptyToken() {
            return "";
        }

        public ListPostureDeploymentsRequest injectToken(ListPostureDeploymentsRequest payload, String token) {
            return ListPostureDeploymentsRequest.newBuilder((ListPostureDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListPostureDeploymentsRequest injectPageSize(ListPostureDeploymentsRequest payload, int pageSize) {
            return ListPostureDeploymentsRequest.newBuilder((ListPostureDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPostureDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPostureDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PostureDeployment> extractResources(ListPostureDeploymentsResponse payload) {
            return payload.getPostureDeploymentsList();
        }
    };
    private static final PagedListDescriptor<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate> LIST_POSTURE_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListPostureTemplatesRequest injectToken(ListPostureTemplatesRequest payload, String token) {
            return ListPostureTemplatesRequest.newBuilder((ListPostureTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListPostureTemplatesRequest injectPageSize(ListPostureTemplatesRequest payload, int pageSize) {
            return ListPostureTemplatesRequest.newBuilder((ListPostureTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPostureTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPostureTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PostureTemplate> extractResources(ListPostureTemplatesResponse payload) {
            return payload.getPostureTemplatesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListPosturesRequest, ListPosturesResponse, SecurityPostureClient.ListPosturesPagedResponse> LIST_POSTURES_PAGE_STR_FACT = new PagedListResponseFactory<ListPosturesRequest, ListPosturesResponse, SecurityPostureClient.ListPosturesPagedResponse>(){

        public ApiFuture<SecurityPostureClient.ListPosturesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPosturesRequest, ListPosturesResponse> callable, ListPosturesRequest request, ApiCallContext context, ApiFuture<ListPosturesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POSTURES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPostureClient.ListPosturesPagedResponse.createAsync((PageContext<ListPosturesRequest, ListPosturesResponse, Posture>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPostureRevisionsRequest, ListPostureRevisionsResponse, SecurityPostureClient.ListPostureRevisionsPagedResponse> LIST_POSTURE_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListPostureRevisionsRequest, ListPostureRevisionsResponse, SecurityPostureClient.ListPostureRevisionsPagedResponse>(){

        public ApiFuture<SecurityPostureClient.ListPostureRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPostureRevisionsRequest, ListPostureRevisionsResponse> callable, ListPostureRevisionsRequest request, ApiCallContext context, ApiFuture<ListPostureRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POSTURE_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPostureClient.ListPostureRevisionsPagedResponse.createAsync((PageContext<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, SecurityPostureClient.ListPostureDeploymentsPagedResponse> LIST_POSTURE_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, SecurityPostureClient.ListPostureDeploymentsPagedResponse>(){

        public ApiFuture<SecurityPostureClient.ListPostureDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse> callable, ListPostureDeploymentsRequest request, ApiCallContext context, ApiFuture<ListPostureDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POSTURE_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPostureClient.ListPostureDeploymentsPagedResponse.createAsync((PageContext<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPostureTemplatesRequest, ListPostureTemplatesResponse, SecurityPostureClient.ListPostureTemplatesPagedResponse> LIST_POSTURE_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListPostureTemplatesRequest, ListPostureTemplatesResponse, SecurityPostureClient.ListPostureTemplatesPagedResponse>(){

        public ApiFuture<SecurityPostureClient.ListPostureTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPostureTemplatesRequest, ListPostureTemplatesResponse> callable, ListPostureTemplatesRequest request, ApiCallContext context, ApiFuture<ListPostureTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POSTURE_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPostureClient.ListPostureTemplatesPagedResponse.createAsync((PageContext<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SecurityPostureClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SecurityPostureClient.ListLocationsPagedResponse>(){

        public ApiFuture<SecurityPostureClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPostureClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListPosturesRequest, ListPosturesResponse, SecurityPostureClient.ListPosturesPagedResponse> listPosturesSettings() {
        return this.listPosturesSettings;
    }

    public PagedCallSettings<ListPostureRevisionsRequest, ListPostureRevisionsResponse, SecurityPostureClient.ListPostureRevisionsPagedResponse> listPostureRevisionsSettings() {
        return this.listPostureRevisionsSettings;
    }

    public UnaryCallSettings<GetPostureRequest, Posture> getPostureSettings() {
        return this.getPostureSettings;
    }

    public UnaryCallSettings<CreatePostureRequest, Operation> createPostureSettings() {
        return this.createPostureSettings;
    }

    public OperationCallSettings<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationSettings() {
        return this.createPostureOperationSettings;
    }

    public UnaryCallSettings<UpdatePostureRequest, Operation> updatePostureSettings() {
        return this.updatePostureSettings;
    }

    public OperationCallSettings<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationSettings() {
        return this.updatePostureOperationSettings;
    }

    public UnaryCallSettings<DeletePostureRequest, Operation> deletePostureSettings() {
        return this.deletePostureSettings;
    }

    public OperationCallSettings<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationSettings() {
        return this.deletePostureOperationSettings;
    }

    public UnaryCallSettings<ExtractPostureRequest, Operation> extractPostureSettings() {
        return this.extractPostureSettings;
    }

    public OperationCallSettings<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationSettings() {
        return this.extractPostureOperationSettings;
    }

    public PagedCallSettings<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, SecurityPostureClient.ListPostureDeploymentsPagedResponse> listPostureDeploymentsSettings() {
        return this.listPostureDeploymentsSettings;
    }

    public UnaryCallSettings<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentSettings() {
        return this.getPostureDeploymentSettings;
    }

    public UnaryCallSettings<CreatePostureDeploymentRequest, Operation> createPostureDeploymentSettings() {
        return this.createPostureDeploymentSettings;
    }

    public OperationCallSettings<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationSettings() {
        return this.createPostureDeploymentOperationSettings;
    }

    public UnaryCallSettings<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentSettings() {
        return this.updatePostureDeploymentSettings;
    }

    public OperationCallSettings<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationSettings() {
        return this.updatePostureDeploymentOperationSettings;
    }

    public UnaryCallSettings<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentSettings() {
        return this.deletePostureDeploymentSettings;
    }

    public OperationCallSettings<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationSettings() {
        return this.deletePostureDeploymentOperationSettings;
    }

    public PagedCallSettings<ListPostureTemplatesRequest, ListPostureTemplatesResponse, SecurityPostureClient.ListPostureTemplatesPagedResponse> listPostureTemplatesSettings() {
        return this.listPostureTemplatesSettings;
    }

    public UnaryCallSettings<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateSettings() {
        return this.getPostureTemplateSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SecurityPostureClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public SecurityPostureStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSecurityPostureStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSecurityPostureStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "securityposture";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "securityposture.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "securityposture.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecurityPostureStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecurityPostureStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecurityPostureStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SecurityPostureStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecurityPostureStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listPosturesSettings = settingsBuilder.listPosturesSettings().build();
        this.listPostureRevisionsSettings = settingsBuilder.listPostureRevisionsSettings().build();
        this.getPostureSettings = settingsBuilder.getPostureSettings().build();
        this.createPostureSettings = settingsBuilder.createPostureSettings().build();
        this.createPostureOperationSettings = settingsBuilder.createPostureOperationSettings().build();
        this.updatePostureSettings = settingsBuilder.updatePostureSettings().build();
        this.updatePostureOperationSettings = settingsBuilder.updatePostureOperationSettings().build();
        this.deletePostureSettings = settingsBuilder.deletePostureSettings().build();
        this.deletePostureOperationSettings = settingsBuilder.deletePostureOperationSettings().build();
        this.extractPostureSettings = settingsBuilder.extractPostureSettings().build();
        this.extractPostureOperationSettings = settingsBuilder.extractPostureOperationSettings().build();
        this.listPostureDeploymentsSettings = settingsBuilder.listPostureDeploymentsSettings().build();
        this.getPostureDeploymentSettings = settingsBuilder.getPostureDeploymentSettings().build();
        this.createPostureDeploymentSettings = settingsBuilder.createPostureDeploymentSettings().build();
        this.createPostureDeploymentOperationSettings = settingsBuilder.createPostureDeploymentOperationSettings().build();
        this.updatePostureDeploymentSettings = settingsBuilder.updatePostureDeploymentSettings().build();
        this.updatePostureDeploymentOperationSettings = settingsBuilder.updatePostureDeploymentOperationSettings().build();
        this.deletePostureDeploymentSettings = settingsBuilder.deletePostureDeploymentSettings().build();
        this.deletePostureDeploymentOperationSettings = settingsBuilder.deletePostureDeploymentOperationSettings().build();
        this.listPostureTemplatesSettings = settingsBuilder.listPostureTemplatesSettings().build();
        this.getPostureTemplateSettings = settingsBuilder.getPostureTemplateSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecurityPostureStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListPosturesRequest, ListPosturesResponse, SecurityPostureClient.ListPosturesPagedResponse> listPosturesSettings;
        private final PagedCallSettings.Builder<ListPostureRevisionsRequest, ListPostureRevisionsResponse, SecurityPostureClient.ListPostureRevisionsPagedResponse> listPostureRevisionsSettings;
        private final UnaryCallSettings.Builder<GetPostureRequest, Posture> getPostureSettings;
        private final UnaryCallSettings.Builder<CreatePostureRequest, Operation> createPostureSettings;
        private final OperationCallSettings.Builder<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePostureRequest, Operation> updatePostureSettings;
        private final OperationCallSettings.Builder<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationSettings;
        private final UnaryCallSettings.Builder<DeletePostureRequest, Operation> deletePostureSettings;
        private final OperationCallSettings.Builder<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationSettings;
        private final UnaryCallSettings.Builder<ExtractPostureRequest, Operation> extractPostureSettings;
        private final OperationCallSettings.Builder<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationSettings;
        private final PagedCallSettings.Builder<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, SecurityPostureClient.ListPostureDeploymentsPagedResponse> listPostureDeploymentsSettings;
        private final UnaryCallSettings.Builder<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentSettings;
        private final UnaryCallSettings.Builder<CreatePostureDeploymentRequest, Operation> createPostureDeploymentSettings;
        private final OperationCallSettings.Builder<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentSettings;
        private final OperationCallSettings.Builder<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationSettings;
        private final UnaryCallSettings.Builder<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentSettings;
        private final OperationCallSettings.Builder<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationSettings;
        private final PagedCallSettings.Builder<ListPostureTemplatesRequest, ListPostureTemplatesResponse, SecurityPostureClient.ListPostureTemplatesPagedResponse> listPostureTemplatesSettings;
        private final UnaryCallSettings.Builder<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SecurityPostureClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listPosturesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POSTURES_PAGE_STR_FACT);
            this.listPostureRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POSTURE_REVISIONS_PAGE_STR_FACT);
            this.getPostureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPostureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPostureOperationSettings = OperationCallSettings.newBuilder();
            this.updatePostureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePostureOperationSettings = OperationCallSettings.newBuilder();
            this.deletePostureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePostureOperationSettings = OperationCallSettings.newBuilder();
            this.extractPostureSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.extractPostureOperationSettings = OperationCallSettings.newBuilder();
            this.listPostureDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POSTURE_DEPLOYMENTS_PAGE_STR_FACT);
            this.getPostureDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPostureDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPostureDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.updatePostureDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePostureDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.deletePostureDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePostureDeploymentOperationSettings = OperationCallSettings.newBuilder();
            this.listPostureTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POSTURE_TEMPLATES_PAGE_STR_FACT);
            this.getPostureTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPosturesSettings, this.listPostureRevisionsSettings, this.getPostureSettings, this.createPostureSettings, this.updatePostureSettings, this.deletePostureSettings, this.extractPostureSettings, this.listPostureDeploymentsSettings, this.getPostureDeploymentSettings, this.createPostureDeploymentSettings, this.updatePostureDeploymentSettings, this.deletePostureDeploymentSettings, (Object[])new UnaryCallSettings.Builder[]{this.listPostureTemplatesSettings, this.getPostureTemplateSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(SecurityPostureStubSettings settings) {
            super((StubSettings)settings);
            this.listPosturesSettings = settings.listPosturesSettings.toBuilder();
            this.listPostureRevisionsSettings = settings.listPostureRevisionsSettings.toBuilder();
            this.getPostureSettings = settings.getPostureSettings.toBuilder();
            this.createPostureSettings = settings.createPostureSettings.toBuilder();
            this.createPostureOperationSettings = settings.createPostureOperationSettings.toBuilder();
            this.updatePostureSettings = settings.updatePostureSettings.toBuilder();
            this.updatePostureOperationSettings = settings.updatePostureOperationSettings.toBuilder();
            this.deletePostureSettings = settings.deletePostureSettings.toBuilder();
            this.deletePostureOperationSettings = settings.deletePostureOperationSettings.toBuilder();
            this.extractPostureSettings = settings.extractPostureSettings.toBuilder();
            this.extractPostureOperationSettings = settings.extractPostureOperationSettings.toBuilder();
            this.listPostureDeploymentsSettings = settings.listPostureDeploymentsSettings.toBuilder();
            this.getPostureDeploymentSettings = settings.getPostureDeploymentSettings.toBuilder();
            this.createPostureDeploymentSettings = settings.createPostureDeploymentSettings.toBuilder();
            this.createPostureDeploymentOperationSettings = settings.createPostureDeploymentOperationSettings.toBuilder();
            this.updatePostureDeploymentSettings = settings.updatePostureDeploymentSettings.toBuilder();
            this.updatePostureDeploymentOperationSettings = settings.updatePostureDeploymentOperationSettings.toBuilder();
            this.deletePostureDeploymentSettings = settings.deletePostureDeploymentSettings.toBuilder();
            this.deletePostureDeploymentOperationSettings = settings.deletePostureDeploymentOperationSettings.toBuilder();
            this.listPostureTemplatesSettings = settings.listPostureTemplatesSettings.toBuilder();
            this.getPostureTemplateSettings = settings.getPostureTemplateSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPosturesSettings, this.listPostureRevisionsSettings, this.getPostureSettings, this.createPostureSettings, this.updatePostureSettings, this.deletePostureSettings, this.extractPostureSettings, this.listPostureDeploymentsSettings, this.getPostureDeploymentSettings, this.createPostureDeploymentSettings, this.updatePostureDeploymentSettings, this.deletePostureDeploymentSettings, (Object[])new UnaryCallSettings.Builder[]{this.listPostureTemplatesSettings, this.getPostureTemplateSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecurityPostureStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecurityPostureStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecurityPostureStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SecurityPostureStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SecurityPostureStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SecurityPostureStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecurityPostureStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SecurityPostureStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listPosturesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPostureRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPostureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPostureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePostureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePostureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.extractPostureSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPostureDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPostureDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPostureDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePostureDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePostureDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPostureTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPostureTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createPostureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Posture.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updatePostureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Posture.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deletePostureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.extractPostureOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Posture.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createPostureDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PostureDeployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updatePostureDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PostureDeployment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deletePostureDeploymentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListPosturesRequest, ListPosturesResponse, SecurityPostureClient.ListPosturesPagedResponse> listPosturesSettings() {
            return this.listPosturesSettings;
        }

        public PagedCallSettings.Builder<ListPostureRevisionsRequest, ListPostureRevisionsResponse, SecurityPostureClient.ListPostureRevisionsPagedResponse> listPostureRevisionsSettings() {
            return this.listPostureRevisionsSettings;
        }

        public UnaryCallSettings.Builder<GetPostureRequest, Posture> getPostureSettings() {
            return this.getPostureSettings;
        }

        public UnaryCallSettings.Builder<CreatePostureRequest, Operation> createPostureSettings() {
            return this.createPostureSettings;
        }

        public OperationCallSettings.Builder<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationSettings() {
            return this.createPostureOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePostureRequest, Operation> updatePostureSettings() {
            return this.updatePostureSettings;
        }

        public OperationCallSettings.Builder<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationSettings() {
            return this.updatePostureOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePostureRequest, Operation> deletePostureSettings() {
            return this.deletePostureSettings;
        }

        public OperationCallSettings.Builder<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationSettings() {
            return this.deletePostureOperationSettings;
        }

        public UnaryCallSettings.Builder<ExtractPostureRequest, Operation> extractPostureSettings() {
            return this.extractPostureSettings;
        }

        public OperationCallSettings.Builder<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationSettings() {
            return this.extractPostureOperationSettings;
        }

        public PagedCallSettings.Builder<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, SecurityPostureClient.ListPostureDeploymentsPagedResponse> listPostureDeploymentsSettings() {
            return this.listPostureDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentSettings() {
            return this.getPostureDeploymentSettings;
        }

        public UnaryCallSettings.Builder<CreatePostureDeploymentRequest, Operation> createPostureDeploymentSettings() {
            return this.createPostureDeploymentSettings;
        }

        public OperationCallSettings.Builder<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationSettings() {
            return this.createPostureDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentSettings() {
            return this.updatePostureDeploymentSettings;
        }

        public OperationCallSettings.Builder<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationSettings() {
            return this.updatePostureDeploymentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentSettings() {
            return this.deletePostureDeploymentSettings;
        }

        public OperationCallSettings.Builder<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationSettings() {
            return this.deletePostureDeploymentOperationSettings;
        }

        public PagedCallSettings.Builder<ListPostureTemplatesRequest, ListPostureTemplatesResponse, SecurityPostureClient.ListPostureTemplatesPagedResponse> listPostureTemplatesSettings() {
            return this.listPostureTemplatesSettings;
        }

        public UnaryCallSettings.Builder<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateSettings() {
            return this.getPostureTemplateSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SecurityPostureClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public SecurityPostureStubSettings build() throws IOException {
            return new SecurityPostureStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

