/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securityposture.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.securityposture.v1.CreatePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.CreatePostureRequest;
import com.google.cloud.securityposture.v1.DeletePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.DeletePostureRequest;
import com.google.cloud.securityposture.v1.ExtractPostureRequest;
import com.google.cloud.securityposture.v1.GetPostureDeploymentRequest;
import com.google.cloud.securityposture.v1.GetPostureRequest;
import com.google.cloud.securityposture.v1.GetPostureTemplateRequest;
import com.google.cloud.securityposture.v1.ListPostureDeploymentsRequest;
import com.google.cloud.securityposture.v1.ListPostureDeploymentsResponse;
import com.google.cloud.securityposture.v1.ListPostureRevisionsRequest;
import com.google.cloud.securityposture.v1.ListPostureRevisionsResponse;
import com.google.cloud.securityposture.v1.ListPostureTemplatesRequest;
import com.google.cloud.securityposture.v1.ListPostureTemplatesResponse;
import com.google.cloud.securityposture.v1.ListPosturesRequest;
import com.google.cloud.securityposture.v1.ListPosturesResponse;
import com.google.cloud.securityposture.v1.OperationMetadata;
import com.google.cloud.securityposture.v1.Posture;
import com.google.cloud.securityposture.v1.PostureDeployment;
import com.google.cloud.securityposture.v1.PostureTemplate;
import com.google.cloud.securityposture.v1.SecurityPostureClient;
import com.google.cloud.securityposture.v1.UpdatePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.UpdatePostureRequest;
import com.google.cloud.securityposture.v1.stub.GrpcSecurityPostureCallableFactory;
import com.google.cloud.securityposture.v1.stub.SecurityPostureStub;
import com.google.cloud.securityposture.v1.stub.SecurityPostureStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSecurityPostureStub
extends SecurityPostureStub {
    private static final MethodDescriptor<ListPosturesRequest, ListPosturesResponse> listPosturesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/ListPostures").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPosturesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPosturesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListPostureRevisionsRequest, ListPostureRevisionsResponse> listPostureRevisionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/ListPostureRevisions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPostureRevisionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPostureRevisionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetPostureRequest, Posture> getPostureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/GetPosture").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPostureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Posture.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreatePostureRequest, Operation> createPostureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/CreatePosture").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePostureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdatePostureRequest, Operation> updatePostureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/UpdatePosture").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePostureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeletePostureRequest, Operation> deletePostureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/DeletePosture").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePostureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ExtractPostureRequest, Operation> extractPostureMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/ExtractPosture").setRequestMarshaller(ProtoUtils.marshaller((Message)ExtractPostureRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse> listPostureDeploymentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/ListPostureDeployments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPostureDeploymentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPostureDeploymentsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/GetPostureDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPostureDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PostureDeployment.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreatePostureDeploymentRequest, Operation> createPostureDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/CreatePostureDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePostureDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/UpdatePostureDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePostureDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/DeletePostureDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePostureDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListPostureTemplatesRequest, ListPostureTemplatesResponse> listPostureTemplatesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/ListPostureTemplates").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPostureTemplatesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPostureTemplatesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.securityposture.v1.SecurityPosture/GetPostureTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPostureTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PostureTemplate.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListPosturesRequest, ListPosturesResponse> listPosturesCallable;
    private final UnaryCallable<ListPosturesRequest, SecurityPostureClient.ListPosturesPagedResponse> listPosturesPagedCallable;
    private final UnaryCallable<ListPostureRevisionsRequest, ListPostureRevisionsResponse> listPostureRevisionsCallable;
    private final UnaryCallable<ListPostureRevisionsRequest, SecurityPostureClient.ListPostureRevisionsPagedResponse> listPostureRevisionsPagedCallable;
    private final UnaryCallable<GetPostureRequest, Posture> getPostureCallable;
    private final UnaryCallable<CreatePostureRequest, Operation> createPostureCallable;
    private final OperationCallable<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationCallable;
    private final UnaryCallable<UpdatePostureRequest, Operation> updatePostureCallable;
    private final OperationCallable<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationCallable;
    private final UnaryCallable<DeletePostureRequest, Operation> deletePostureCallable;
    private final OperationCallable<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationCallable;
    private final UnaryCallable<ExtractPostureRequest, Operation> extractPostureCallable;
    private final OperationCallable<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationCallable;
    private final UnaryCallable<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse> listPostureDeploymentsCallable;
    private final UnaryCallable<ListPostureDeploymentsRequest, SecurityPostureClient.ListPostureDeploymentsPagedResponse> listPostureDeploymentsPagedCallable;
    private final UnaryCallable<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentCallable;
    private final UnaryCallable<CreatePostureDeploymentRequest, Operation> createPostureDeploymentCallable;
    private final OperationCallable<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationCallable;
    private final UnaryCallable<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentCallable;
    private final OperationCallable<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationCallable;
    private final UnaryCallable<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentCallable;
    private final OperationCallable<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationCallable;
    private final UnaryCallable<ListPostureTemplatesRequest, ListPostureTemplatesResponse> listPostureTemplatesCallable;
    private final UnaryCallable<ListPostureTemplatesRequest, SecurityPostureClient.ListPostureTemplatesPagedResponse> listPostureTemplatesPagedCallable;
    private final UnaryCallable<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, SecurityPostureClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSecurityPostureStub create(SecurityPostureStubSettings settings) throws IOException {
        return new GrpcSecurityPostureStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSecurityPostureStub create(ClientContext clientContext) throws IOException {
        return new GrpcSecurityPostureStub(SecurityPostureStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSecurityPostureStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSecurityPostureStub(SecurityPostureStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSecurityPostureStub(SecurityPostureStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSecurityPostureCallableFactory());
    }

    protected GrpcSecurityPostureStub(SecurityPostureStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listPosturesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPosturesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listPostureRevisionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPostureRevisionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getPostureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPostureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPostureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPostureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePostureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePostureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("posture.name", String.valueOf(request.getPosture().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePostureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePostureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings extractPostureTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(extractPostureMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listPostureDeploymentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPostureDeploymentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPostureDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPostureDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPostureDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPostureDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePostureDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePostureDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("posture_deployment.name", String.valueOf(request.getPostureDeployment().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePostureDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePostureDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listPostureTemplatesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPostureTemplatesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPostureTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPostureTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listPosturesCallable = callableFactory.createUnaryCallable(listPosturesTransportSettings, settings.listPosturesSettings(), clientContext);
        this.listPosturesPagedCallable = callableFactory.createPagedCallable(listPosturesTransportSettings, settings.listPosturesSettings(), clientContext);
        this.listPostureRevisionsCallable = callableFactory.createUnaryCallable(listPostureRevisionsTransportSettings, settings.listPostureRevisionsSettings(), clientContext);
        this.listPostureRevisionsPagedCallable = callableFactory.createPagedCallable(listPostureRevisionsTransportSettings, settings.listPostureRevisionsSettings(), clientContext);
        this.getPostureCallable = callableFactory.createUnaryCallable(getPostureTransportSettings, settings.getPostureSettings(), clientContext);
        this.createPostureCallable = callableFactory.createUnaryCallable(createPostureTransportSettings, settings.createPostureSettings(), clientContext);
        this.createPostureOperationCallable = callableFactory.createOperationCallable(createPostureTransportSettings, settings.createPostureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updatePostureCallable = callableFactory.createUnaryCallable(updatePostureTransportSettings, settings.updatePostureSettings(), clientContext);
        this.updatePostureOperationCallable = callableFactory.createOperationCallable(updatePostureTransportSettings, settings.updatePostureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deletePostureCallable = callableFactory.createUnaryCallable(deletePostureTransportSettings, settings.deletePostureSettings(), clientContext);
        this.deletePostureOperationCallable = callableFactory.createOperationCallable(deletePostureTransportSettings, settings.deletePostureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.extractPostureCallable = callableFactory.createUnaryCallable(extractPostureTransportSettings, settings.extractPostureSettings(), clientContext);
        this.extractPostureOperationCallable = callableFactory.createOperationCallable(extractPostureTransportSettings, settings.extractPostureOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listPostureDeploymentsCallable = callableFactory.createUnaryCallable(listPostureDeploymentsTransportSettings, settings.listPostureDeploymentsSettings(), clientContext);
        this.listPostureDeploymentsPagedCallable = callableFactory.createPagedCallable(listPostureDeploymentsTransportSettings, settings.listPostureDeploymentsSettings(), clientContext);
        this.getPostureDeploymentCallable = callableFactory.createUnaryCallable(getPostureDeploymentTransportSettings, settings.getPostureDeploymentSettings(), clientContext);
        this.createPostureDeploymentCallable = callableFactory.createUnaryCallable(createPostureDeploymentTransportSettings, settings.createPostureDeploymentSettings(), clientContext);
        this.createPostureDeploymentOperationCallable = callableFactory.createOperationCallable(createPostureDeploymentTransportSettings, settings.createPostureDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updatePostureDeploymentCallable = callableFactory.createUnaryCallable(updatePostureDeploymentTransportSettings, settings.updatePostureDeploymentSettings(), clientContext);
        this.updatePostureDeploymentOperationCallable = callableFactory.createOperationCallable(updatePostureDeploymentTransportSettings, settings.updatePostureDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deletePostureDeploymentCallable = callableFactory.createUnaryCallable(deletePostureDeploymentTransportSettings, settings.deletePostureDeploymentSettings(), clientContext);
        this.deletePostureDeploymentOperationCallable = callableFactory.createOperationCallable(deletePostureDeploymentTransportSettings, settings.deletePostureDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listPostureTemplatesCallable = callableFactory.createUnaryCallable(listPostureTemplatesTransportSettings, settings.listPostureTemplatesSettings(), clientContext);
        this.listPostureTemplatesPagedCallable = callableFactory.createPagedCallable(listPostureTemplatesTransportSettings, settings.listPostureTemplatesSettings(), clientContext);
        this.getPostureTemplateCallable = callableFactory.createUnaryCallable(getPostureTemplateTransportSettings, settings.getPostureTemplateSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListPosturesRequest, ListPosturesResponse> listPosturesCallable() {
        return this.listPosturesCallable;
    }

    @Override
    public UnaryCallable<ListPosturesRequest, SecurityPostureClient.ListPosturesPagedResponse> listPosturesPagedCallable() {
        return this.listPosturesPagedCallable;
    }

    @Override
    public UnaryCallable<ListPostureRevisionsRequest, ListPostureRevisionsResponse> listPostureRevisionsCallable() {
        return this.listPostureRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListPostureRevisionsRequest, SecurityPostureClient.ListPostureRevisionsPagedResponse> listPostureRevisionsPagedCallable() {
        return this.listPostureRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetPostureRequest, Posture> getPostureCallable() {
        return this.getPostureCallable;
    }

    @Override
    public UnaryCallable<CreatePostureRequest, Operation> createPostureCallable() {
        return this.createPostureCallable;
    }

    @Override
    public OperationCallable<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationCallable() {
        return this.createPostureOperationCallable;
    }

    @Override
    public UnaryCallable<UpdatePostureRequest, Operation> updatePostureCallable() {
        return this.updatePostureCallable;
    }

    @Override
    public OperationCallable<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationCallable() {
        return this.updatePostureOperationCallable;
    }

    @Override
    public UnaryCallable<DeletePostureRequest, Operation> deletePostureCallable() {
        return this.deletePostureCallable;
    }

    @Override
    public OperationCallable<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationCallable() {
        return this.deletePostureOperationCallable;
    }

    @Override
    public UnaryCallable<ExtractPostureRequest, Operation> extractPostureCallable() {
        return this.extractPostureCallable;
    }

    @Override
    public OperationCallable<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationCallable() {
        return this.extractPostureOperationCallable;
    }

    @Override
    public UnaryCallable<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse> listPostureDeploymentsCallable() {
        return this.listPostureDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListPostureDeploymentsRequest, SecurityPostureClient.ListPostureDeploymentsPagedResponse> listPostureDeploymentsPagedCallable() {
        return this.listPostureDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentCallable() {
        return this.getPostureDeploymentCallable;
    }

    @Override
    public UnaryCallable<CreatePostureDeploymentRequest, Operation> createPostureDeploymentCallable() {
        return this.createPostureDeploymentCallable;
    }

    @Override
    public OperationCallable<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationCallable() {
        return this.createPostureDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentCallable() {
        return this.updatePostureDeploymentCallable;
    }

    @Override
    public OperationCallable<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationCallable() {
        return this.updatePostureDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentCallable() {
        return this.deletePostureDeploymentCallable;
    }

    @Override
    public OperationCallable<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationCallable() {
        return this.deletePostureDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<ListPostureTemplatesRequest, ListPostureTemplatesResponse> listPostureTemplatesCallable() {
        return this.listPostureTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListPostureTemplatesRequest, SecurityPostureClient.ListPostureTemplatesPagedResponse> listPostureTemplatesPagedCallable() {
        return this.listPostureTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateCallable() {
        return this.getPostureTemplateCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, SecurityPostureClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

