/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.settings.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.securitycenter.settings.v1beta1.BatchCalculateEffectiveSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.BatchCalculateEffectiveSettingsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.BatchGetSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.BatchGetSettingsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.CalculateEffectiveComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.CalculateEffectiveSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ComponentSettings;
import com.google.cloud.securitycenter.settings.v1beta1.Detector;
import com.google.cloud.securitycenter.settings.v1beta1.GetComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.GetServiceAccountRequest;
import com.google.cloud.securitycenter.settings.v1beta1.GetSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ListComponentsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ListComponentsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.ListDetectorsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ListDetectorsResponse;
import com.google.cloud.securitycenter.settings.v1beta1.ResetComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.ResetSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.SecurityCenterSettingsServiceClient;
import com.google.cloud.securitycenter.settings.v1beta1.ServiceAccount;
import com.google.cloud.securitycenter.settings.v1beta1.Settings;
import com.google.cloud.securitycenter.settings.v1beta1.UpdateComponentSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.UpdateSettingsRequest;
import com.google.cloud.securitycenter.settings.v1beta1.stub.GrpcSecurityCenterSettingsServiceStub;
import com.google.cloud.securitycenter.settings.v1beta1.stub.SecurityCenterSettingsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SecurityCenterSettingsServiceStubSettings
extends StubSettings<SecurityCenterSettingsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings;
    private final UnaryCallSettings<GetSettingsRequest, Settings> getSettingsSettings;
    private final UnaryCallSettings<UpdateSettingsRequest, Settings> updateSettingsSettings;
    private final UnaryCallSettings<ResetSettingsRequest, Empty> resetSettingsSettings;
    private final UnaryCallSettings<BatchGetSettingsRequest, BatchGetSettingsResponse> batchGetSettingsSettings;
    private final UnaryCallSettings<CalculateEffectiveSettingsRequest, Settings> calculateEffectiveSettingsSettings;
    private final UnaryCallSettings<BatchCalculateEffectiveSettingsRequest, BatchCalculateEffectiveSettingsResponse> batchCalculateEffectiveSettingsSettings;
    private final UnaryCallSettings<GetComponentSettingsRequest, ComponentSettings> getComponentSettingsSettings;
    private final UnaryCallSettings<UpdateComponentSettingsRequest, ComponentSettings> updateComponentSettingsSettings;
    private final UnaryCallSettings<ResetComponentSettingsRequest, Empty> resetComponentSettingsSettings;
    private final UnaryCallSettings<CalculateEffectiveComponentSettingsRequest, ComponentSettings> calculateEffectiveComponentSettingsSettings;
    private final PagedCallSettings<ListDetectorsRequest, ListDetectorsResponse, SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse> listDetectorsSettings;
    private final PagedCallSettings<ListComponentsRequest, ListComponentsResponse, SecurityCenterSettingsServiceClient.ListComponentsPagedResponse> listComponentsSettings;
    private static final PagedListDescriptor<ListDetectorsRequest, ListDetectorsResponse, Detector> LIST_DETECTORS_PAGE_STR_DESC = new PagedListDescriptor<ListDetectorsRequest, ListDetectorsResponse, Detector>(){

        public String emptyToken() {
            return "";
        }

        public ListDetectorsRequest injectToken(ListDetectorsRequest payload, String token) {
            return ListDetectorsRequest.newBuilder((ListDetectorsRequest)payload).setPageToken(token).build();
        }

        public ListDetectorsRequest injectPageSize(ListDetectorsRequest payload, int pageSize) {
            return ListDetectorsRequest.newBuilder((ListDetectorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDetectorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDetectorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Detector> extractResources(ListDetectorsResponse payload) {
            return payload.getDetectorsList() == null ? ImmutableList.of() : payload.getDetectorsList();
        }
    };
    private static final PagedListDescriptor<ListComponentsRequest, ListComponentsResponse, String> LIST_COMPONENTS_PAGE_STR_DESC = new PagedListDescriptor<ListComponentsRequest, ListComponentsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListComponentsRequest injectToken(ListComponentsRequest payload, String token) {
            return ListComponentsRequest.newBuilder((ListComponentsRequest)payload).setPageToken(token).build();
        }

        public ListComponentsRequest injectPageSize(ListComponentsRequest payload, int pageSize) {
            return ListComponentsRequest.newBuilder((ListComponentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListComponentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListComponentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListComponentsResponse payload) {
            return payload.getComponentsList() == null ? ImmutableList.of() : payload.getComponentsList();
        }
    };
    private static final PagedListResponseFactory<ListDetectorsRequest, ListDetectorsResponse, SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse> LIST_DETECTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListDetectorsRequest, ListDetectorsResponse, SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse>(){

        public ApiFuture<SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDetectorsRequest, ListDetectorsResponse> callable, ListDetectorsRequest request, ApiCallContext context, ApiFuture<ListDetectorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DETECTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse.createAsync((PageContext<ListDetectorsRequest, ListDetectorsResponse, Detector>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListComponentsRequest, ListComponentsResponse, SecurityCenterSettingsServiceClient.ListComponentsPagedResponse> LIST_COMPONENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListComponentsRequest, ListComponentsResponse, SecurityCenterSettingsServiceClient.ListComponentsPagedResponse>(){

        public ApiFuture<SecurityCenterSettingsServiceClient.ListComponentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListComponentsRequest, ListComponentsResponse> callable, ListComponentsRequest request, ApiCallContext context, ApiFuture<ListComponentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COMPONENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterSettingsServiceClient.ListComponentsPagedResponse.createAsync((PageContext<ListComponentsRequest, ListComponentsResponse, String>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings() {
        return this.getServiceAccountSettings;
    }

    public UnaryCallSettings<GetSettingsRequest, Settings> getSettingsSettings() {
        return this.getSettingsSettings;
    }

    public UnaryCallSettings<UpdateSettingsRequest, Settings> updateSettingsSettings() {
        return this.updateSettingsSettings;
    }

    public UnaryCallSettings<ResetSettingsRequest, Empty> resetSettingsSettings() {
        return this.resetSettingsSettings;
    }

    public UnaryCallSettings<BatchGetSettingsRequest, BatchGetSettingsResponse> batchGetSettingsSettings() {
        return this.batchGetSettingsSettings;
    }

    public UnaryCallSettings<CalculateEffectiveSettingsRequest, Settings> calculateEffectiveSettingsSettings() {
        return this.calculateEffectiveSettingsSettings;
    }

    public UnaryCallSettings<BatchCalculateEffectiveSettingsRequest, BatchCalculateEffectiveSettingsResponse> batchCalculateEffectiveSettingsSettings() {
        return this.batchCalculateEffectiveSettingsSettings;
    }

    public UnaryCallSettings<GetComponentSettingsRequest, ComponentSettings> getComponentSettingsSettings() {
        return this.getComponentSettingsSettings;
    }

    public UnaryCallSettings<UpdateComponentSettingsRequest, ComponentSettings> updateComponentSettingsSettings() {
        return this.updateComponentSettingsSettings;
    }

    public UnaryCallSettings<ResetComponentSettingsRequest, Empty> resetComponentSettingsSettings() {
        return this.resetComponentSettingsSettings;
    }

    public UnaryCallSettings<CalculateEffectiveComponentSettingsRequest, ComponentSettings> calculateEffectiveComponentSettingsSettings() {
        return this.calculateEffectiveComponentSettingsSettings;
    }

    public PagedCallSettings<ListDetectorsRequest, ListDetectorsResponse, SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse> listDetectorsSettings() {
        return this.listDetectorsSettings;
    }

    public PagedCallSettings<ListComponentsRequest, ListComponentsResponse, SecurityCenterSettingsServiceClient.ListComponentsPagedResponse> listComponentsSettings() {
        return this.listComponentsSettings;
    }

    public SecurityCenterSettingsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSecurityCenterSettingsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return SecurityCenterSettingsServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "securitycenter";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "securitycenter.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "securitycenter.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecurityCenterSettingsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecurityCenterSettingsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecurityCenterSettingsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getServiceAccountSettings = settingsBuilder.getServiceAccountSettings().build();
        this.getSettingsSettings = settingsBuilder.getSettingsSettings().build();
        this.updateSettingsSettings = settingsBuilder.updateSettingsSettings().build();
        this.resetSettingsSettings = settingsBuilder.resetSettingsSettings().build();
        this.batchGetSettingsSettings = settingsBuilder.batchGetSettingsSettings().build();
        this.calculateEffectiveSettingsSettings = settingsBuilder.calculateEffectiveSettingsSettings().build();
        this.batchCalculateEffectiveSettingsSettings = settingsBuilder.batchCalculateEffectiveSettingsSettings().build();
        this.getComponentSettingsSettings = settingsBuilder.getComponentSettingsSettings().build();
        this.updateComponentSettingsSettings = settingsBuilder.updateComponentSettingsSettings().build();
        this.resetComponentSettingsSettings = settingsBuilder.resetComponentSettingsSettings().build();
        this.calculateEffectiveComponentSettingsSettings = settingsBuilder.calculateEffectiveComponentSettingsSettings().build();
        this.listDetectorsSettings = settingsBuilder.listDetectorsSettings().build();
        this.listComponentsSettings = settingsBuilder.listComponentsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecurityCenterSettingsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings;
        private final UnaryCallSettings.Builder<GetSettingsRequest, Settings> getSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateSettingsRequest, Settings> updateSettingsSettings;
        private final UnaryCallSettings.Builder<ResetSettingsRequest, Empty> resetSettingsSettings;
        private final UnaryCallSettings.Builder<BatchGetSettingsRequest, BatchGetSettingsResponse> batchGetSettingsSettings;
        private final UnaryCallSettings.Builder<CalculateEffectiveSettingsRequest, Settings> calculateEffectiveSettingsSettings;
        private final UnaryCallSettings.Builder<BatchCalculateEffectiveSettingsRequest, BatchCalculateEffectiveSettingsResponse> batchCalculateEffectiveSettingsSettings;
        private final UnaryCallSettings.Builder<GetComponentSettingsRequest, ComponentSettings> getComponentSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateComponentSettingsRequest, ComponentSettings> updateComponentSettingsSettings;
        private final UnaryCallSettings.Builder<ResetComponentSettingsRequest, Empty> resetComponentSettingsSettings;
        private final UnaryCallSettings.Builder<CalculateEffectiveComponentSettingsRequest, ComponentSettings> calculateEffectiveComponentSettingsSettings;
        private final PagedCallSettings.Builder<ListDetectorsRequest, ListDetectorsResponse, SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse> listDetectorsSettings;
        private final PagedCallSettings.Builder<ListComponentsRequest, ListComponentsResponse, SecurityCenterSettingsServiceClient.ListComponentsPagedResponse> listComponentsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchGetSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.calculateEffectiveSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCalculateEffectiveSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getComponentSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateComponentSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetComponentSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.calculateEffectiveComponentSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDetectorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DETECTORS_PAGE_STR_FACT);
            this.listComponentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COMPONENTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getServiceAccountSettings, this.getSettingsSettings, this.updateSettingsSettings, this.resetSettingsSettings, this.batchGetSettingsSettings, this.calculateEffectiveSettingsSettings, this.batchCalculateEffectiveSettingsSettings, this.getComponentSettingsSettings, this.updateComponentSettingsSettings, this.resetComponentSettingsSettings, this.calculateEffectiveComponentSettingsSettings, this.listDetectorsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listComponentsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(SecurityCenterSettingsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getServiceAccountSettings = settings.getServiceAccountSettings.toBuilder();
            this.getSettingsSettings = settings.getSettingsSettings.toBuilder();
            this.updateSettingsSettings = settings.updateSettingsSettings.toBuilder();
            this.resetSettingsSettings = settings.resetSettingsSettings.toBuilder();
            this.batchGetSettingsSettings = settings.batchGetSettingsSettings.toBuilder();
            this.calculateEffectiveSettingsSettings = settings.calculateEffectiveSettingsSettings.toBuilder();
            this.batchCalculateEffectiveSettingsSettings = settings.batchCalculateEffectiveSettingsSettings.toBuilder();
            this.getComponentSettingsSettings = settings.getComponentSettingsSettings.toBuilder();
            this.updateComponentSettingsSettings = settings.updateComponentSettingsSettings.toBuilder();
            this.resetComponentSettingsSettings = settings.resetComponentSettingsSettings.toBuilder();
            this.calculateEffectiveComponentSettingsSettings = settings.calculateEffectiveComponentSettingsSettings.toBuilder();
            this.listDetectorsSettings = settings.listDetectorsSettings.toBuilder();
            this.listComponentsSettings = settings.listComponentsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getServiceAccountSettings, this.getSettingsSettings, this.updateSettingsSettings, this.resetSettingsSettings, this.batchGetSettingsSettings, this.calculateEffectiveSettingsSettings, this.batchCalculateEffectiveSettingsSettings, this.getComponentSettingsSettings, this.updateComponentSettingsSettings, this.resetComponentSettingsSettings, this.calculateEffectiveComponentSettingsSettings, this.listDetectorsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listComponentsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecurityCenterSettingsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecurityCenterSettingsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecurityCenterSettingsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SecurityCenterSettingsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.resetSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchGetSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.calculateEffectiveSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchCalculateEffectiveSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getComponentSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateComponentSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.resetComponentSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.calculateEffectiveComponentSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDetectorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listComponentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings() {
            return this.getServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<GetSettingsRequest, Settings> getSettingsSettings() {
            return this.getSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSettingsRequest, Settings> updateSettingsSettings() {
            return this.updateSettingsSettings;
        }

        public UnaryCallSettings.Builder<ResetSettingsRequest, Empty> resetSettingsSettings() {
            return this.resetSettingsSettings;
        }

        public UnaryCallSettings.Builder<BatchGetSettingsRequest, BatchGetSettingsResponse> batchGetSettingsSettings() {
            return this.batchGetSettingsSettings;
        }

        public UnaryCallSettings.Builder<CalculateEffectiveSettingsRequest, Settings> calculateEffectiveSettingsSettings() {
            return this.calculateEffectiveSettingsSettings;
        }

        public UnaryCallSettings.Builder<BatchCalculateEffectiveSettingsRequest, BatchCalculateEffectiveSettingsResponse> batchCalculateEffectiveSettingsSettings() {
            return this.batchCalculateEffectiveSettingsSettings;
        }

        public UnaryCallSettings.Builder<GetComponentSettingsRequest, ComponentSettings> getComponentSettingsSettings() {
            return this.getComponentSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateComponentSettingsRequest, ComponentSettings> updateComponentSettingsSettings() {
            return this.updateComponentSettingsSettings;
        }

        public UnaryCallSettings.Builder<ResetComponentSettingsRequest, Empty> resetComponentSettingsSettings() {
            return this.resetComponentSettingsSettings;
        }

        public UnaryCallSettings.Builder<CalculateEffectiveComponentSettingsRequest, ComponentSettings> calculateEffectiveComponentSettingsSettings() {
            return this.calculateEffectiveComponentSettingsSettings;
        }

        public PagedCallSettings.Builder<ListDetectorsRequest, ListDetectorsResponse, SecurityCenterSettingsServiceClient.ListDetectorsPagedResponse> listDetectorsSettings() {
            return this.listDetectorsSettings;
        }

        public PagedCallSettings.Builder<ListComponentsRequest, ListComponentsResponse, SecurityCenterSettingsServiceClient.ListComponentsPagedResponse> listComponentsSettings() {
            return this.listComponentsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return SecurityCenterSettingsServiceStubSettings.getDefaultEndpoint();
        }

        public SecurityCenterSettingsServiceStubSettings build() throws IOException {
            return new SecurityCenterSettingsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

