/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.scheduler.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.scheduler.v1beta1.CloudSchedulerClient;
import com.google.cloud.scheduler.v1beta1.CreateJobRequest;
import com.google.cloud.scheduler.v1beta1.DeleteJobRequest;
import com.google.cloud.scheduler.v1beta1.GetJobRequest;
import com.google.cloud.scheduler.v1beta1.Job;
import com.google.cloud.scheduler.v1beta1.ListJobsRequest;
import com.google.cloud.scheduler.v1beta1.ListJobsResponse;
import com.google.cloud.scheduler.v1beta1.PauseJobRequest;
import com.google.cloud.scheduler.v1beta1.ResumeJobRequest;
import com.google.cloud.scheduler.v1beta1.RunJobRequest;
import com.google.cloud.scheduler.v1beta1.UpdateJobRequest;
import com.google.cloud.scheduler.v1beta1.stub.CloudSchedulerStub;
import com.google.cloud.scheduler.v1beta1.stub.CloudSchedulerStubSettings;
import com.google.cloud.scheduler.v1beta1.stub.HttpJsonCloudSchedulerCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCloudSchedulerStub
extends CloudSchedulerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/ListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/GetJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/CreateJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/UpdateJob").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{job.name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "job.name", (Object)request.getJob().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/DeleteJob").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PauseJobRequest, Job> pauseJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/PauseJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/jobs/*}:pause", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ResumeJobRequest, Job> resumeJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/ResumeJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/jobs/*}:resume", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunJobRequest, Job> runJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.scheduler.v1beta1.CloudScheduler/RunJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{name=projects/*/locations/*/jobs/*}:run", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, CloudSchedulerClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final UnaryCallable<PauseJobRequest, Job> pauseJobCallable;
    private final UnaryCallable<ResumeJobRequest, Job> resumeJobCallable;
    private final UnaryCallable<RunJobRequest, Job> runJobCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudSchedulerStub create(CloudSchedulerStubSettings settings) throws IOException {
        return new HttpJsonCloudSchedulerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudSchedulerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudSchedulerStub(CloudSchedulerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudSchedulerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudSchedulerStub(CloudSchedulerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudSchedulerStub(CloudSchedulerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudSchedulerCallableFactory());
    }

    protected HttpJsonCloudSchedulerStub(CloudSchedulerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings pauseJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(pauseJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings resumeJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resumeJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings runJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.pauseJobCallable = callableFactory.createUnaryCallable(pauseJobTransportSettings, settings.pauseJobSettings(), clientContext);
        this.resumeJobCallable = callableFactory.createUnaryCallable(resumeJobTransportSettings, settings.resumeJobSettings(), clientContext);
        this.runJobCallable = callableFactory.createUnaryCallable(runJobTransportSettings, settings.runJobSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listJobsMethodDescriptor);
        methodDescriptors.add(getJobMethodDescriptor);
        methodDescriptors.add(createJobMethodDescriptor);
        methodDescriptors.add(updateJobMethodDescriptor);
        methodDescriptors.add(deleteJobMethodDescriptor);
        methodDescriptors.add(pauseJobMethodDescriptor);
        methodDescriptors.add(resumeJobMethodDescriptor);
        methodDescriptors.add(runJobMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, CloudSchedulerClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public UnaryCallable<PauseJobRequest, Job> pauseJobCallable() {
        return this.pauseJobCallable;
    }

    @Override
    public UnaryCallable<ResumeJobRequest, Job> resumeJobCallable() {
        return this.resumeJobCallable;
    }

    @Override
    public UnaryCallable<RunJobRequest, Job> runJobCallable() {
        return this.runJobCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

