/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.scheduler.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.scheduler.v1.CloudSchedulerClient;
import com.google.cloud.scheduler.v1.CreateJobRequest;
import com.google.cloud.scheduler.v1.DeleteJobRequest;
import com.google.cloud.scheduler.v1.GetJobRequest;
import com.google.cloud.scheduler.v1.Job;
import com.google.cloud.scheduler.v1.ListJobsRequest;
import com.google.cloud.scheduler.v1.ListJobsResponse;
import com.google.cloud.scheduler.v1.PauseJobRequest;
import com.google.cloud.scheduler.v1.ResumeJobRequest;
import com.google.cloud.scheduler.v1.RunJobRequest;
import com.google.cloud.scheduler.v1.UpdateJobRequest;
import com.google.cloud.scheduler.v1.stub.CloudSchedulerStub;
import com.google.cloud.scheduler.v1.stub.GrpcCloudSchedulerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class CloudSchedulerStubSettings
extends StubSettings<CloudSchedulerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, CloudSchedulerClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<CreateJobRequest, Job> createJobSettings;
    private final UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings;
    private final UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings;
    private final UnaryCallSettings<PauseJobRequest, Job> pauseJobSettings;
    private final UnaryCallSettings<ResumeJobRequest, Job> resumeJobSettings;
    private final UnaryCallSettings<RunJobRequest, Job> runJobSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() != null ? payload.getJobsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, CloudSchedulerClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, CloudSchedulerClient.ListJobsPagedResponse>(){

        public ApiFuture<CloudSchedulerClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudSchedulerClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, CloudSchedulerClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<CreateJobRequest, Job> createJobSettings() {
        return this.createJobSettings;
    }

    public UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings() {
        return this.updateJobSettings;
    }

    public UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings() {
        return this.deleteJobSettings;
    }

    public UnaryCallSettings<PauseJobRequest, Job> pauseJobSettings() {
        return this.pauseJobSettings;
    }

    public UnaryCallSettings<ResumeJobRequest, Job> resumeJobSettings() {
        return this.resumeJobSettings;
    }

    public UnaryCallSettings<RunJobRequest, Job> runJobSettings() {
        return this.runJobSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudSchedulerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudSchedulerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudscheduler.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudSchedulerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudSchedulerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudSchedulerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.createJobSettings = settingsBuilder.createJobSettings().build();
        this.updateJobSettings = settingsBuilder.updateJobSettings().build();
        this.deleteJobSettings = settingsBuilder.deleteJobSettings().build();
        this.pauseJobSettings = settingsBuilder.pauseJobSettings().build();
        this.resumeJobSettings = settingsBuilder.resumeJobSettings().build();
        this.runJobSettings = settingsBuilder.runJobSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudSchedulerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, CloudSchedulerClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings;
        private final UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings;
        private final UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings;
        private final UnaryCallSettings.Builder<PauseJobRequest, Job> pauseJobSettings;
        private final UnaryCallSettings.Builder<ResumeJobRequest, Job> resumeJobSettings;
        private final UnaryCallSettings.Builder<RunJobRequest, Job> runJobSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pauseJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listJobsSettings, this.getJobSettings, this.createJobSettings, this.updateJobSettings, this.deleteJobSettings, this.pauseJobSettings, this.resumeJobSettings, this.runJobSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudSchedulerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudSchedulerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudSchedulerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudSchedulerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.pauseJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resumeJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.runJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(CloudSchedulerStubSettings settings) {
            super((StubSettings)settings);
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.createJobSettings = settings.createJobSettings.toBuilder();
            this.updateJobSettings = settings.updateJobSettings.toBuilder();
            this.deleteJobSettings = settings.deleteJobSettings.toBuilder();
            this.pauseJobSettings = settings.pauseJobSettings.toBuilder();
            this.resumeJobSettings = settings.resumeJobSettings.toBuilder();
            this.runJobSettings = settings.runJobSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listJobsSettings, this.getJobSettings, this.createJobSettings, this.updateJobSettings, this.deleteJobSettings, this.pauseJobSettings, this.resumeJobSettings, this.runJobSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, CloudSchedulerClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings() {
            return this.createJobSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings() {
            return this.updateJobSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings() {
            return this.deleteJobSettings;
        }

        public UnaryCallSettings.Builder<PauseJobRequest, Job> pauseJobSettings() {
            return this.pauseJobSettings;
        }

        public UnaryCallSettings.Builder<ResumeJobRequest, Job> resumeJobSettings() {
            return this.resumeJobSettings;
        }

        public UnaryCallSettings.Builder<RunJobRequest, Job> runJobSettings() {
            return this.runJobSettings;
        }

        public CloudSchedulerStubSettings build() throws IOException {
            return new CloudSchedulerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

