/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.AlertConfig;
import com.google.cloud.retail.v2beta.GetAlertConfigRequest;
import com.google.cloud.retail.v2beta.UpdateAlertConfigRequest;
import com.google.cloud.retail.v2beta.stub.GrpcProjectServiceCallableFactory;
import com.google.cloud.retail.v2beta.stub.ProjectServiceStub;
import com.google.cloud.retail.v2beta.stub.ProjectServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcProjectServiceStub
extends ProjectServiceStub {
    private static final MethodDescriptor<GetAlertConfigRequest, AlertConfig> getAlertConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ProjectService/GetAlertConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAlertConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AlertConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ProjectService/UpdateAlertConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAlertConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AlertConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable;
    private final UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProjectServiceStub create(ProjectServiceStubSettings settings) throws IOException {
        return new GrpcProjectServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProjectServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProjectServiceStub(ProjectServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProjectServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProjectServiceStub(ProjectServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProjectServiceCallableFactory());
    }

    protected GrpcProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAlertConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAlertConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAlertConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAlertConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("alert_config.name", String.valueOf(request.getAlertConfig().getName()));
            return builder.build();
        }).build();
        this.getAlertConfigCallable = callableFactory.createUnaryCallable(getAlertConfigTransportSettings, settings.getAlertConfigSettings(), clientContext);
        this.updateAlertConfigCallable = callableFactory.createUnaryCallable(updateAlertConfigTransportSettings, settings.updateAlertConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable() {
        return this.getAlertConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable() {
        return this.updateAlertConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

