/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.CreateModelMetadata;
import com.google.cloud.retail.v2alpha.CreateModelRequest;
import com.google.cloud.retail.v2alpha.DeleteModelRequest;
import com.google.cloud.retail.v2alpha.GetModelRequest;
import com.google.cloud.retail.v2alpha.ListModelsRequest;
import com.google.cloud.retail.v2alpha.ListModelsResponse;
import com.google.cloud.retail.v2alpha.Model;
import com.google.cloud.retail.v2alpha.ModelServiceClient;
import com.google.cloud.retail.v2alpha.PauseModelRequest;
import com.google.cloud.retail.v2alpha.ResumeModelRequest;
import com.google.cloud.retail.v2alpha.TuneModelMetadata;
import com.google.cloud.retail.v2alpha.TuneModelRequest;
import com.google.cloud.retail.v2alpha.TuneModelResponse;
import com.google.cloud.retail.v2alpha.UpdateModelRequest;
import com.google.cloud.retail.v2alpha.stub.GrpcModelServiceCallableFactory;
import com.google.cloud.retail.v2alpha.stub.ModelServiceStub;
import com.google.cloud.retail.v2alpha.stub.ModelServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcModelServiceStub
extends ModelServiceStub {
    private static final MethodDescriptor<CreateModelRequest, Operation> createModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/CreateModel").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetModelRequest, Model> getModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/GetModel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PauseModelRequest, Model> pauseModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/PauseModel").setRequestMarshaller(ProtoUtils.marshaller((Message)PauseModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ResumeModelRequest, Model> resumeModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/ResumeModel").setRequestMarshaller(ProtoUtils.marshaller((Message)ResumeModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteModelRequest, Empty> deleteModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/DeleteModel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListModelsRequest, ListModelsResponse> listModelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/ListModels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListModelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListModelsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateModelRequest, Model> updateModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/UpdateModel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Model.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TuneModelRequest, Operation> tuneModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ModelService/TuneModel").setRequestMarshaller(ProtoUtils.marshaller((Message)TuneModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateModelRequest, Operation> createModelCallable;
    private final OperationCallable<CreateModelRequest, Model, CreateModelMetadata> createModelOperationCallable;
    private final UnaryCallable<GetModelRequest, Model> getModelCallable;
    private final UnaryCallable<PauseModelRequest, Model> pauseModelCallable;
    private final UnaryCallable<ResumeModelRequest, Model> resumeModelCallable;
    private final UnaryCallable<DeleteModelRequest, Empty> deleteModelCallable;
    private final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable;
    private final UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable;
    private final UnaryCallable<UpdateModelRequest, Model> updateModelCallable;
    private final UnaryCallable<TuneModelRequest, Operation> tuneModelCallable;
    private final OperationCallable<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcModelServiceStub create(ModelServiceStubSettings settings) throws IOException {
        return new GrpcModelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcModelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcModelServiceStub(ModelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcModelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcModelServiceStub(ModelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcModelServiceCallableFactory());
    }

    protected GrpcModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings pauseModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pauseModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings resumeModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resumeModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listModelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listModelsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("model.name", String.valueOf(request.getModel().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings tuneModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(tuneModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createModelCallable = callableFactory.createUnaryCallable(createModelTransportSettings, settings.createModelSettings(), clientContext);
        this.createModelOperationCallable = callableFactory.createOperationCallable(createModelTransportSettings, settings.createModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getModelCallable = callableFactory.createUnaryCallable(getModelTransportSettings, settings.getModelSettings(), clientContext);
        this.pauseModelCallable = callableFactory.createUnaryCallable(pauseModelTransportSettings, settings.pauseModelSettings(), clientContext);
        this.resumeModelCallable = callableFactory.createUnaryCallable(resumeModelTransportSettings, settings.resumeModelSettings(), clientContext);
        this.deleteModelCallable = callableFactory.createUnaryCallable(deleteModelTransportSettings, settings.deleteModelSettings(), clientContext);
        this.listModelsCallable = callableFactory.createUnaryCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.listModelsPagedCallable = callableFactory.createPagedCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.updateModelCallable = callableFactory.createUnaryCallable(updateModelTransportSettings, settings.updateModelSettings(), clientContext);
        this.tuneModelCallable = callableFactory.createUnaryCallable(tuneModelTransportSettings, settings.tuneModelSettings(), clientContext);
        this.tuneModelOperationCallable = callableFactory.createOperationCallable(tuneModelTransportSettings, settings.tuneModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.createModelCallable;
    }

    @Override
    public OperationCallable<CreateModelRequest, Model, CreateModelMetadata> createModelOperationCallable() {
        return this.createModelOperationCallable;
    }

    @Override
    public UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.getModelCallable;
    }

    @Override
    public UnaryCallable<PauseModelRequest, Model> pauseModelCallable() {
        return this.pauseModelCallable;
    }

    @Override
    public UnaryCallable<ResumeModelRequest, Model> resumeModelCallable() {
        return this.resumeModelCallable;
    }

    @Override
    public UnaryCallable<DeleteModelRequest, Empty> deleteModelCallable() {
        return this.deleteModelCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.listModelsCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable() {
        return this.listModelsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.updateModelCallable;
    }

    @Override
    public UnaryCallable<TuneModelRequest, Operation> tuneModelCallable() {
        return this.tuneModelCallable;
    }

    @Override
    public OperationCallable<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationCallable() {
        return this.tuneModelOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

