/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AddCatalogAttributeRequest;
import com.google.cloud.retail.v2alpha.AttributesConfig;
import com.google.cloud.retail.v2alpha.BatchRemoveCatalogAttributesRequest;
import com.google.cloud.retail.v2alpha.BatchRemoveCatalogAttributesResponse;
import com.google.cloud.retail.v2alpha.Catalog;
import com.google.cloud.retail.v2alpha.CatalogServiceClient;
import com.google.cloud.retail.v2alpha.CompletionConfig;
import com.google.cloud.retail.v2alpha.GetAttributesConfigRequest;
import com.google.cloud.retail.v2alpha.GetCompletionConfigRequest;
import com.google.cloud.retail.v2alpha.GetDefaultBranchRequest;
import com.google.cloud.retail.v2alpha.GetDefaultBranchResponse;
import com.google.cloud.retail.v2alpha.ListCatalogsRequest;
import com.google.cloud.retail.v2alpha.ListCatalogsResponse;
import com.google.cloud.retail.v2alpha.RemoveCatalogAttributeRequest;
import com.google.cloud.retail.v2alpha.ReplaceCatalogAttributeRequest;
import com.google.cloud.retail.v2alpha.SetDefaultBranchRequest;
import com.google.cloud.retail.v2alpha.UpdateAttributesConfigRequest;
import com.google.cloud.retail.v2alpha.UpdateCatalogRequest;
import com.google.cloud.retail.v2alpha.UpdateCompletionConfigRequest;
import com.google.cloud.retail.v2alpha.stub.CatalogServiceStub;
import com.google.cloud.retail.v2alpha.stub.CatalogServiceStubSettings;
import com.google.cloud.retail.v2alpha.stub.GrpcCatalogServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCatalogServiceStub
extends CatalogServiceStub {
    private static final MethodDescriptor<ListCatalogsRequest, ListCatalogsResponse> listCatalogsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/ListCatalogs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCatalogsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCatalogsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateCatalogRequest, Catalog> updateCatalogMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/UpdateCatalog").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCatalogRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Catalog.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetDefaultBranchRequest, Empty> setDefaultBranchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/SetDefaultBranch").setRequestMarshaller(ProtoUtils.marshaller((Message)SetDefaultBranchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/GetDefaultBranch").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDefaultBranchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetDefaultBranchResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/GetCompletionConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCompletionConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CompletionConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/UpdateCompletionConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCompletionConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CompletionConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/GetAttributesConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAttributesConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AttributesConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/UpdateAttributesConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAttributesConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AttributesConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/AddCatalogAttribute").setRequestMarshaller(ProtoUtils.marshaller((Message)AddCatalogAttributeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AttributesConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/RemoveCatalogAttribute").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveCatalogAttributeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AttributesConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/BatchRemoveCatalogAttributes").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchRemoveCatalogAttributesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchRemoveCatalogAttributesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.CatalogService/ReplaceCatalogAttribute").setRequestMarshaller(ProtoUtils.marshaller((Message)ReplaceCatalogAttributeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AttributesConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable;
    private final UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable;
    private final UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable;
    private final UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable;
    private final UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable;
    private final UnaryCallable<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigCallable;
    private final UnaryCallable<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigCallable;
    private final UnaryCallable<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigCallable;
    private final UnaryCallable<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigCallable;
    private final UnaryCallable<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeCallable;
    private final UnaryCallable<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeCallable;
    private final UnaryCallable<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesCallable;
    private final UnaryCallable<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCatalogServiceStub create(CatalogServiceStubSettings settings) throws IOException {
        return new GrpcCatalogServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCatalogServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCatalogServiceStub(CatalogServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCatalogServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCatalogServiceStub(CatalogServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCatalogServiceCallableFactory());
    }

    protected GrpcCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listCatalogsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCatalogsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCatalogTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCatalogMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog.name", String.valueOf(request.getCatalog().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setDefaultBranchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setDefaultBranchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        GrpcCallSettings getDefaultBranchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDefaultBranchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        GrpcCallSettings getCompletionConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCompletionConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCompletionConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCompletionConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("completion_config.name", String.valueOf(request.getCompletionConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAttributesConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAttributesConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAttributesConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAttributesConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config.name", String.valueOf(request.getAttributesConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings addCatalogAttributeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addCatalogAttributeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        GrpcCallSettings removeCatalogAttributeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeCatalogAttributeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        GrpcCallSettings batchRemoveCatalogAttributesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchRemoveCatalogAttributesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        GrpcCallSettings replaceCatalogAttributeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(replaceCatalogAttributeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        this.listCatalogsCallable = callableFactory.createUnaryCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.listCatalogsPagedCallable = callableFactory.createPagedCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.updateCatalogCallable = callableFactory.createUnaryCallable(updateCatalogTransportSettings, settings.updateCatalogSettings(), clientContext);
        this.setDefaultBranchCallable = callableFactory.createUnaryCallable(setDefaultBranchTransportSettings, settings.setDefaultBranchSettings(), clientContext);
        this.getDefaultBranchCallable = callableFactory.createUnaryCallable(getDefaultBranchTransportSettings, settings.getDefaultBranchSettings(), clientContext);
        this.getCompletionConfigCallable = callableFactory.createUnaryCallable(getCompletionConfigTransportSettings, settings.getCompletionConfigSettings(), clientContext);
        this.updateCompletionConfigCallable = callableFactory.createUnaryCallable(updateCompletionConfigTransportSettings, settings.updateCompletionConfigSettings(), clientContext);
        this.getAttributesConfigCallable = callableFactory.createUnaryCallable(getAttributesConfigTransportSettings, settings.getAttributesConfigSettings(), clientContext);
        this.updateAttributesConfigCallable = callableFactory.createUnaryCallable(updateAttributesConfigTransportSettings, settings.updateAttributesConfigSettings(), clientContext);
        this.addCatalogAttributeCallable = callableFactory.createUnaryCallable(addCatalogAttributeTransportSettings, settings.addCatalogAttributeSettings(), clientContext);
        this.removeCatalogAttributeCallable = callableFactory.createUnaryCallable(removeCatalogAttributeTransportSettings, settings.removeCatalogAttributeSettings(), clientContext);
        this.batchRemoveCatalogAttributesCallable = callableFactory.createUnaryCallable(batchRemoveCatalogAttributesTransportSettings, settings.batchRemoveCatalogAttributesSettings(), clientContext);
        this.replaceCatalogAttributeCallable = callableFactory.createUnaryCallable(replaceCatalogAttributeTransportSettings, settings.replaceCatalogAttributeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable() {
        return this.listCatalogsCallable;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable() {
        return this.listCatalogsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable() {
        return this.updateCatalogCallable;
    }

    @Override
    public UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable() {
        return this.setDefaultBranchCallable;
    }

    @Override
    public UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable() {
        return this.getDefaultBranchCallable;
    }

    @Override
    public UnaryCallable<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigCallable() {
        return this.getCompletionConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigCallable() {
        return this.updateCompletionConfigCallable;
    }

    @Override
    public UnaryCallable<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigCallable() {
        return this.getAttributesConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigCallable() {
        return this.updateAttributesConfigCallable;
    }

    @Override
    public UnaryCallable<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeCallable() {
        return this.addCatalogAttributeCallable;
    }

    @Override
    public UnaryCallable<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeCallable() {
        return this.removeCatalogAttributeCallable;
    }

    @Override
    public UnaryCallable<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesCallable() {
        return this.batchRemoveCatalogAttributesCallable;
    }

    @Override
    public UnaryCallable<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeCallable() {
        return this.replaceCatalogAttributeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

