/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsRequest;
import com.google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsResponse;
import com.google.cloud.retail.v2.GenerativeQuestionConfig;
import com.google.cloud.retail.v2.GenerativeQuestionsFeatureConfig;
import com.google.cloud.retail.v2.GetGenerativeQuestionsFeatureConfigRequest;
import com.google.cloud.retail.v2.ListGenerativeQuestionConfigsRequest;
import com.google.cloud.retail.v2.ListGenerativeQuestionConfigsResponse;
import com.google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest;
import com.google.cloud.retail.v2.UpdateGenerativeQuestionsFeatureConfigRequest;
import com.google.cloud.retail.v2.stub.GenerativeQuestionServiceStub;
import com.google.cloud.retail.v2.stub.GrpcGenerativeQuestionServiceStub;
import com.google.cloud.retail.v2.stub.HttpJsonGenerativeQuestionServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class GenerativeQuestionServiceStubSettings
extends StubSettings<GenerativeQuestionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<UpdateGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> updateGenerativeQuestionsFeatureConfigSettings;
    private final UnaryCallSettings<GetGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> getGenerativeQuestionsFeatureConfigSettings;
    private final UnaryCallSettings<ListGenerativeQuestionConfigsRequest, ListGenerativeQuestionConfigsResponse> listGenerativeQuestionConfigsSettings;
    private final UnaryCallSettings<UpdateGenerativeQuestionConfigRequest, GenerativeQuestionConfig> updateGenerativeQuestionConfigSettings;
    private final UnaryCallSettings<BatchUpdateGenerativeQuestionConfigsRequest, BatchUpdateGenerativeQuestionConfigsResponse> batchUpdateGenerativeQuestionConfigsSettings;

    public UnaryCallSettings<UpdateGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> updateGenerativeQuestionsFeatureConfigSettings() {
        return this.updateGenerativeQuestionsFeatureConfigSettings;
    }

    public UnaryCallSettings<GetGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> getGenerativeQuestionsFeatureConfigSettings() {
        return this.getGenerativeQuestionsFeatureConfigSettings;
    }

    public UnaryCallSettings<ListGenerativeQuestionConfigsRequest, ListGenerativeQuestionConfigsResponse> listGenerativeQuestionConfigsSettings() {
        return this.listGenerativeQuestionConfigsSettings;
    }

    public UnaryCallSettings<UpdateGenerativeQuestionConfigRequest, GenerativeQuestionConfig> updateGenerativeQuestionConfigSettings() {
        return this.updateGenerativeQuestionConfigSettings;
    }

    public UnaryCallSettings<BatchUpdateGenerativeQuestionConfigsRequest, BatchUpdateGenerativeQuestionConfigsResponse> batchUpdateGenerativeQuestionConfigsSettings() {
        return this.batchUpdateGenerativeQuestionConfigsSettings;
    }

    public GenerativeQuestionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGenerativeQuestionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGenerativeQuestionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GenerativeQuestionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GenerativeQuestionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GenerativeQuestionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GenerativeQuestionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GenerativeQuestionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.updateGenerativeQuestionsFeatureConfigSettings = settingsBuilder.updateGenerativeQuestionsFeatureConfigSettings().build();
        this.getGenerativeQuestionsFeatureConfigSettings = settingsBuilder.getGenerativeQuestionsFeatureConfigSettings().build();
        this.listGenerativeQuestionConfigsSettings = settingsBuilder.listGenerativeQuestionConfigsSettings().build();
        this.updateGenerativeQuestionConfigSettings = settingsBuilder.updateGenerativeQuestionConfigSettings().build();
        this.batchUpdateGenerativeQuestionConfigsSettings = settingsBuilder.batchUpdateGenerativeQuestionConfigsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GenerativeQuestionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<UpdateGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> updateGenerativeQuestionsFeatureConfigSettings;
        private final UnaryCallSettings.Builder<GetGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> getGenerativeQuestionsFeatureConfigSettings;
        private final UnaryCallSettings.Builder<ListGenerativeQuestionConfigsRequest, ListGenerativeQuestionConfigsResponse> listGenerativeQuestionConfigsSettings;
        private final UnaryCallSettings.Builder<UpdateGenerativeQuestionConfigRequest, GenerativeQuestionConfig> updateGenerativeQuestionConfigSettings;
        private final UnaryCallSettings.Builder<BatchUpdateGenerativeQuestionConfigsRequest, BatchUpdateGenerativeQuestionConfigsResponse> batchUpdateGenerativeQuestionConfigsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.updateGenerativeQuestionsFeatureConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGenerativeQuestionsFeatureConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGenerativeQuestionConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGenerativeQuestionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateGenerativeQuestionConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.updateGenerativeQuestionsFeatureConfigSettings, this.getGenerativeQuestionsFeatureConfigSettings, this.listGenerativeQuestionConfigsSettings, this.updateGenerativeQuestionConfigSettings, this.batchUpdateGenerativeQuestionConfigsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GenerativeQuestionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.updateGenerativeQuestionsFeatureConfigSettings = settings.updateGenerativeQuestionsFeatureConfigSettings.toBuilder();
            this.getGenerativeQuestionsFeatureConfigSettings = settings.getGenerativeQuestionsFeatureConfigSettings.toBuilder();
            this.listGenerativeQuestionConfigsSettings = settings.listGenerativeQuestionConfigsSettings.toBuilder();
            this.updateGenerativeQuestionConfigSettings = settings.updateGenerativeQuestionConfigSettings.toBuilder();
            this.batchUpdateGenerativeQuestionConfigsSettings = settings.batchUpdateGenerativeQuestionConfigsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.updateGenerativeQuestionsFeatureConfigSettings, this.getGenerativeQuestionsFeatureConfigSettings, this.listGenerativeQuestionConfigsSettings, this.updateGenerativeQuestionConfigSettings, this.batchUpdateGenerativeQuestionConfigsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GenerativeQuestionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GenerativeQuestionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GenerativeQuestionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GenerativeQuestionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GenerativeQuestionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GenerativeQuestionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GenerativeQuestionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GenerativeQuestionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.updateGenerativeQuestionsFeatureConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGenerativeQuestionsFeatureConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGenerativeQuestionConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateGenerativeQuestionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateGenerativeQuestionConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<UpdateGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> updateGenerativeQuestionsFeatureConfigSettings() {
            return this.updateGenerativeQuestionsFeatureConfigSettings;
        }

        public UnaryCallSettings.Builder<GetGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> getGenerativeQuestionsFeatureConfigSettings() {
            return this.getGenerativeQuestionsFeatureConfigSettings;
        }

        public UnaryCallSettings.Builder<ListGenerativeQuestionConfigsRequest, ListGenerativeQuestionConfigsResponse> listGenerativeQuestionConfigsSettings() {
            return this.listGenerativeQuestionConfigsSettings;
        }

        public UnaryCallSettings.Builder<UpdateGenerativeQuestionConfigRequest, GenerativeQuestionConfig> updateGenerativeQuestionConfigSettings() {
            return this.updateGenerativeQuestionConfigSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateGenerativeQuestionConfigsRequest, BatchUpdateGenerativeQuestionConfigsResponse> batchUpdateGenerativeQuestionConfigsSettings() {
            return this.batchUpdateGenerativeQuestionConfigsSettings;
        }

        public GenerativeQuestionServiceStubSettings build() throws IOException {
            return new GenerativeQuestionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

