/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.PredictRequest;
import com.google.cloud.retail.v2alpha.PredictResponse;
import com.google.cloud.retail.v2alpha.PredictionServiceSettings;
import com.google.cloud.retail.v2alpha.stub.PredictionServiceStub;
import com.google.cloud.retail.v2alpha.stub.PredictionServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PredictionServiceClient
implements BackgroundResource {
    private final PredictionServiceSettings settings;
    private final PredictionServiceStub stub;

    public static final PredictionServiceClient create() throws IOException {
        return PredictionServiceClient.create(PredictionServiceSettings.newBuilder().build());
    }

    public static final PredictionServiceClient create(PredictionServiceSettings settings) throws IOException {
        return new PredictionServiceClient(settings);
    }

    public static final PredictionServiceClient create(PredictionServiceStub stub) {
        return new PredictionServiceClient(stub);
    }

    protected PredictionServiceClient(PredictionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PredictionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PredictionServiceClient(PredictionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PredictionServiceSettings getSettings() {
        return this.settings;
    }

    public PredictionServiceStub getStub() {
        return this.stub;
    }

    public final PredictResponse predict(PredictRequest request) {
        return (PredictResponse)this.predictCallable().call((Object)request);
    }

    public final UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.stub.predictCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

