/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.ExportAnalyticsMetricsRequest;
import com.google.cloud.retail.v2.ExportAnalyticsMetricsResponse;
import com.google.cloud.retail.v2.ExportMetadata;
import com.google.cloud.retail.v2.stub.AnalyticsServiceStub;
import com.google.cloud.retail.v2.stub.AnalyticsServiceStubSettings;
import com.google.cloud.retail.v2.stub.GrpcAnalyticsServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAnalyticsServiceStub
extends AnalyticsServiceStub {
    private static final MethodDescriptor<ExportAnalyticsMetricsRequest, Operation> exportAnalyticsMetricsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.AnalyticsService/ExportAnalyticsMetrics").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportAnalyticsMetricsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ExportAnalyticsMetricsRequest, Operation> exportAnalyticsMetricsCallable;
    private final OperationCallable<ExportAnalyticsMetricsRequest, ExportAnalyticsMetricsResponse, ExportMetadata> exportAnalyticsMetricsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAnalyticsServiceStub create(AnalyticsServiceStubSettings settings) throws IOException {
        return new GrpcAnalyticsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAnalyticsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAnalyticsServiceStub(AnalyticsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAnalyticsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAnalyticsServiceStub(AnalyticsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAnalyticsServiceStub(AnalyticsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAnalyticsServiceCallableFactory());
    }

    protected GrpcAnalyticsServiceStub(AnalyticsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings exportAnalyticsMetricsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportAnalyticsMetricsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        this.exportAnalyticsMetricsCallable = callableFactory.createUnaryCallable(exportAnalyticsMetricsTransportSettings, settings.exportAnalyticsMetricsSettings(), clientContext);
        this.exportAnalyticsMetricsOperationCallable = callableFactory.createOperationCallable(exportAnalyticsMetricsTransportSettings, settings.exportAnalyticsMetricsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ExportAnalyticsMetricsRequest, Operation> exportAnalyticsMetricsCallable() {
        return this.exportAnalyticsMetricsCallable;
    }

    @Override
    public OperationCallable<ExportAnalyticsMetricsRequest, ExportAnalyticsMetricsResponse, ExportMetadata> exportAnalyticsMetricsOperationCallable() {
        return this.exportAnalyticsMetricsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

