/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.Branch;
import com.google.cloud.retail.v2alpha.GetBranchRequest;
import com.google.cloud.retail.v2alpha.ListBranchesRequest;
import com.google.cloud.retail.v2alpha.ListBranchesResponse;
import com.google.cloud.retail.v2alpha.stub.BranchServiceStub;
import com.google.cloud.retail.v2alpha.stub.BranchServiceStubSettings;
import com.google.cloud.retail.v2alpha.stub.GrpcBranchServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcBranchServiceStub
extends BranchServiceStub {
    private static final MethodDescriptor<ListBranchesRequest, ListBranchesResponse> listBranchesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.BranchService/ListBranches").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBranchesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBranchesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBranchRequest, Branch> getBranchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.BranchService/GetBranch").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBranchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Branch.getDefaultInstance())).build();
    private final UnaryCallable<ListBranchesRequest, ListBranchesResponse> listBranchesCallable;
    private final UnaryCallable<GetBranchRequest, Branch> getBranchCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBranchServiceStub create(BranchServiceStubSettings settings) throws IOException {
        return new GrpcBranchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBranchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBranchServiceStub(BranchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBranchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBranchServiceStub(BranchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBranchServiceStub(BranchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBranchServiceCallableFactory());
    }

    protected GrpcBranchServiceStub(BranchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listBranchesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBranchesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getBranchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBranchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listBranchesCallable = callableFactory.createUnaryCallable(listBranchesTransportSettings, settings.listBranchesSettings(), clientContext);
        this.getBranchCallable = callableFactory.createUnaryCallable(getBranchTransportSettings, settings.getBranchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListBranchesRequest, ListBranchesResponse> listBranchesCallable() {
        return this.listBranchesCallable;
    }

    @Override
    public UnaryCallable<GetBranchRequest, Branch> getBranchCallable() {
        return this.getBranchCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

