/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.Control;
import com.google.cloud.retail.v2beta.ControlServiceClient;
import com.google.cloud.retail.v2beta.CreateControlRequest;
import com.google.cloud.retail.v2beta.DeleteControlRequest;
import com.google.cloud.retail.v2beta.GetControlRequest;
import com.google.cloud.retail.v2beta.ListControlsRequest;
import com.google.cloud.retail.v2beta.ListControlsResponse;
import com.google.cloud.retail.v2beta.UpdateControlRequest;
import com.google.cloud.retail.v2beta.stub.ControlServiceStub;
import com.google.cloud.retail.v2beta.stub.GrpcControlServiceStub;
import com.google.cloud.retail.v2beta.stub.HttpJsonControlServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ControlServiceStubSettings
extends StubSettings<ControlServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateControlRequest, Control> createControlSettings;
    private final UnaryCallSettings<DeleteControlRequest, Empty> deleteControlSettings;
    private final UnaryCallSettings<UpdateControlRequest, Control> updateControlSettings;
    private final UnaryCallSettings<GetControlRequest, Control> getControlSettings;
    private final PagedCallSettings<ListControlsRequest, ListControlsResponse, ControlServiceClient.ListControlsPagedResponse> listControlsSettings;
    private static final PagedListDescriptor<ListControlsRequest, ListControlsResponse, Control> LIST_CONTROLS_PAGE_STR_DESC = new PagedListDescriptor<ListControlsRequest, ListControlsResponse, Control>(){

        public String emptyToken() {
            return "";
        }

        public ListControlsRequest injectToken(ListControlsRequest payload, String token) {
            return ListControlsRequest.newBuilder((ListControlsRequest)payload).setPageToken(token).build();
        }

        public ListControlsRequest injectPageSize(ListControlsRequest payload, int pageSize) {
            return ListControlsRequest.newBuilder((ListControlsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListControlsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListControlsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Control> extractResources(ListControlsResponse payload) {
            return payload.getControlsList() == null ? ImmutableList.of() : payload.getControlsList();
        }
    };
    private static final PagedListResponseFactory<ListControlsRequest, ListControlsResponse, ControlServiceClient.ListControlsPagedResponse> LIST_CONTROLS_PAGE_STR_FACT = new PagedListResponseFactory<ListControlsRequest, ListControlsResponse, ControlServiceClient.ListControlsPagedResponse>(){

        public ApiFuture<ControlServiceClient.ListControlsPagedResponse> getFuturePagedResponse(UnaryCallable<ListControlsRequest, ListControlsResponse> callable, ListControlsRequest request, ApiCallContext context, ApiFuture<ListControlsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTROLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ControlServiceClient.ListControlsPagedResponse.createAsync((PageContext<ListControlsRequest, ListControlsResponse, Control>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateControlRequest, Control> createControlSettings() {
        return this.createControlSettings;
    }

    public UnaryCallSettings<DeleteControlRequest, Empty> deleteControlSettings() {
        return this.deleteControlSettings;
    }

    public UnaryCallSettings<UpdateControlRequest, Control> updateControlSettings() {
        return this.updateControlSettings;
    }

    public UnaryCallSettings<GetControlRequest, Control> getControlSettings() {
        return this.getControlSettings;
    }

    public PagedCallSettings<ListControlsRequest, ListControlsResponse, ControlServiceClient.ListControlsPagedResponse> listControlsSettings() {
        return this.listControlsSettings;
    }

    public ControlServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcControlServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonControlServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ControlServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ControlServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ControlServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ControlServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ControlServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createControlSettings = settingsBuilder.createControlSettings().build();
        this.deleteControlSettings = settingsBuilder.deleteControlSettings().build();
        this.updateControlSettings = settingsBuilder.updateControlSettings().build();
        this.getControlSettings = settingsBuilder.getControlSettings().build();
        this.listControlsSettings = settingsBuilder.listControlsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ControlServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateControlRequest, Control> createControlSettings;
        private final UnaryCallSettings.Builder<DeleteControlRequest, Empty> deleteControlSettings;
        private final UnaryCallSettings.Builder<UpdateControlRequest, Control> updateControlSettings;
        private final UnaryCallSettings.Builder<GetControlRequest, Control> getControlSettings;
        private final PagedCallSettings.Builder<ListControlsRequest, ListControlsResponse, ControlServiceClient.ListControlsPagedResponse> listControlsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listControlsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTROLS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createControlSettings, this.deleteControlSettings, this.updateControlSettings, this.getControlSettings, this.listControlsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ControlServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createControlSettings = settings.createControlSettings.toBuilder();
            this.deleteControlSettings = settings.deleteControlSettings.toBuilder();
            this.updateControlSettings = settings.updateControlSettings.toBuilder();
            this.getControlSettings = settings.getControlSettings.toBuilder();
            this.listControlsSettings = settings.listControlsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createControlSettings, this.deleteControlSettings, this.updateControlSettings, this.getControlSettings, this.listControlsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ControlServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ControlServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ControlServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ControlServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ControlServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ControlServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ControlServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ControlServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listControlsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateControlRequest, Control> createControlSettings() {
            return this.createControlSettings;
        }

        public UnaryCallSettings.Builder<DeleteControlRequest, Empty> deleteControlSettings() {
            return this.deleteControlSettings;
        }

        public UnaryCallSettings.Builder<UpdateControlRequest, Control> updateControlSettings() {
            return this.updateControlSettings;
        }

        public UnaryCallSettings.Builder<GetControlRequest, Control> getControlSettings() {
            return this.getControlSettings;
        }

        public PagedCallSettings.Builder<ListControlsRequest, ListControlsResponse, ControlServiceClient.ListControlsPagedResponse> listControlsSettings() {
            return this.listControlsSettings;
        }

        public ControlServiceStubSettings build() throws IOException {
            return new ControlServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

