/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.Catalog;
import com.google.cloud.retail.v2.CatalogServiceClient;
import com.google.cloud.retail.v2.GetDefaultBranchRequest;
import com.google.cloud.retail.v2.GetDefaultBranchResponse;
import com.google.cloud.retail.v2.ListCatalogsRequest;
import com.google.cloud.retail.v2.ListCatalogsResponse;
import com.google.cloud.retail.v2.SetDefaultBranchRequest;
import com.google.cloud.retail.v2.UpdateCatalogRequest;
import com.google.cloud.retail.v2.stub.CatalogServiceStub;
import com.google.cloud.retail.v2.stub.CatalogServiceStubSettings;
import com.google.cloud.retail.v2.stub.HttpJsonCatalogServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCatalogServiceStub
extends CatalogServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListCatalogsRequest, ListCatalogsResponse> listCatalogsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2.CatalogService/ListCatalogs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/catalogs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCatalogsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCatalogRequest, Catalog> updateCatalogMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2.CatalogService/UpdateCatalog").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{catalog.name=projects/*/locations/*/catalogs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog.name", (Object)request.getCatalog().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("catalog", (Message)request.getCatalog())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Catalog.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetDefaultBranchRequest, Empty> setDefaultBranchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2.CatalogService/SetDefaultBranch").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{catalog=projects/*/locations/*/catalogs/*}:setDefaultBranch", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog", (Object)request.getCatalog());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearCatalog().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2.CatalogService/GetDefaultBranch").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{catalog=projects/*/locations/*/catalogs/*}:getDefaultBranch", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog", (Object)request.getCatalog());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GetDefaultBranchResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable;
    private final UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable;
    private final UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable;
    private final UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable;
    private final UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCatalogServiceStub create(CatalogServiceStubSettings settings) throws IOException {
        return new HttpJsonCatalogServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCatalogServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCatalogServiceStub(CatalogServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCatalogServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCatalogServiceStub(CatalogServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCatalogServiceCallableFactory());
    }

    protected HttpJsonCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listCatalogsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCatalogsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCatalogTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCatalogMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setDefaultBranchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setDefaultBranchMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getDefaultBranchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDefaultBranchMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listCatalogsCallable = callableFactory.createUnaryCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.listCatalogsPagedCallable = callableFactory.createPagedCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.updateCatalogCallable = callableFactory.createUnaryCallable(updateCatalogTransportSettings, settings.updateCatalogSettings(), clientContext);
        this.setDefaultBranchCallable = callableFactory.createUnaryCallable(setDefaultBranchTransportSettings, settings.setDefaultBranchSettings(), clientContext);
        this.getDefaultBranchCallable = callableFactory.createUnaryCallable(getDefaultBranchTransportSettings, settings.getDefaultBranchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listCatalogsMethodDescriptor);
        methodDescriptors.add(updateCatalogMethodDescriptor);
        methodDescriptors.add(setDefaultBranchMethodDescriptor);
        methodDescriptors.add(getDefaultBranchMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable() {
        return this.listCatalogsCallable;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable() {
        return this.listCatalogsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable() {
        return this.updateCatalogCallable;
    }

    @Override
    public UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable() {
        return this.setDefaultBranchCallable;
    }

    @Override
    public UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable() {
        return this.getDefaultBranchCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

