/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.retail.v2alpha.CreateMerchantCenterAccountLinkMetadata;
import com.google.cloud.retail.v2alpha.CreateMerchantCenterAccountLinkRequest;
import com.google.cloud.retail.v2alpha.DeleteMerchantCenterAccountLinkRequest;
import com.google.cloud.retail.v2alpha.ListMerchantCenterAccountLinksRequest;
import com.google.cloud.retail.v2alpha.ListMerchantCenterAccountLinksResponse;
import com.google.cloud.retail.v2alpha.MerchantCenterAccountLink;
import com.google.cloud.retail.v2alpha.stub.GrpcMerchantCenterAccountLinkServiceStub;
import com.google.cloud.retail.v2alpha.stub.HttpJsonMerchantCenterAccountLinkServiceStub;
import com.google.cloud.retail.v2alpha.stub.MerchantCenterAccountLinkServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MerchantCenterAccountLinkServiceStubSettings
extends StubSettings<MerchantCenterAccountLinkServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ListMerchantCenterAccountLinksRequest, ListMerchantCenterAccountLinksResponse> listMerchantCenterAccountLinksSettings;
    private final UnaryCallSettings<CreateMerchantCenterAccountLinkRequest, Operation> createMerchantCenterAccountLinkSettings;
    private final OperationCallSettings<CreateMerchantCenterAccountLinkRequest, MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkOperationSettings;
    private final UnaryCallSettings<DeleteMerchantCenterAccountLinkRequest, Empty> deleteMerchantCenterAccountLinkSettings;

    public UnaryCallSettings<ListMerchantCenterAccountLinksRequest, ListMerchantCenterAccountLinksResponse> listMerchantCenterAccountLinksSettings() {
        return this.listMerchantCenterAccountLinksSettings;
    }

    public UnaryCallSettings<CreateMerchantCenterAccountLinkRequest, Operation> createMerchantCenterAccountLinkSettings() {
        return this.createMerchantCenterAccountLinkSettings;
    }

    public OperationCallSettings<CreateMerchantCenterAccountLinkRequest, MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkOperationSettings() {
        return this.createMerchantCenterAccountLinkOperationSettings;
    }

    public UnaryCallSettings<DeleteMerchantCenterAccountLinkRequest, Empty> deleteMerchantCenterAccountLinkSettings() {
        return this.deleteMerchantCenterAccountLinkSettings;
    }

    public MerchantCenterAccountLinkServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMerchantCenterAccountLinkServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMerchantCenterAccountLinkServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MerchantCenterAccountLinkServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MerchantCenterAccountLinkServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MerchantCenterAccountLinkServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MerchantCenterAccountLinkServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MerchantCenterAccountLinkServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listMerchantCenterAccountLinksSettings = settingsBuilder.listMerchantCenterAccountLinksSettings().build();
        this.createMerchantCenterAccountLinkSettings = settingsBuilder.createMerchantCenterAccountLinkSettings().build();
        this.createMerchantCenterAccountLinkOperationSettings = settingsBuilder.createMerchantCenterAccountLinkOperationSettings().build();
        this.deleteMerchantCenterAccountLinkSettings = settingsBuilder.deleteMerchantCenterAccountLinkSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MerchantCenterAccountLinkServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ListMerchantCenterAccountLinksRequest, ListMerchantCenterAccountLinksResponse> listMerchantCenterAccountLinksSettings;
        private final UnaryCallSettings.Builder<CreateMerchantCenterAccountLinkRequest, Operation> createMerchantCenterAccountLinkSettings;
        private final OperationCallSettings.Builder<CreateMerchantCenterAccountLinkRequest, MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMerchantCenterAccountLinkRequest, Empty> deleteMerchantCenterAccountLinkSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listMerchantCenterAccountLinksSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMerchantCenterAccountLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMerchantCenterAccountLinkOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMerchantCenterAccountLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMerchantCenterAccountLinksSettings, this.createMerchantCenterAccountLinkSettings, this.deleteMerchantCenterAccountLinkSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MerchantCenterAccountLinkServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listMerchantCenterAccountLinksSettings = settings.listMerchantCenterAccountLinksSettings.toBuilder();
            this.createMerchantCenterAccountLinkSettings = settings.createMerchantCenterAccountLinkSettings.toBuilder();
            this.createMerchantCenterAccountLinkOperationSettings = settings.createMerchantCenterAccountLinkOperationSettings.toBuilder();
            this.deleteMerchantCenterAccountLinkSettings = settings.deleteMerchantCenterAccountLinkSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMerchantCenterAccountLinksSettings, this.createMerchantCenterAccountLinkSettings, this.deleteMerchantCenterAccountLinkSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MerchantCenterAccountLinkServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MerchantCenterAccountLinkServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MerchantCenterAccountLinkServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MerchantCenterAccountLinkServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MerchantCenterAccountLinkServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MerchantCenterAccountLinkServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MerchantCenterAccountLinkServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MerchantCenterAccountLinkServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MerchantCenterAccountLinkServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MerchantCenterAccountLinkServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listMerchantCenterAccountLinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createMerchantCenterAccountLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteMerchantCenterAccountLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createMerchantCenterAccountLinkOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MerchantCenterAccountLink.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateMerchantCenterAccountLinkMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ListMerchantCenterAccountLinksRequest, ListMerchantCenterAccountLinksResponse> listMerchantCenterAccountLinksSettings() {
            return this.listMerchantCenterAccountLinksSettings;
        }

        public UnaryCallSettings.Builder<CreateMerchantCenterAccountLinkRequest, Operation> createMerchantCenterAccountLinkSettings() {
            return this.createMerchantCenterAccountLinkSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateMerchantCenterAccountLinkRequest, MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkOperationSettings() {
            return this.createMerchantCenterAccountLinkOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMerchantCenterAccountLinkRequest, Empty> deleteMerchantCenterAccountLinkSettings() {
            return this.deleteMerchantCenterAccountLinkSettings;
        }

        public MerchantCenterAccountLinkServiceStubSettings build() throws IOException {
            return new MerchantCenterAccountLinkServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

