/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.SearchRequest;
import com.google.cloud.retail.v2.SearchResponse;
import com.google.cloud.retail.v2.SearchServiceClient;
import com.google.cloud.retail.v2.stub.GrpcSearchServiceCallableFactory;
import com.google.cloud.retail.v2.stub.SearchServiceStub;
import com.google.cloud.retail.v2.stub.SearchServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSearchServiceStub
extends SearchServiceStub {
    private static final MethodDescriptor<SearchRequest, SearchResponse> searchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2.SearchService/Search").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchResponse.getDefaultInstance())).build();
    private final UnaryCallable<SearchRequest, SearchResponse> searchCallable;
    private final UnaryCallable<SearchRequest, SearchServiceClient.SearchPagedResponse> searchPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSearchServiceStub create(SearchServiceStubSettings settings) throws IOException {
        return new GrpcSearchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSearchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSearchServiceStub(SearchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSearchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSearchServiceStub(SearchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSearchServiceStub(SearchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSearchServiceCallableFactory());
    }

    protected GrpcSearchServiceStub(SearchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"placement", (Object)String.valueOf(request.getPlacement()));
            return params.build();
        }).build();
        this.searchCallable = callableFactory.createUnaryCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchPagedCallable = callableFactory.createPagedCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchResponse> searchCallable() {
        return this.searchCallable;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchServiceClient.SearchPagedResponse> searchPagedCallable() {
        return this.searchPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

