/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.retail.v2.CreateProductRequest;
import com.google.cloud.retail.v2.DeleteProductRequest;
import com.google.cloud.retail.v2.GetProductRequest;
import com.google.cloud.retail.v2.ImportMetadata;
import com.google.cloud.retail.v2.ImportProductsRequest;
import com.google.cloud.retail.v2.ImportProductsResponse;
import com.google.cloud.retail.v2.Product;
import com.google.cloud.retail.v2.UpdateProductRequest;
import com.google.cloud.retail.v2.stub.GrpcProductServiceStub;
import com.google.cloud.retail.v2.stub.ProductServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ProductServiceStubSettings
extends StubSettings<ProductServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateProductRequest, Product> createProductSettings;
    private final UnaryCallSettings<GetProductRequest, Product> getProductSettings;
    private final UnaryCallSettings<UpdateProductRequest, Product> updateProductSettings;
    private final UnaryCallSettings<DeleteProductRequest, Empty> deleteProductSettings;
    private final UnaryCallSettings<ImportProductsRequest, Operation> importProductsSettings;
    private final OperationCallSettings<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings;

    public UnaryCallSettings<CreateProductRequest, Product> createProductSettings() {
        return this.createProductSettings;
    }

    public UnaryCallSettings<GetProductRequest, Product> getProductSettings() {
        return this.getProductSettings;
    }

    public UnaryCallSettings<UpdateProductRequest, Product> updateProductSettings() {
        return this.updateProductSettings;
    }

    public UnaryCallSettings<DeleteProductRequest, Empty> deleteProductSettings() {
        return this.deleteProductSettings;
    }

    public UnaryCallSettings<ImportProductsRequest, Operation> importProductsSettings() {
        return this.importProductsSettings;
    }

    public OperationCallSettings<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings() {
        return this.importProductsOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProductServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcProductServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProductServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProductServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProductServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createProductSettings = settingsBuilder.createProductSettings().build();
        this.getProductSettings = settingsBuilder.getProductSettings().build();
        this.updateProductSettings = settingsBuilder.updateProductSettings().build();
        this.deleteProductSettings = settingsBuilder.deleteProductSettings().build();
        this.importProductsSettings = settingsBuilder.importProductsSettings().build();
        this.importProductsOperationSettings = settingsBuilder.importProductsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProductServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateProductRequest, Product> createProductSettings;
        private final UnaryCallSettings.Builder<GetProductRequest, Product> getProductSettings;
        private final UnaryCallSettings.Builder<UpdateProductRequest, Product> updateProductSettings;
        private final UnaryCallSettings.Builder<DeleteProductRequest, Empty> deleteProductSettings;
        private final UnaryCallSettings.Builder<ImportProductsRequest, Operation> importProductsSettings;
        private final OperationCallSettings.Builder<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importProductsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importProductsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createProductSettings, this.getProductSettings, this.updateProductSettings, this.deleteProductSettings, this.importProductsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ProductServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createProductSettings = settings.createProductSettings.toBuilder();
            this.getProductSettings = settings.getProductSettings.toBuilder();
            this.updateProductSettings = settings.updateProductSettings.toBuilder();
            this.deleteProductSettings = settings.deleteProductSettings.toBuilder();
            this.importProductsSettings = settings.importProductsSettings.toBuilder();
            this.importProductsOperationSettings = settings.importProductsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createProductSettings, this.getProductSettings, this.updateProductSettings, this.deleteProductSettings, this.importProductsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProductServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProductServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProductServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ProductServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importProductsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportProductsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateProductRequest, Product> createProductSettings() {
            return this.createProductSettings;
        }

        public UnaryCallSettings.Builder<GetProductRequest, Product> getProductSettings() {
            return this.getProductSettings;
        }

        public UnaryCallSettings.Builder<UpdateProductRequest, Product> updateProductSettings() {
            return this.updateProductSettings;
        }

        public UnaryCallSettings.Builder<DeleteProductRequest, Empty> deleteProductSettings() {
            return this.deleteProductSettings;
        }

        public UnaryCallSettings.Builder<ImportProductsRequest, Operation> importProductsSettings() {
            return this.importProductsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings() {
            return this.importProductsOperationSettings;
        }

        public ProductServiceStubSettings build() throws IOException {
            return new ProductServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

