/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagValueRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagValueMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagValueRequest;
import com.google.cloud.resourcemanager.v3.GetNamespacedTagValueRequest;
import com.google.cloud.resourcemanager.v3.GetTagValueRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesResponse;
import com.google.cloud.resourcemanager.v3.TagValue;
import com.google.cloud.resourcemanager.v3.TagValuesClient;
import com.google.cloud.resourcemanager.v3.UpdateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagValueRequest;
import com.google.cloud.resourcemanager.v3.stub.GrpcTagValuesCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStub;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTagValuesStub
extends TagValuesStub {
    private static final MethodDescriptor<ListTagValuesRequest, ListTagValuesResponse> listTagValuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/ListTagValues").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTagValuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTagValuesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetTagValueRequest, TagValue> getTagValueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/GetTagValue").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTagValueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TagValue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/GetNamespacedTagValue").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNamespacedTagValueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TagValue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateTagValueRequest, Operation> createTagValueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/CreateTagValue").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTagValueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateTagValueRequest, Operation> updateTagValueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/UpdateTagValue").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTagValueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteTagValueRequest, Operation> deleteTagValueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/DeleteTagValue").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTagValueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagValues/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListTagValuesRequest, ListTagValuesResponse> listTagValuesCallable;
    private final UnaryCallable<ListTagValuesRequest, TagValuesClient.ListTagValuesPagedResponse> listTagValuesPagedCallable;
    private final UnaryCallable<GetTagValueRequest, TagValue> getTagValueCallable;
    private final UnaryCallable<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueCallable;
    private final UnaryCallable<CreateTagValueRequest, Operation> createTagValueCallable;
    private final OperationCallable<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationCallable;
    private final UnaryCallable<UpdateTagValueRequest, Operation> updateTagValueCallable;
    private final OperationCallable<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationCallable;
    private final UnaryCallable<DeleteTagValueRequest, Operation> deleteTagValueCallable;
    private final OperationCallable<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTagValuesStub create(TagValuesStubSettings settings) throws IOException {
        return new GrpcTagValuesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTagValuesStub create(ClientContext clientContext) throws IOException {
        return new GrpcTagValuesStub(TagValuesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTagValuesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTagValuesStub(TagValuesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTagValuesStub(TagValuesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTagValuesCallableFactory());
    }

    protected GrpcTagValuesStub(TagValuesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listTagValuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTagValuesMethodDescriptor).build();
        GrpcCallSettings getTagValueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTagValueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getNamespacedTagValueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNamespacedTagValueMethodDescriptor).build();
        GrpcCallSettings createTagValueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTagValueMethodDescriptor).build();
        GrpcCallSettings updateTagValueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTagValueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("tag_value.name", String.valueOf(request.getTagValue().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTagValueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTagValueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listTagValuesCallable = callableFactory.createUnaryCallable(listTagValuesTransportSettings, settings.listTagValuesSettings(), clientContext);
        this.listTagValuesPagedCallable = callableFactory.createPagedCallable(listTagValuesTransportSettings, settings.listTagValuesSettings(), clientContext);
        this.getTagValueCallable = callableFactory.createUnaryCallable(getTagValueTransportSettings, settings.getTagValueSettings(), clientContext);
        this.getNamespacedTagValueCallable = callableFactory.createUnaryCallable(getNamespacedTagValueTransportSettings, settings.getNamespacedTagValueSettings(), clientContext);
        this.createTagValueCallable = callableFactory.createUnaryCallable(createTagValueTransportSettings, settings.createTagValueSettings(), clientContext);
        this.createTagValueOperationCallable = callableFactory.createOperationCallable(createTagValueTransportSettings, settings.createTagValueOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateTagValueCallable = callableFactory.createUnaryCallable(updateTagValueTransportSettings, settings.updateTagValueSettings(), clientContext);
        this.updateTagValueOperationCallable = callableFactory.createOperationCallable(updateTagValueTransportSettings, settings.updateTagValueOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteTagValueCallable = callableFactory.createUnaryCallable(deleteTagValueTransportSettings, settings.deleteTagValueSettings(), clientContext);
        this.deleteTagValueOperationCallable = callableFactory.createOperationCallable(deleteTagValueTransportSettings, settings.deleteTagValueOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListTagValuesRequest, ListTagValuesResponse> listTagValuesCallable() {
        return this.listTagValuesCallable;
    }

    @Override
    public UnaryCallable<ListTagValuesRequest, TagValuesClient.ListTagValuesPagedResponse> listTagValuesPagedCallable() {
        return this.listTagValuesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTagValueRequest, TagValue> getTagValueCallable() {
        return this.getTagValueCallable;
    }

    @Override
    public UnaryCallable<GetNamespacedTagValueRequest, TagValue> getNamespacedTagValueCallable() {
        return this.getNamespacedTagValueCallable;
    }

    @Override
    public UnaryCallable<CreateTagValueRequest, Operation> createTagValueCallable() {
        return this.createTagValueCallable;
    }

    @Override
    public OperationCallable<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationCallable() {
        return this.createTagValueOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTagValueRequest, Operation> updateTagValueCallable() {
        return this.updateTagValueCallable;
    }

    @Override
    public OperationCallable<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationCallable() {
        return this.updateTagValueOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagValueRequest, Operation> deleteTagValueCallable() {
        return this.deleteTagValueCallable;
    }

    @Override
    public OperationCallable<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationCallable() {
        return this.deleteTagValueOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

