/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyRequest;
import com.google.cloud.resourcemanager.v3.GetTagKeyRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysResponse;
import com.google.cloud.resourcemanager.v3.TagKey;
import com.google.cloud.resourcemanager.v3.TagKeysClient;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonTagKeysCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStub;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTagKeysStub
extends TagKeysStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(TagKey.getDescriptor()).add(UpdateTagKeyMetadata.getDescriptor()).add(CreateTagKeyMetadata.getDescriptor()).add(DeleteTagKeyMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListTagKeysRequest, ListTagKeysResponse> listTagKeysMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/ListTagKeys").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/tagKeys", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTagKeysResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTagKeyRequest, TagKey> getTagKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/GetTagKey").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=tagKeys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TagKey.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTagKeyRequest, Operation> createTagKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/CreateTagKey").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/tagKeys", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tagKey", (Message)request.getTagKey())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateTagKeyRequest, Operation> updateTagKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/UpdateTagKey").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{tagKey.name=tagKeys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "tagKey.name", (Object)request.getTagKey().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tagKey", (Message)request.getTagKey())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteTagKeyRequest, Operation> deleteTagKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/DeleteTagKey").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=tagKeys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=tagKeys/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=tagKeys/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=tagKeys/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListTagKeysRequest, ListTagKeysResponse> listTagKeysCallable;
    private final UnaryCallable<ListTagKeysRequest, TagKeysClient.ListTagKeysPagedResponse> listTagKeysPagedCallable;
    private final UnaryCallable<GetTagKeyRequest, TagKey> getTagKeyCallable;
    private final UnaryCallable<CreateTagKeyRequest, Operation> createTagKeyCallable;
    private final OperationCallable<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationCallable;
    private final UnaryCallable<UpdateTagKeyRequest, Operation> updateTagKeyCallable;
    private final OperationCallable<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationCallable;
    private final UnaryCallable<DeleteTagKeyRequest, Operation> deleteTagKeyCallable;
    private final OperationCallable<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTagKeysStub create(TagKeysStubSettings settings) throws IOException {
        return new HttpJsonTagKeysStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTagKeysStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTagKeysStub(TagKeysStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTagKeysStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTagKeysStub(TagKeysStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTagKeysStub(TagKeysStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTagKeysCallableFactory());
    }

    protected HttpJsonTagKeysStub(TagKeysStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listTagKeysTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTagKeysMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTagKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTagKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createTagKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTagKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateTagKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTagKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTagKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTagKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listTagKeysCallable = callableFactory.createUnaryCallable(listTagKeysTransportSettings, settings.listTagKeysSettings(), clientContext);
        this.listTagKeysPagedCallable = callableFactory.createPagedCallable(listTagKeysTransportSettings, settings.listTagKeysSettings(), clientContext);
        this.getTagKeyCallable = callableFactory.createUnaryCallable(getTagKeyTransportSettings, settings.getTagKeySettings(), clientContext);
        this.createTagKeyCallable = callableFactory.createUnaryCallable(createTagKeyTransportSettings, settings.createTagKeySettings(), clientContext);
        this.createTagKeyOperationCallable = callableFactory.createOperationCallable(createTagKeyTransportSettings, settings.createTagKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateTagKeyCallable = callableFactory.createUnaryCallable(updateTagKeyTransportSettings, settings.updateTagKeySettings(), clientContext);
        this.updateTagKeyOperationCallable = callableFactory.createOperationCallable(updateTagKeyTransportSettings, settings.updateTagKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteTagKeyCallable = callableFactory.createUnaryCallable(deleteTagKeyTransportSettings, settings.deleteTagKeySettings(), clientContext);
        this.deleteTagKeyOperationCallable = callableFactory.createOperationCallable(deleteTagKeyTransportSettings, settings.deleteTagKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listTagKeysMethodDescriptor);
        methodDescriptors.add(getTagKeyMethodDescriptor);
        methodDescriptors.add(createTagKeyMethodDescriptor);
        methodDescriptors.add(updateTagKeyMethodDescriptor);
        methodDescriptors.add(deleteTagKeyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListTagKeysRequest, ListTagKeysResponse> listTagKeysCallable() {
        return this.listTagKeysCallable;
    }

    @Override
    public UnaryCallable<ListTagKeysRequest, TagKeysClient.ListTagKeysPagedResponse> listTagKeysPagedCallable() {
        return this.listTagKeysPagedCallable;
    }

    @Override
    public UnaryCallable<GetTagKeyRequest, TagKey> getTagKeyCallable() {
        return this.getTagKeyCallable;
    }

    @Override
    public UnaryCallable<CreateTagKeyRequest, Operation> createTagKeyCallable() {
        return this.createTagKeyCallable;
    }

    @Override
    public OperationCallable<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationCallable() {
        return this.createTagKeyOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTagKeyRequest, Operation> updateTagKeyCallable() {
        return this.updateTagKeyCallable;
    }

    @Override
    public OperationCallable<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationCallable() {
        return this.updateTagKeyOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagKeyRequest, Operation> deleteTagKeyCallable() {
        return this.deleteTagKeyCallable;
    }

    @Override
    public OperationCallable<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationCallable() {
        return this.deleteTagKeyOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

