/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagHoldMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagHoldRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagHoldMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagHoldRequest;
import com.google.cloud.resourcemanager.v3.ListTagHoldsRequest;
import com.google.cloud.resourcemanager.v3.ListTagHoldsResponse;
import com.google.cloud.resourcemanager.v3.TagHold;
import com.google.cloud.resourcemanager.v3.TagHoldsClient;
import com.google.cloud.resourcemanager.v3.stub.GrpcTagHoldsStub;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonTagHoldsStub;
import com.google.cloud.resourcemanager.v3.stub.TagHoldsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TagHoldsStubSettings
extends StubSettings<TagHoldsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateTagHoldRequest, Operation> createTagHoldSettings;
    private final OperationCallSettings<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationSettings;
    private final UnaryCallSettings<DeleteTagHoldRequest, Operation> deleteTagHoldSettings;
    private final OperationCallSettings<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationSettings;
    private final PagedCallSettings<ListTagHoldsRequest, ListTagHoldsResponse, TagHoldsClient.ListTagHoldsPagedResponse> listTagHoldsSettings;
    private static final PagedListDescriptor<ListTagHoldsRequest, ListTagHoldsResponse, TagHold> LIST_TAG_HOLDS_PAGE_STR_DESC = new PagedListDescriptor<ListTagHoldsRequest, ListTagHoldsResponse, TagHold>(){

        public String emptyToken() {
            return "";
        }

        public ListTagHoldsRequest injectToken(ListTagHoldsRequest payload, String token) {
            return ListTagHoldsRequest.newBuilder((ListTagHoldsRequest)payload).setPageToken(token).build();
        }

        public ListTagHoldsRequest injectPageSize(ListTagHoldsRequest payload, int pageSize) {
            return ListTagHoldsRequest.newBuilder((ListTagHoldsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTagHoldsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTagHoldsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TagHold> extractResources(ListTagHoldsResponse payload) {
            return payload.getTagHoldsList() == null ? ImmutableList.of() : payload.getTagHoldsList();
        }
    };
    private static final PagedListResponseFactory<ListTagHoldsRequest, ListTagHoldsResponse, TagHoldsClient.ListTagHoldsPagedResponse> LIST_TAG_HOLDS_PAGE_STR_FACT = new PagedListResponseFactory<ListTagHoldsRequest, ListTagHoldsResponse, TagHoldsClient.ListTagHoldsPagedResponse>(){

        public ApiFuture<TagHoldsClient.ListTagHoldsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTagHoldsRequest, ListTagHoldsResponse> callable, ListTagHoldsRequest request, ApiCallContext context, ApiFuture<ListTagHoldsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAG_HOLDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TagHoldsClient.ListTagHoldsPagedResponse.createAsync((PageContext<ListTagHoldsRequest, ListTagHoldsResponse, TagHold>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTagHoldRequest, Operation> createTagHoldSettings() {
        return this.createTagHoldSettings;
    }

    public OperationCallSettings<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationSettings() {
        return this.createTagHoldOperationSettings;
    }

    public UnaryCallSettings<DeleteTagHoldRequest, Operation> deleteTagHoldSettings() {
        return this.deleteTagHoldSettings;
    }

    public OperationCallSettings<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationSettings() {
        return this.deleteTagHoldOperationSettings;
    }

    public PagedCallSettings<ListTagHoldsRequest, ListTagHoldsResponse, TagHoldsClient.ListTagHoldsPagedResponse> listTagHoldsSettings() {
        return this.listTagHoldsSettings;
    }

    public TagHoldsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTagHoldsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTagHoldsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return TagHoldsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudresourcemanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudresourcemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudresourcemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TagHoldsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TagHoldsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TagHoldsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TagHoldsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TagHoldsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTagHoldSettings = settingsBuilder.createTagHoldSettings().build();
        this.createTagHoldOperationSettings = settingsBuilder.createTagHoldOperationSettings().build();
        this.deleteTagHoldSettings = settingsBuilder.deleteTagHoldSettings().build();
        this.deleteTagHoldOperationSettings = settingsBuilder.deleteTagHoldOperationSettings().build();
        this.listTagHoldsSettings = settingsBuilder.listTagHoldsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TagHoldsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTagHoldRequest, Operation> createTagHoldSettings;
        private final OperationCallSettings.Builder<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTagHoldRequest, Operation> deleteTagHoldSettings;
        private final OperationCallSettings.Builder<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationSettings;
        private final PagedCallSettings.Builder<ListTagHoldsRequest, ListTagHoldsResponse, TagHoldsClient.ListTagHoldsPagedResponse> listTagHoldsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTagHoldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagHoldOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTagHoldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagHoldOperationSettings = OperationCallSettings.newBuilder();
            this.listTagHoldsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAG_HOLDS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTagHoldSettings, this.deleteTagHoldSettings, this.listTagHoldsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TagHoldsStubSettings settings) {
            super((StubSettings)settings);
            this.createTagHoldSettings = settings.createTagHoldSettings.toBuilder();
            this.createTagHoldOperationSettings = settings.createTagHoldOperationSettings.toBuilder();
            this.deleteTagHoldSettings = settings.deleteTagHoldSettings.toBuilder();
            this.deleteTagHoldOperationSettings = settings.deleteTagHoldOperationSettings.toBuilder();
            this.listTagHoldsSettings = settings.listTagHoldsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTagHoldSettings, this.deleteTagHoldSettings, this.listTagHoldsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TagHoldsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TagHoldsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TagHoldsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TagHoldsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TagHoldsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TagHoldsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TagHoldsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TagHoldsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTagHoldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTagHoldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTagHoldsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTagHoldOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagHold.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTagHoldMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTagHoldOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteTagHoldMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTagHoldRequest, Operation> createTagHoldSettings() {
            return this.createTagHoldSettings;
        }

        public OperationCallSettings.Builder<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationSettings() {
            return this.createTagHoldOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagHoldRequest, Operation> deleteTagHoldSettings() {
            return this.deleteTagHoldSettings;
        }

        public OperationCallSettings.Builder<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationSettings() {
            return this.deleteTagHoldOperationSettings;
        }

        public PagedCallSettings.Builder<ListTagHoldsRequest, ListTagHoldsResponse, TagHoldsClient.ListTagHoldsPagedResponse> listTagHoldsSettings() {
            return this.listTagHoldsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return TagHoldsStubSettings.getDefaultEndpoint();
        }

        public TagHoldsStubSettings build() throws IOException {
            return new TagHoldsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

